package org.lsst.ccs.bootstrap.resources;

import java.util.Properties;

/**
 *
 * @author turri
 */
public class ResourcesTreeProperties extends Properties {
    
    private String resourceDirectory, propertyFileName;
    private Properties parent;
    
    public ResourcesTreeProperties(String propertyFileName, String resourceDirectory, Properties parent) {
        super(parent);
        this.resourceDirectory = resourceDirectory;
        this.propertyFileName = propertyFileName;
        this.parent = parent;
    }

    public String getResourceDirectory() {
        return resourceDirectory;
    }

    public String getPropertyFileName() {
        return propertyFileName;
    }
    
    public boolean hasParent() {
        return parent != null;
    }
    
    public Properties getParent() {
        return parent;
    }
    
    
}
