package org.lsst.ccs.bootstrap;

import java.util.ArrayList;
import java.util.List;

/**
 *
 * @author turri
 */
public class BootstrapClassLoader extends ClassLoader {

    static List<ClassLoader> classLoders = new ArrayList<>();

    public BootstrapClassLoader(ClassLoader cl) {
        super(cl);
        addClassLoader(cl);
    }

    @Override
    public Class<?> loadClass(String name) throws ClassNotFoundException {
        Class<?> clazz = null;
        for (ClassLoader cl : classLoders) {
            try {
                clazz = cl.loadClass(name);
                break;
            } catch (Exception e) {
            }
        }
        if ( clazz == null ) {
            throw new ClassNotFoundException("Could not load class "+name);
        }
        return clazz;
    }

    public static void addClassLoader(ClassLoader cl) {
        classLoders.add(cl);
    }
    
    public List<ClassLoader> getClassLoaders() {
        return classLoders;
    }
    
}
