/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.bootstrap;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import org.apache.commons.cli.BasicParser;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.OptionBuilder;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.lsst.ccs.bootstrap.BootstrapClassLoader;
import org.lsst.ccs.bootstrap.BootstrapUtils;
import org.lsst.ccs.bootstrap.resources.ResourcesUtils;

public class Bootstrap {
    private Options bootstrapCommandLineOptions;
    private List<String> additionalCommandLineArguments = new ArrayList<String>();
    private List<String> passedAlongOptions = new ArrayList<String>();
    private static String bootstrapApplication = null;
    public static URLClassLoader applicationClassLoader = null;
    private boolean printHelp = false;
    private boolean listApplications = false;
    private boolean verbose = false;
    private boolean showDistributionInfo = false;
    public static final String APPLICATION_OPTION = "application";
    public static final String HELP_OPTION = "help";
    public static final String VERBOSE_OPTION = "verbose";
    public static final String LIST_APPLICATIONS_OPTION = "listApplications";
    private String defaultTransport = null;
    private String transport;
    private String showProperties = null;
    private boolean hasTransport = false;
    private boolean showClasspath = false;
    private static final String APPLICATION_MAINCLASS_PROPERTY = "org.lsst.ccs.application.mainClass";
    private static final String APPLICATION_ARGS_PROPERTY = "org.lsst.ccs.application.args";
    private static final String APPLICATION_DESCRIPTION_PROPERTY = "org.lsst.ccs.application.description";
    private static Properties bootstrapCmdLineProperties = new Properties();
    private static boolean parsedOptions = false;
    private static Map<String, String> additionalClassPathEntriesMap = new HashMap<String, String>();
    private static List<String> additionalClassPathEntriesList = new ArrayList<String>();
    private static Properties bootstrapApplicationProperties = null;

    public Bootstrap() {
        this.bootstrapCommandLineOptions = new Options();
        this.bootstrapCommandLineOptions.addOption("h", HELP_OPTION, false, "Print the help message");
        this.bootstrapCommandLineOptions.addOption("v", VERBOSE_OPTION, false, "Turns on verbose statements");
        this.bootstrapCommandLineOptions.addOption("la", LIST_APPLICATIONS_OPTION, false, "List the available CCS applications in this distribution");
        this.bootstrapCommandLineOptions.addOption("app", APPLICATION_OPTION, true, "The APPLICATION to be launched");
        this.getOption(APPLICATION_OPTION).setArgName("APPLICATION");
        OptionBuilder.withArgName((String)"SystemProperty=Value");
        OptionBuilder.hasArgs((int)2);
        OptionBuilder.withValueSeparator();
        OptionBuilder.withDescription((String)"Set the Value of a SystemProperty.");
        Option sysProperty = OptionBuilder.create((String)"D");
        this.bootstrapCommandLineOptions.addOption(sysProperty);
        this.bootstrapCommandLineOptions.addOption("di", "distInfo", false, "Show information on current distribution.");
        this.bootstrapCommandLineOptions.addOption("sp", "showProperties", true, "Show the properties for <FILE_NAME>.");
        this.getOption("showProperties").setArgName("FILE_NAME");
        this.bootstrapCommandLineOptions.addOption("scp", "showClasspath", false, "Show the classpath for the given application.");
        List<String> transports = BootstrapUtils.getBootstrapListOfTransports();
        if (!transports.isEmpty()) {
            this.hasTransport = true;
            this.bootstrapCommandLineOptions.addOption("tl", "transportLayer", true, "The TRANSPORT_LAYER to be used");
            this.getOption("transportLayer").setArgName("TRANSPORT_LAYER");
            String description = "The TRANSPORT_LAYER to be used. Possible values are: \n";
            for (String transport : transports) {
                description = String.valueOf(description) + transport + "\t";
                Properties transportProps = BootstrapUtils.getPropertiesForTransport(transport);
                if (transportProps.getProperty("org.lsst.ccs.transport.default") == null) continue;
                this.defaultTransport = transport;
            }
            description = String.valueOf(description) + "\nIf not specified the following transport will be used as the default: " + this.defaultTransport;
            this.getOption("transportLayer").setDescription(description);
        }
    }

    public static Properties getBootstrapApplicationProperties() {
        if (bootstrapApplicationProperties == null) {
            bootstrapApplicationProperties = BootstrapUtils.getApplicationDefinitionProperties(Bootstrap.getBootstrapApplication());
        }
        return bootstrapApplicationProperties;
    }

    private void parseCommandLineArguments(String[] args) throws ParseException {
        if (parsedOptions) {
            throw new RuntimeException("Command line arguments can be parsed only once. Something went wrong ");
        }
        parsedOptions = true;
        BasicParser parser = new BasicParser();
        CommandLine line = parser.parse(this.bootstrapCommandLineOptions, args, true);
        if (line.hasOption(APPLICATION_OPTION)) {
            if (bootstrapApplication != null) {
                throw new IllegalArgumentException("\t[FATAL] The application has been defined twice.");
            }
            String tmpApp = line.getOptionValue(APPLICATION_OPTION);
            if (!BootstrapUtils.getBootstrapListOfApplications().contains(tmpApp)) {
                throw new IllegalArgumentException("Application name:  " + tmpApp + " is not a valid value.");
            }
            bootstrapApplication = tmpApp;
        }
        if (line.hasOption(HELP_OPTION)) {
            this.printHelp = true;
        }
        this.additionalCommandLineArguments.addAll(line.getArgList());
        this.showClasspath = line.hasOption("showClasspath");
        if (line.hasOption("showProperties") && this.showProperties == null) {
            this.showProperties = line.getOptionValue("showProperties");
        }
        if (line.hasOption(LIST_APPLICATIONS_OPTION)) {
            this.listApplications = true;
        }
        if (line.hasOption(VERBOSE_OPTION)) {
            this.verbose = true;
        }
        if (this.printHelp && !this.passedAlongOptions.contains("-help")) {
            this.passedAlongOptions.add("-help");
        }
        if (this.verbose && !this.passedAlongOptions.contains("-verbose")) {
            this.passedAlongOptions.add("-verbose");
        }
        Properties cmdLineProperties = line.getOptionProperties("D");
        if (this.verbose() && !cmdLineProperties.isEmpty()) {
            System.out.println("\n*** Adding the following command line properties to the System Properties:");
            Set<Object> keys = cmdLineProperties.keySet();
            for (Object key : keys) {
                System.out.println("\t" + key + " = " + cmdLineProperties.getProperty((String)key));
            }
        }
        if (!cmdLineProperties.isEmpty()) {
            bootstrapCmdLineProperties.putAll((Map<?, ?>)cmdLineProperties);
        }
        if (line.hasOption("distInfo")) {
            this.showDistributionInfo = true;
        }
        if (this.hasTransport && line.hasOption("transportLayer") && this.transport == null) {
            String tmpTransport = line.getOptionValue("transportLayer");
            if (!BootstrapUtils.getBootstrapListOfTransports().contains(tmpTransport)) {
                throw new IllegalArgumentException("Transport layer " + tmpTransport + " is not a valid value.");
            }
            this.transport = tmpTransport;
        }
    }

    public static Properties getCmdLineProperties() {
        return bootstrapCmdLineProperties;
    }

    public static String getBootstrapApplication() {
        return bootstrapApplication;
    }

    public boolean doPrintHelp() {
        return this.printHelp;
    }

    public boolean verbose() {
        return this.verbose;
    }

    protected Options getBootstrapCommandLineOptions() {
        return this.bootstrapCommandLineOptions;
    }

    private static void printBootstrapClassLoader() {
        URL[] urls;
        System.out.println("*** CLASSPATH");
        URL[] uRLArray = urls = Bootstrap.getBootstrapApplicationClassLoader().getURLs();
        int n = urls.length;
        int n2 = 0;
        while (n2 < n) {
            URL url = uRLArray[n2];
            System.out.println("\t\t" + url);
            ++n2;
        }
    }

    private Option getOption(String opt) {
        return this.getBootstrapCommandLineOptions().getOption(opt);
    }

    private void loadTransportPropertiesInSystemProperties(String transport) {
    }

    private String[] getApplicationArguments(Properties appProperties) throws ParseException {
        String applicationArgs = appProperties.getProperty(APPLICATION_ARGS_PROPERTY, "").trim();
        StringTokenizer applicationArgsTokenizer = new StringTokenizer(applicationArgs, " ");
        int nArgs = this.passedAlongOptions.size() + this.additionalCommandLineArguments.size() + applicationArgsTokenizer.countTokens();
        String[] mainArgs = new String[nArgs];
        int argCount = 0;
        while (applicationArgsTokenizer.hasMoreTokens()) {
            mainArgs[argCount++] = applicationArgsTokenizer.nextToken();
        }
        for (String opt : this.passedAlongOptions) {
            mainArgs[argCount++] = opt;
        }
        for (String cmdArg : this.additionalCommandLineArguments) {
            mainArgs[argCount++] = cmdArg;
        }
        if (this.verbose()) {
            System.out.print("*** Command line arguments passed to the mainClass: ");
            String[] stringArray = mainArgs;
            int n = mainArgs.length;
            int n2 = 0;
            while (n2 < n) {
                String arg = stringArray[n2];
                System.out.print(String.valueOf(arg) + " ");
                ++n2;
            }
            System.out.println();
        }
        return mainArgs;
    }

    public static URLClassLoader getBootstrapApplicationClassLoader() {
        if (applicationClassLoader == null) {
            Bootstrap.buildBootstrapClassLoader();
        }
        return applicationClassLoader;
    }

    static void scanPropertiesForClassPathEntries(Properties props) {
        Set<Object> keySet = ResourcesUtils.getAllKeysInProperties(props);
        for (Object obj : keySet) {
            String key = (String)obj;
            if (!key.endsWith("additional.classpath.entry")) continue;
            String entry = props.getProperty(key);
            if (additionalClassPathEntriesMap.containsKey(key)) {
                System.out.println("*** [WARNING] ignoring additional classpath entry: " + key + "=" + entry + " it was already added to the CLASSPATH as " + additionalClassPathEntriesMap.get(key));
                continue;
            }
            additionalClassPathEntriesMap.put(key, entry);
            additionalClassPathEntriesList.add(entry);
        }
    }

    private static void buildBootstrapClassLoader() {
        if (bootstrapApplication == null) {
            throw new RuntimeException("The Bootstrap Application has not been defined yet.");
        }
        if (applicationClassLoader != null) {
            throw new RuntimeException("The Bootstrap ClassLoader has already been built. Please report this problem.");
        }
        ArrayList<URL> classPathUrlList = new ArrayList<URL>();
        Bootstrap.scanPropertiesForClassPathEntries(Bootstrap.getBootstrapApplicationProperties());
        try {
            for (String classPathEntry : additionalClassPathEntriesList) {
                File cpEntryFile = new File(classPathEntry);
                if (cpEntryFile.isDirectory()) {
                    System.out.println("*** [WARNING] we are currently ignoring directories as additional Classpath entries. Skipping " + classPathEntry);
                    continue;
                }
                classPathUrlList.add(cpEntryFile.toURI().toURL());
            }
            String applicationMainJar = Bootstrap.getApplicationMainJarFromProperties(Bootstrap.getBootstrapApplicationProperties());
            classPathUrlList.add(new URL("file://" + applicationMainJar));
            Manifest manifest = Bootstrap.getBootsrapMainManifest();
            String manifestClassPath = manifest.getMainAttributes().getValue("Class-Path").trim();
            if (manifestClassPath != null) {
                StringTokenizer classPathTokens = new StringTokenizer(manifestClassPath, " ");
                while (classPathTokens.hasMoreTokens()) {
                    String manifestClassPathJar = classPathTokens.nextToken();
                    classPathUrlList.add(new URL("file://" + BootstrapUtils.getDistributionJarFilesDirectory() + manifestClassPathJar));
                }
            }
        }
        catch (MalformedURLException mue) {
            throw new RuntimeException("Failed to build URL when building the classpath: " + mue.getMessage());
        }
        URL[] classpathUrls = new URL[classPathUrlList.size()];
        int count = 0;
        for (URL classpathURl : classPathUrlList) {
            classpathUrls[count++] = classpathURl;
        }
        applicationClassLoader = new URLClassLoader(classpathUrls);
        Thread.currentThread().setContextClassLoader(applicationClassLoader);
        BootstrapClassLoader.addClassLoader(applicationClassLoader);
    }

    private static Manifest getBootsrapMainManifest() {
        String applicationMainJar = Bootstrap.getApplicationMainJarFromProperties(Bootstrap.getBootstrapApplicationProperties());
        Manifest manifest = null;
        try {
            JarFile applicationMainJarFile = new JarFile(applicationMainJar);
            manifest = applicationMainJarFile.getManifest();
        }
        catch (IOException ioe) {
            throw new RuntimeException("Could not extract Manifest from Jar file " + applicationMainJar, ioe);
        }
        return manifest;
    }

    private static String getApplicationMainJarFromProperties(Properties applicationProperties) {
        String applicationMainJar = applicationProperties.getProperty("org.lsst.ccs.application.mainJar");
        if (applicationMainJar == null) {
            throw new RuntimeException("*** Application Definition file must contain property org.lsst.ccs.application.mainJar in its definition file");
        }
        applicationMainJar = String.valueOf(BootstrapUtils.getDistributionJarFilesDirectory()) + applicationMainJar;
        return applicationMainJar;
    }

    private void launchCCSApplication(String applicationName) {
        Manifest manifest;
        String manifestMainClass;
        String applicationMainClassName;
        Properties applicationProperties = BootstrapUtils.getApplicationDefinitionProperties(applicationName);
        if (this.doPrintHelp()) {
            String appDescription = applicationProperties.getProperty(APPLICATION_DESCRIPTION_PROPERTY, "");
            System.out.println("\n\tCCS Application " + applicationName + " " + appDescription + "\n");
        }
        if ((applicationMainClassName = applicationProperties.getProperty(APPLICATION_MAINCLASS_PROPERTY, manifestMainClass = (manifest = Bootstrap.getBootsrapMainManifest()).getMainAttributes().getValue("Main-Class"))) == null) {
            throw new RuntimeException("*** Application " + applicationName + " must contain define the main Class to lauch. " + "This can be done either in the Manifest of the main jar or by defining the property " + APPLICATION_MAINCLASS_PROPERTY + " in its definition file. ");
        }
        if (this.verbose()) {
            System.out.println("*** Distribution Root: " + BootstrapUtils.getCCSDistributionRootDirectory());
            System.out.println("*** Application name: " + applicationName);
            System.out.println("*** MainClass: " + applicationMainClassName);
            System.out.println("*** LD_LIBRARY_PATH: " + System.getenv("LD_LIBRARY_PATH"));
        }
        try {
            Class<?> applicationMainClass = Bootstrap.getBootstrapApplicationClassLoader().loadClass(applicationMainClassName);
            try {
                Method applicationMainMethod = applicationMainClass.getMethod("main", String[].class);
                String[] mainArgs = this.getApplicationArguments(applicationProperties);
                if (this.hasTransport) {
                    if (this.transport == null) {
                        this.transport = this.defaultTransport;
                    }
                    if (this.verbose()) {
                        System.out.println("*** Transport: " + this.transport);
                    }
                    this.loadTransportPropertiesInSystemProperties(this.transport);
                }
                if (this.verbose()) {
                    Bootstrap.printBootstrapClassLoader();
                }
                try {
                    applicationMainMethod.invoke(null, new Object[]{mainArgs});
                }
                catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
                    System.out.println("*** Failed to invoke main method in class " + applicationMainClassName + "\n" + e.getMessage());
                    e.printStackTrace();
                }
            }
            catch (NoSuchMethodException | SecurityException | ParseException e) {
                System.out.println("*** Could not access the main method in class " + applicationMainClassName + "\n" + e.getMessage());
            }
        }
        catch (ClassNotFoundException cnfe) {
            System.out.println("*** Could not find class " + applicationMainClassName + " in the following classpath: ");
            Bootstrap.printBootstrapClassLoader();
            System.out.println("*************************************************************************\n" + cnfe.getMessage());
        }
    }

    public static void main(String[] args) throws Exception {
        Bootstrap bootstrap = new Bootstrap();
        bootstrap.parseCommandLineArguments(args);
        String applicationName = Bootstrap.getBootstrapApplication();
        if (bootstrap.showClasspath) {
            if (Bootstrap.getBootstrapApplication() == null) {
                throw new IllegalArgumentException("To display the content of the classpath you have to provide an application with the --app option");
            }
            Bootstrap.printBootstrapClassLoader();
        } else if (bootstrap.showProperties != null) {
            if (Bootstrap.getBootstrapApplication() == null) {
                throw new IllegalArgumentException("To display the content of a properties file you have to provide an application with the --app option");
            }
            ResourcesUtils.printProperties(BootstrapUtils.getMergedProperties(bootstrap.showProperties));
        } else if (bootstrap.showDistributionInfo) {
            Bootstrap.printDistributionInfo();
        } else if (bootstrap.listApplications) {
            List<String> availableApplications = BootstrapUtils.getBootstrapListOfApplications();
            if (availableApplications.isEmpty()) {
                System.out.println("No CCS applications are defined in the current distribution.");
                if (bootstrap.verbose()) {
                    System.out.println(BootstrapUtils.getDistributionResourcesDirectory());
                }
            } else {
                System.out.println("Available CCS applications :");
                if (bootstrap.verbose()) {
                    System.out.println(BootstrapUtils.getDistributionResourcesDirectory());
                }
                for (String application : availableApplications) {
                    Properties applicationProps = BootstrapUtils.getApplicationDefinitionProperties(application);
                    System.out.println("\t" + application + "\t" + applicationProps.getProperty(APPLICATION_DESCRIPTION_PROPERTY));
                }
            }
        } else if (bootstrap.doPrintHelp() && applicationName == null) {
            Bootstrap.printHelp(bootstrap.getBootstrapCommandLineOptions());
        } else if (applicationName != null) {
            bootstrap.launchCCSApplication(applicationName);
        } else {
            Bootstrap.printHelp(bootstrap.getBootstrapCommandLineOptions());
        }
    }

    private static void printHelp(Options o) {
        HelpFormatter formatter = new HelpFormatter();
        formatter.printHelp(100, "CCSbootstrap", "", o, "", true);
    }

    private static void printDistributionInfo() {
        System.out.println("\n*** Distribution info");
        System.out.println("\tDistribution path: " + BootstrapUtils.getCCSDistributionRootDirectory());
        System.out.println("\tResources ordered search path: ");
        List<String> distSearchPathList = BootstrapUtils.getOrderedListOfResourceDirectories();
        String resourcesDirList = "";
        for (String dir : distSearchPathList) {
            resourcesDirList = String.valueOf(resourcesDirList) + "\t\t" + dir + "\n";
        }
        System.out.print(resourcesDirList);
    }
}

