package org.lsst.ccs.bootstrap.resources;

import java.io.File;
import java.util.ArrayList;
import java.util.List;

/**
 * A Resource Directory.
 * It contains a list of resources.
 * 
 * @author turri
 */
public class ResourceDirectory {
    
    private File resourceDirectoryFile = null;
    private List<String> resources = new ArrayList<>();
    private String fileSeparator = System.getProperty("file.separator");

    ResourceDirectory(String resourceDirectoryPath) {
        resourceDirectoryFile = new File(resourceDirectoryPath);
        if (resourceDirectoryFile.exists() && resourceDirectoryFile.isDirectory()) {
            String[] listOfResources = resourceDirectoryFile.list();
            for( String resource : listOfResources ) {
                resources.add(resource);
            }
        } else {
            throw new IllegalArgumentException("The provided path: "+resourceDirectoryPath+" does not exist");
        }
    }
    
    public boolean hasResource(String resourceName) {
        return resources.contains(resourceName);
    }
    
    public String getResouceDirectoryPath() {
        String resourceDirPath = resourceDirectoryFile.getAbsolutePath();
        if ( ! resourceDirPath.endsWith(fileSeparator) ) {
            resourceDirPath += fileSeparator;
        }
        return resourceDirPath;
    }

    public List<String> getResources() {
        return resources;
    }
    
    
}
