/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.localdb.statusdb;

import java.time.Duration;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.hibernate.Session;
import org.lsst.ccs.bootstrap.BootstrapResourceUtils;
import org.lsst.ccs.bus.data.Alert;
import org.lsst.ccs.bus.states.AlertState;
import org.lsst.ccs.command.annotations.Command;
import org.lsst.ccs.commons.annotations.LookupField;
import org.lsst.ccs.framework.AgentPeriodicTask;
import org.lsst.ccs.framework.ClearAlertHandler;
import org.lsst.ccs.framework.HasLifecycle;
import org.lsst.ccs.localdb.statusdb.LocalDBAlert;
import org.lsst.ccs.localdb.statusdb.StatusPersisterSubsystem;
import org.lsst.ccs.services.AgentPeriodicTaskService;
import org.lsst.ccs.services.alert.AlertService;

public class QueryMonitor
implements HasLifecycle {
    private final Properties p = new Properties();
    private final int longRunningProcessTime = 480;
    @LookupField(strategy=LookupField.Strategy.TOP)
    private StatusPersisterSubsystem subsystem;
    @LookupField(strategy=LookupField.Strategy.TREE)
    private AgentPeriodicTaskService periodicTaskService;
    @LookupField(strategy=LookupField.Strategy.TREE)
    private AlertService alertService;

    public QueryMonitor() {
        Properties inProps = BootstrapResourceUtils.getBootstrapSystemProperties();
        if (inProps != null) {
            this.p.putAll((Map<?, ?>)inProps);
        }
    }

    public void build() {
        this.periodicTaskService.scheduleAgentPeriodicTask(new AgentPeriodicTask("db-monitor", () -> this.dbMonitor()).withIsFixedRate(true).withPeriod(Duration.ofMinutes(3L)));
    }

    public void init() {
        ClearAlertHandler alwaysClear = new ClearAlertHandler(){

            public ClearAlertHandler.ClearAlertCode canClearAlert(Alert alert, AlertState alertState) {
                return ClearAlertHandler.ClearAlertCode.CLEAR_ALERT;
            }
        };
        this.alertService.registerAlert(LocalDBAlert.LongRunningProcesses.getAlert(null, null), alwaysClear);
    }

    private void dbMonitor() {
        StringBuilder sb = new StringBuilder();
        try (Session sess = this.subsystem.getSessionFactory().openSession();){
            for (Object proc : this.getLongRunningProcesses(sess)) {
                Object[] info = (Object[])proc;
                for (int i = 0; i < info.length; ++i) {
                    sb.append(info[i]).append(" ");
                }
                sb.append("\n");
            }
        }
        if (!sb.toString().isEmpty()) {
            Alert a = LocalDBAlert.LongRunningProcesses.getAlert(null, null);
            this.alertService.raiseAlert(a, AlertState.WARNING, sb.toString());
        }
    }

    private List getLongRunningProcesses(Session sess) {
        return sess.createSQLQuery("select * from information_schema.processlist where info is not null and time > 480").list();
    }

    private String showProcessList(Session sess) {
        StringBuilder sb = new StringBuilder("Full Process List\n");
        sb.append("Id\tUser\tHost\tDb\tCommand\tTime(s)\tState\tInfo\tProcess\n");
        List procList = sess.createSQLQuery("show full processlist").list();
        for (Object proc : procList) {
            Object[] info = (Object[])proc;
            for (int i = 0; i < info.length; ++i) {
                sb.append(info[i]).append("\t");
            }
            sb.append("\n");
        }
        return sb.toString();
    }

    @Command(type=Command.CommandType.QUERY)
    public String showProcessList() {
        String res;
        try (Session sess = this.subsystem.getSessionFactory().openSession();){
            res = this.showProcessList(sess);
        }
        return res;
    }

    @Command
    public void killProcess(String id) {
        try (Session sess = this.subsystem.getSessionFactory().openSession();){
            sess.createSQLQuery("kill " + id).executeUpdate();
        }
    }

    @Command
    public void killLongRunningProcesses() {
        try (Session sess = this.subsystem.getSessionFactory().openSession();){
            List longRunning = this.getLongRunningProcesses(sess);
            for (Object proc : longRunning) {
                Object[] info = (Object[])proc;
                Object id = info[0];
                sess.createSQLQuery("kill " + id).executeUpdate();
            }
        }
    }
}

