/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.command.annotations;

import java.lang.annotation.Documented;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;

@Target(value={ElementType.METHOD})
@Retention(value=RetentionPolicy.RUNTIME)
@Documented
public @interface Command {
    public static final int NORMAL = 0;
    @Deprecated
    public static final int ENGINEERING1 = 1;
    public static final int ENGINEERING_ROUTINE = 1;
    @Deprecated
    public static final int ENGINEERING2 = 2;
    public static final int ENGINEERING_ADVANCED = 2;
    @Deprecated
    public static final int ENGINEERING3 = 3;
    public static final int ENGINEERING_EXPERT = 3;
    public static final int ADMIN = 50;
    public static final int MAX = 99;
    public static final int NOT_DEFINED = 99999;

    public String name() default "";

    public String description() default "";

    public String alias() default "";

    public CommandType type() default CommandType.ACTION;

    public int level() default 99999;

    public CommandCategory category() default CommandCategory.USER;

    public boolean autoAck() default true;

    public int timeout() default 0;

    public boolean simulation() default false;

    public static class Level {
        private static final SortedMap<Integer, String> value2name;
        private static final Map<String, Integer> name2value;
        private int defaultValue = -1;
        private String defaultName = null;
        private OnTooHigh onTooHigh = OnTooHigh.ON_TOO_HIGH_MAX;
        private OnInvalidName onInvalidName = OnInvalidName.ON_INVALID_NAME_DEFAULT;
        private OnUnnamed onUnnamed = OnUnnamed.ON_UNNAMED_NUMERIC;

        public int getValue(String name) {
            Integer out = name2value.get(name);
            if (out == null) {
                try {
                    int value = Integer.parseInt(name);
                    if (value < 0) {
                        throw new NumberFormatException();
                    }
                    if (value > 99) {
                        return switch (this.onTooHigh) {
                            case OnTooHigh.ON_TOO_HIGH_DEFAULT -> this.defaultValue;
                            case OnTooHigh.ON_TOO_HIGH_MAX -> 99;
                            default -> throw new IllegalArgumentException("Illegal level value " + name);
                        };
                    }
                    return value;
                }
                catch (NumberFormatException x) {
                    switch (this.onInvalidName) {
                        case ON_INVALID_NAME_DEFAULT: {
                            break;
                        }
                        default: {
                            throw new IllegalArgumentException("Invalid level name " + name);
                        }
                    }
                    return this.defaultValue;
                }
            }
            return out;
        }

        public String getName(int value) {
            String out = (String)Level.valueToName().get(value);
            if (out == null) {
                return switch (this.onUnnamed) {
                    case OnUnnamed.ON_UNNAMED_EXCEPTION -> throw new IllegalArgumentException("Unnamed level " + value);
                    case OnUnnamed.ON_UNNAMED_DEFAULT -> this.defaultName;
                    default -> {
                        if (value > 99) {
                            switch (this.onTooHigh) {
                                case ON_TOO_HIGH_DEFAULT: {
                                    yield this.defaultName;
                                }
                                case ON_TOO_HIGH_MAX: {
                                    yield "MAX";
                                }
                            }
                            throw new IllegalArgumentException("Illegal level value " + value);
                        }
                        yield String.valueOf(value);
                    }
                };
            }
            return out;
        }

        public Level with(Enum<?> what) {
            if (what instanceof OnTooHigh) {
                OnTooHigh w;
                this.onTooHigh = w = (OnTooHigh)what;
            } else if (what instanceof OnInvalidName) {
                OnInvalidName w;
                this.onInvalidName = w = (OnInvalidName)what;
            } else if (what instanceof OnUnnamed) {
                OnUnnamed w;
                this.onUnnamed = w = (OnUnnamed)what;
            } else {
                throw new IllegalArgumentException("Illegal argument type: " + (what == null ? null : what.getClass().getName()));
            }
            return this;
        }

        public Level withDefault(int defaultValue) {
            this.defaultValue = defaultValue;
            return this;
        }

        public Level withDefault(String defaultName) {
            this.defaultName = defaultName;
            return this;
        }

        public static int parse(String s, int def) {
            int out = -1;
            if (s != null) {
                s = s.trim();
                try {
                    out = Integer.parseInt(s);
                }
                catch (NumberFormatException x) {
                    try {
                        Field f = Command.class.getDeclaredField(s);
                        int mm = f.getModifiers();
                        if (f.getType().equals(Integer.TYPE) && Modifier.isFinal(mm) && Modifier.isStatic(mm) && Modifier.isPublic(mm)) {
                            out = f.getInt(null);
                        }
                    }
                    catch (ReflectiveOperationException | RuntimeException exception) {
                        // empty catch block
                    }
                }
            }
            if (out < 0) {
                out = def;
            } else if (out > 99 && out != 99999) {
                out = 99;
            }
            return out;
        }

        public static String name(int level, boolean numberAsString) {
            String out = (String)Level.valueToName().get(level);
            if (out == null) {
                if (level == 99999) {
                    out = "NOT_DEFINED";
                } else if (numberAsString) {
                    out = level < 0 ? "NOT_DEFINED" : (level > 99 ? "MAX" : Integer.toString(level));
                }
            }
            return out;
        }

        public static Map<String, Integer> nameToValue() {
            return name2value;
        }

        public static SortedMap<Integer, String> valueToName() {
            return value2name;
        }

        static {
            TreeMap<Integer, String> v2n = new TreeMap<Integer, String>();
            for (Field f : Command.class.getDeclaredFields()) {
                try {
                    if (f.isAnnotationPresent(Deprecated.class)) continue;
                    int mm = f.getModifiers();
                    if (!f.getType().equals(Integer.TYPE) || !Modifier.isFinal(mm) || !Modifier.isStatic(mm) || !Modifier.isPublic(mm)) continue;
                    v2n.put(f.getInt(null), f.getName());
                }
                catch (ReflectiveOperationException | RuntimeException exception) {
                    // empty catch block
                }
            }
            value2name = Collections.unmodifiableSortedMap(v2n);
            LinkedHashMap n2v = new LinkedHashMap(1 + Math.round((float)v2n.size() / 0.75f));
            v2n.forEach((value, name) -> n2v.put(name, value));
            name2value = Collections.unmodifiableMap(n2v);
        }

        public static enum OnTooHigh {
            ON_TOO_HIGH_EXCEPTION,
            ON_TOO_HIGH_DEFAULT,
            ON_TOO_HIGH_MAX;

        }

        public static enum OnInvalidName {
            ON_INVALID_NAME_EXCEPTION,
            ON_INVALID_NAME_DEFAULT;

        }

        public static enum OnUnnamed {
            ON_UNNAMED_EXCEPTION,
            ON_UNNAMED_DEFAULT,
            ON_UNNAMED_NUMERIC;

        }
    }

    public static enum CommandCategory {
        SYSTEM,
        CORE,
        USER;

    }

    public static enum CommandType {
        QUERY,
        ACTION,
        CONFIGURATION,
        SIGNAL,
        ABORT;

    }
}

