/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.daq.ims.channel;

import java.io.IOException;
import java.nio.IntBuffer;
import org.lsst.ccs.daq.ims.channel.WritableIntChannel;

public class DemultiplexingIntChannel
implements WritableIntChannel {
    private final WritableIntChannel[] destinations;
    private final int size;
    private int next;
    private boolean isClosed;
    private final int[][] buffer;
    private int bufferOffset;

    public DemultiplexingIntChannel(WritableIntChannel ... destinations) {
        this.destinations = destinations;
        this.size = destinations.length;
        this.buffer = new int[this.size][10000];
        this.bufferOffset = 0;
        this.next = 0;
    }

    @Override
    public boolean isOpen() {
        return !this.isClosed;
    }

    @Override
    public void close() throws IOException {
        this.flush();
        for (WritableIntChannel channel : this.destinations) {
            channel.close();
        }
        this.isClosed = true;
    }

    @Override
    public void write(int i) throws IOException {
        this.buffer[this.next++][this.bufferOffset] = i;
        if (this.next >= this.size) {
            this.next = 0;
            ++this.bufferOffset;
            if (this.bufferOffset == 10000) {
                this.flush();
            }
        }
    }

    private void flush() throws IOException {
        if (this.next != 0) {
            throw new IOException("Incomplete buffer during flush");
        }
        for (int i = 0; i < this.size; ++i) {
            this.destinations[i].write(IntBuffer.wrap(this.buffer[i], 0, this.bufferOffset));
        }
        this.bufferOffset = 0;
    }
}

