/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.daq.ims;

import java.nio.channels.ByteChannel;
import org.lsst.ccs.daq.ims.DAQException;
import org.lsst.ccs.daq.ims.DAQSourceChannel;
import org.lsst.ccs.daq.ims.Image;
import org.lsst.ccs.daq.ims.SourceMetaData;
import org.lsst.ccs.daq.ims.Store;
import org.lsst.ccs.daq.ims.StreamListener;
import org.lsst.ccs.utilities.location.Location;

public class Source
implements Comparable<Source> {
    private SourceMetaData metaData;
    private final Image image;
    private final Location location;

    Source(Image image, Location location) {
        this.image = image;
        this.location = location;
        this.metaData = null;
    }

    Source(Image image, SourceMetaData metaData) {
        this.metaData = metaData;
        this.location = metaData.getLocation();
        this.image = image;
    }

    public SourceMetaData getMetaData() throws DAQException {
        if (this.metaData == null) {
            this.metaData = this.image.getStore().findSource(this.image.getMetaData().getId(), this.location.index());
        }
        return this.metaData;
    }

    public Location getLocation() {
        return this.location;
    }

    public long size() throws DAQException {
        return this.getMetaData().getLength();
    }

    public Location.LocationType getSourceType() throws DAQException {
        return this.getMetaData().getSensor();
    }

    public Image getImage() {
        return this.image;
    }

    public ByteChannel openChannel(ChannelMode mode) throws DAQException {
        return DAQSourceChannel.open(this.image.getStore(), this, mode);
    }

    public ByteChannel openChannel(Store store, ChannelMode mode) throws DAQException {
        return DAQSourceChannel.open(store, this, mode);
    }

    void addStreamListener(StreamListener listener) {
        this.image.getStore().addStreamListener(this.image.getMetaData().getId(), this.getLocation().index(), listener);
    }

    void removeStreamListener(StreamListener listener) {
        this.image.getStore().removeStreamListener(this.image.getMetaData().getId(), this.getLocation().index(), listener);
    }

    @Override
    public int compareTo(Source o) {
        return this.location.compareTo(o.location);
    }

    public String toString() {
        return "Source{metaData=" + this.metaData + ", image=" + this.image + ", location=" + this.location + "}";
    }

    public static enum ChannelMode {
        READ,
        WRITE,
        STREAM;

    }
}

