/*
 * Decompiled with CFR 0.152.
 */
package nom.tam.image;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.IOException;
import nom.tam.image.ImageTiler;
import nom.tam.util.ArrayFuncs;
import nom.tam.util.RandomAccess;

public abstract class StandardImageTiler
implements ImageTiler {
    private final RandomAccess randomAccessFile;
    private final long fileOffset;
    private final int[] dims;
    private final Class<?> base;

    public static long getOffset(int[] dims, int[] pos) {
        long offset = 0L;
        for (int i = 0; i < dims.length; ++i) {
            if (i > 0) {
                offset *= (long)dims[i];
            }
            offset += (long)pos[i];
        }
        return offset;
    }

    protected static boolean incrementPosition(int[] start, int[] current, int[] lengths) {
        for (int i = start.length - 2; i >= 0; --i) {
            if (current[i] - start[i] >= lengths[i] - 1) continue;
            int n = i;
            current[n] = current[n] + 1;
            for (int j = i + 1; j < start.length - 1; ++j) {
                current[j] = start[j];
            }
            return true;
        }
        return false;
    }

    @SuppressFBWarnings(value={"EI_EXPOSE_REP"}, justification="intended exposure of mutable data")
    public StandardImageTiler(RandomAccess f, long fileOffset, int[] dims, Class<?> base) {
        this.randomAccessFile = f;
        this.fileOffset = fileOffset;
        this.dims = dims;
        this.base = base;
    }

    @SuppressFBWarnings(value={"RR_NOT_CHECKED"}, justification="this read will never return less than the requested length")
    protected void fillFileData(Object output, long delta, int outputOffset, int segment) throws IOException {
        this.randomAccessFile.seek(this.fileOffset + delta);
        if (this.base == Float.TYPE) {
            this.randomAccessFile.read((float[])output, outputOffset, segment);
        } else if (this.base == Integer.TYPE) {
            this.randomAccessFile.read((int[])output, outputOffset, segment);
        } else if (this.base == Short.TYPE) {
            this.randomAccessFile.read((short[])output, outputOffset, segment);
        } else if (this.base == Double.TYPE) {
            this.randomAccessFile.read((double[])output, outputOffset, segment);
        } else if (this.base == Byte.TYPE) {
            this.randomAccessFile.read((byte[])output, outputOffset, segment);
        } else if (this.base == Long.TYPE) {
            this.randomAccessFile.read((long[])output, outputOffset, segment);
        } else {
            throw new IOException("Invalid type for tile array");
        }
    }

    protected void fillMemData(Object data, int[] posits, int length, Object output, int outputOffset, int dim) {
        if (data instanceof Object[]) {
            Object[] xo = (Object[])data;
            this.fillMemData(xo[posits[dim]], posits, length, output, outputOffset, dim + 1);
        } else {
            int startFrom = posits[dim];
            int startTo = outputOffset;
            int copyLength = length;
            if (posits[dim] < 0) {
                startFrom -= posits[dim];
                startTo -= posits[dim];
                copyLength += posits[dim];
            }
            if (posits[dim] + length > this.dims[dim]) {
                copyLength -= posits[dim] + length - this.dims[dim];
            }
            System.arraycopy(data, startFrom, output, startTo, copyLength);
        }
    }

    protected void fillTile(Object data, Object o, int[] newDims, int[] corners, int[] lengths) throws IOException {
        int n = newDims.length;
        int[] posits = new int[n];
        int baseLength = ArrayFuncs.getBaseLength(o);
        int segment = lengths[n - 1];
        System.arraycopy(corners, 0, posits, 0, n);
        long currentOffset = 0L;
        if (data == null) {
            currentOffset = this.randomAccessFile.getFilePointer();
        }
        int outputOffset = 0;
        do {
            int mx;
            boolean validSegment;
            boolean bl = validSegment = posits[mx = newDims.length - 1] + lengths[mx] >= 0 && posits[mx] < newDims[mx];
            if (validSegment) {
                for (int i = 0; i < mx; ++i) {
                    if (posits[i] >= 0 && posits[i] < newDims[i]) continue;
                    validSegment = false;
                    break;
                }
            }
            if (validSegment) {
                if (data != null) {
                    this.fillMemData(data, posits, segment, o, outputOffset, 0);
                } else {
                    long offset = StandardImageTiler.getOffset(newDims, posits) * (long)baseLength;
                    int actualLen = segment;
                    long actualOffset = offset;
                    int actualOutput = outputOffset;
                    if (posits[mx] < 0) {
                        actualOffset -= (long)(posits[mx] * baseLength);
                        actualOutput -= posits[mx];
                        actualLen += posits[mx];
                    }
                    if (posits[mx] + segment > newDims[mx]) {
                        actualLen -= posits[mx] + segment - newDims[mx];
                    }
                    this.fillFileData(o, actualOffset, actualOutput, actualLen);
                }
            }
            outputOffset += segment;
        } while (StandardImageTiler.incrementPosition(corners, posits, lengths));
        if (data == null) {
            this.randomAccessFile.seek(currentOffset);
        }
    }

    @Override
    public Object getCompleteImage() throws IOException {
        if (this.randomAccessFile == null) {
            throw new IOException("Attempt to read from null file");
        }
        long currentOffset = this.randomAccessFile.getFilePointer();
        Object o = ArrayFuncs.newInstance(this.base, this.dims);
        this.randomAccessFile.seek(this.fileOffset);
        this.randomAccessFile.readLArray(o);
        this.randomAccessFile.seek(currentOffset);
        return o;
    }

    protected abstract Object getMemoryImage();

    @Override
    public Object getTile(int[] corners, int[] lengths) throws IOException {
        if (corners.length != this.dims.length || lengths.length != this.dims.length) {
            throw new IOException("Inconsistent sub-image request");
        }
        int arraySize = 1;
        for (int i = 0; i < this.dims.length; ++i) {
            if (corners[i] < 0 || lengths[i] < 0 || corners[i] + lengths[i] > this.dims[i]) {
                throw new IOException("Sub-image not within image");
            }
            arraySize *= lengths[i];
        }
        Object outArray = ArrayFuncs.newInstance(this.base, arraySize);
        this.getTile(outArray, corners, lengths);
        return outArray;
    }

    @Override
    public void getTile(Object outArray, int[] corners, int[] lengths) throws IOException {
        Object data = this.getMemoryImage();
        if (data == null && this.randomAccessFile == null) {
            throw new IOException("No data source for tile subset");
        }
        this.fillTile(data, outArray, this.dims, corners, lengths);
    }
}

