/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.daq.guider;

import java.time.Instant;
import org.lsst.ccs.utilities.location.Location;
import org.lsst.ccs.utilities.location.SensorLocation;

public class StateMetaData {
    private final State state;
    private final Status status;
    private final int sequence;
    private final int stamp;
    private final Instant timestamp;
    private final SensorLocation sensorLocation;
    private final String comment;

    private StateMetaData(int type, int status, int sequence, int stamp, long timestampNanos, byte bay, byte board, int sensor, String comment) {
        this.state = State.values()[type];
        this.status = Status.values()[status];
        this.sequence = sequence;
        this.stamp = stamp;
        this.timestamp = Instant.ofEpochSecond(timestampNanos / 1000000000L, timestampNanos % 1000000000L);
        this.sensorLocation = new SensorLocation(new Location((int)bay, (int)board), sensor);
        this.comment = comment;
    }

    public State getState() {
        return this.state;
    }

    public Status getStatus() {
        return this.status;
    }

    public int getSequence() {
        return this.sequence;
    }

    public int getStamp() {
        return this.stamp;
    }

    public Instant getTimestamp() {
        return this.timestamp;
    }

    public SensorLocation getSensorLocation() {
        return this.sensorLocation;
    }

    public String getComment() {
        return this.comment;
    }

    public String toString() {
        return "StateMetaData{state=" + this.state + ", status=" + this.status + ", sequence=" + this.sequence + ", stamp=" + this.stamp + ", timestamp=" + this.timestamp + ", sensorLocation=" + this.sensorLocation + ", comment=" + this.comment + "}";
    }

    public static enum State {
        STAMP,
        START,
        STOP,
        PAUSE,
        RESUME;

    }

    public static enum Status {
        SUCCESS,
        bdiError;

    }
}

