/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.visualization.client;

import java.nio.ByteBuffer;
import org.lsst.ccs.visualization.client.Message;

public class StartMessage
extends Message {
    private final int width;
    private final int height;
    private final int nHeaders;
    private final int nClients;

    public StartMessage(String imageName, int width, int height, int nHeaders, int nClients) {
        super(Message.MessageType.START, 16, imageName);
        this.width = width;
        this.height = height;
        this.nHeaders = nHeaders;
        this.nClients = nClients;
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public int getnHeaders() {
        return this.nHeaders;
    }

    public int getnClients() {
        return this.nClients;
    }

    @Override
    void encodeAdditional(ByteBuffer bb) {
        bb.putInt(this.width);
        bb.putInt(this.height);
        bb.putInt(this.nHeaders);
        bb.putInt(this.nClients);
    }

    static Message decode(ByteBuffer bb, CharSequence name) {
        int width = bb.getInt();
        int height = bb.getInt();
        int nHeaders = bb.getInt();
        int nClients = bb.getInt();
        return new StartMessage(name.toString(), width, height, nHeaders, nClients);
    }

    public String toString() {
        return "StartMessage{imageName=" + this.getImageName() + ", width=" + this.width + ", height=" + this.height + ", nHeaders=" + this.nHeaders + ", nClients=" + this.nClients + '}';
    }
}

