/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.lockmanager;

import java.time.ZoneId;
import java.util.ArrayList;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import org.lsst.ccs.bus.data.AgentLockInfo;
import org.lsst.ccs.utilities.logging.Logger;
import org.lsst.ccs.utilities.taitime.CCSTimeStamp;

class LockMap
extends ConcurrentHashMap<String, AgentLockInfo.AgentLockInfoString> {
    private final Logger log;
    private final Level level;

    LockMap(Logger log, Level level) {
        this.log = log;
        this.level = level;
    }

    @Override
    public AgentLockInfo.AgentLockInfoString putIfAbsent(String agent, AgentLockInfo.AgentLockInfoString value) {
        AgentLockInfo.AgentLockInfoString out = super.putIfAbsent(agent, value);
        if (out == null) {
            this.log(agent, value, "ADD");
        }
        return out;
    }

    @Override
    public AgentLockInfo.AgentLockInfoString remove(Object agent) {
        AgentLockInfo.AgentLockInfoString out = (AgentLockInfo.AgentLockInfoString)super.remove(agent);
        if (out != null) {
            this.log((String)agent, out, "REMOVE");
        }
        return out;
    }

    @Override
    public AgentLockInfo.AgentLockInfoString put(String agent, AgentLockInfo.AgentLockInfoString value) {
        this.log(agent, value, "ADD");
        return super.put(agent, value);
    }

    private void log(String agent, AgentLockInfo.AgentLockInfoString value, String action) {
        if (this.log.isLoggable(this.level)) {
            AgentLockInfo lock = value.getLockInfo();
            StringBuilder sb = new StringBuilder();
            sb.append("LOCK ").append(action).append(" ").append(agent).append(" ");
            sb.append(lock.getOwner()).append(":").append(lock.getMaxLevel()).append("[").append(this.toString(lock.getTimeStamp())).append("]").append(lock.getStatus()).append(". ");
            ArrayList<String> methods = new ArrayList<String>();
            for (StackTraceElement stackTraceElement : Thread.currentThread().getStackTrace()) {
                String className = stackTraceElement.getClassName();
                if (!className.contains("LockManager")) continue;
                methods.add(stackTraceElement.getMethodName());
            }
            sb.append(String.join((CharSequence)"-", methods));
            String message = sb.toString();
            switch (this.level.getName()) {
                case "FINEST": {
                    this.log.finest((Object)message);
                    break;
                }
                case "FINER": {
                    this.log.debug((Object)message);
                    break;
                }
                case "FINE": {
                    this.log.fine((Object)message);
                    break;
                }
                case "INFO": {
                    this.log.info((Object)message);
                    break;
                }
                case "WARNING": {
                    this.log.warn((Object)message);
                    break;
                }
                case "SEVERE": {
                    this.log.error((Object)message);
                    break;
                }
            }
        }
    }

    private String toString(CCSTimeStamp time) {
        return time.getUTCInstant().atZone(ZoneId.systemDefault()).toLocalTime().toString();
    }
}

