/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.imagehandling;

import java.io.File;
import java.io.IOException;
import java.nio.ByteOrder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.logging.Level;
import java.util.logging.Logger;
import nom.tam.fits.FitsException;
import org.lsst.ccs.daq.guider.FitsWriterFactory;
import org.lsst.ccs.daq.guider.GuiderListener;
import org.lsst.ccs.daq.guider.SeriesMetaData;
import org.lsst.ccs.daq.guider.StateMetaData;
import org.lsst.ccs.daq.ims.DAQException;
import org.lsst.ccs.daq.ims.Guider;
import org.lsst.ccs.daq.ims.Store;
import org.lsst.ccs.daq.ims.channel.FitsIntWriter;
import org.lsst.ccs.daq.utilities.FitsService;
import org.lsst.ccs.daq.utilities.FitsServiceInterface;
import org.lsst.ccs.imagenaming.ImageName;
import org.lsst.ccs.subsystem.imagehandling.ImageHandlingConfig;
import org.lsst.ccs.subsystem.imagehandling.PostImageFileHandling;
import org.lsst.ccs.subsystem.imagehandling.data.FileList;
import org.lsst.ccs.utilities.ccd.CCD;
import org.lsst.ccs.utilities.ccd.FocalPlane;
import org.lsst.ccs.utilities.ccd.Reb;
import org.lsst.ccs.utilities.image.FitsHeaderMetadataProvider;
import org.lsst.ccs.utilities.image.HeaderSpecification;
import org.lsst.ccs.utilities.location.SensorLocation;
import org.lsst.ccs.utilities.location.SensorLocationSet;
import org.lsst.ccs.utilities.readout.GeometryFitsHeaderMetadataProvider;

class GuiderHandling {
    private static final Logger LOG = Logger.getLogger(GuiderHandling.class.getName());
    private final ImageHandlingConfig config;
    private final ExecutorService executor;
    private final PostImageFileHandling postImageFileHandling;
    private final List<Future<Object>> activeTasks = new ArrayList<Future<Object>>();
    private final FitsService fitsService;
    private Store guiderStore;
    private final FocalPlane geometry;

    GuiderHandling(ImageHandlingConfig config, ExecutorService executor, FocalPlane geometry, FitsService fitsService, PostImageFileHandling postImageFileHandling) throws DAQException {
        this.config = config;
        this.executor = executor;
        this.postImageFileHandling = postImageFileHandling;
        this.fitsService = fitsService;
        this.geometry = geometry;
    }

    void start() throws DAQException {
        this.guiderStore = new Store(this.config.getGuiderPartition());
        Guider guider = this.guiderStore.getGuider();
        SensorLocationSet guiderLocations = this.config.getGuiderLocations();
        HashMap<File, File> tmpMap = new HashMap<File, File>();
        String partition = guider.getPartition();
        for (SensorLocation sl : guiderLocations) {
            Reb reb = this.geometry.getRebAtLocation(sl.getRebLocation());
            this.fitsService.addReb(reb, "guider");
            FitsServiceInterface fitsServiceForReb = this.fitsService.getFitsServiceForReb(reb);
            CCD ccd = (CCD)reb.getCCDs().get(sl.getSensor());
            ArrayList<FitsHeaderMetadataProvider> providers = new ArrayList<FitsHeaderMetadataProvider>();
            providers.add(fitsServiceForReb.getFitsHeaderMetadataProvider(ccd.getUniqueId()));
            providers.add((FitsHeaderMetadataProvider)new GeometryFitsHeaderMetadataProvider(ccd));
            FitsIntWriter.FileNamer fileNamer = this.config.getFileNamer(tmpMap, true);
            Map headerSpecifications = fitsServiceForReb.getHeaderSpecificationMap();
            GuiderFitsWriterHandlerFactory handler = new GuiderFitsWriterHandlerFactory(partition, fileNamer, headerSpecifications, providers, this.postImageFileHandling, this.config.getIncludeRawStamps());
            this.activeTasks.add(this.executor.submit(() -> {
                try (Guider.Subscriber subscriber = guider.subscribe(Collections.singleton(sl), ByteOrder.BIG_ENDIAN, (GuiderListener)handler);){
                    while (!Thread.currentThread().isInterrupted()) {
                        try {
                            subscriber.waitForGuider();
                        }
                        catch (DAQException x) {
                            LOG.log(Level.SEVERE, "Error during guider data processing for " + sl, x);
                        }
                    }
                }
                return null;
            }));
        }
    }

    void stop() throws DAQException {
        for (Future<Object> task : this.activeTasks) {
            task.cancel(true);
        }
        this.activeTasks.clear();
        if (this.guiderStore != null) {
            this.guiderStore.close();
            this.guiderStore = null;
        }
        this.fitsService.clearAllRebs();
    }

    private static class GuiderFitsWriterHandlerFactory
    extends FitsWriterFactory {
        private final PostImageFileHandling postImageFileHandling;
        private final List<FitsHeaderMetadataProvider> metaDataProviders;

        public GuiderFitsWriterHandlerFactory(String partition, FitsIntWriter.FileNamer fileNamer, Map<String, HeaderSpecification> headerSpecifications, List<FitsHeaderMetadataProvider> metaDataProviders, PostImageFileHandling postImageFileHandling, boolean includeRawStamps) {
            super(partition, fileNamer, headerSpecifications, includeRawStamps);
            this.postImageFileHandling = postImageFileHandling;
            this.metaDataProviders = metaDataProviders;
        }

        protected FitsWriterFactory.FitsWriter createFitsFileWriter(StateMetaData state, SeriesMetaData series, String partition, FitsIntWriter.FileNamer fileNamer, Map<String, HeaderSpecification> headerSpecifications) throws IOException, FitsException {
            return new GuiderFitsWriter(state, series, partition, fileNamer, headerSpecifications, this.metaDataProviders, this.postImageFileHandling);
        }
    }

    private static class GuiderFitsWriter
    extends FitsWriterFactory.FitsWriter {
        private final PostImageFileHandling postImageFileHandling;
        private final SensorLocation sensorLocation;

        public GuiderFitsWriter(StateMetaData state, SeriesMetaData series, String partition, FitsIntWriter.FileNamer fileNamer, Map<String, HeaderSpecification> headerSpecifications, List<FitsHeaderMetadataProvider> metaDataProviders, PostImageFileHandling postImageFileHandling) throws IOException, FitsException {
            super(state, series, partition, fileNamer, headerSpecifications, metaDataProviders);
            this.postImageFileHandling = postImageFileHandling;
            this.sensorLocation = series.getLocation().getLocation();
        }

        public void close() throws IOException, FitsException {
            super.close();
            try {
                ImageName obsId = new ImageName(this.getImageName());
                FileList fl = new FileList();
                fl.add(this.getFileName());
                CompletableFuture<FileList> futureFileList = CompletableFuture.completedFuture(fl);
                futureFileList = this.postImageFileHandling.handleAsynchronousData(futureFileList, obsId);
                this.postImageFileHandling.handleFitsFileCommands(futureFileList, this.sensorLocation.getRebLocation(), obsId, "GUIDER");
            }
            catch (IllegalArgumentException x) {
                LOG.log(Level.WARNING, "Invalid obsid for guider image, ignored: " + this.getImageName(), x);
            }
        }
    }
}

