/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.focalplane;

import java.sql.SQLException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.lsst.ccs.commons.annotations.ConfigurationParameter;
import org.lsst.ccs.commons.annotations.LookupField;
import org.lsst.ccs.framework.HasLifecycle;
import org.lsst.ccs.subsystem.focalplane.ImageDatabase;
import org.lsst.ccs.subsystem.focalplane.InstrumentConfig;

public class ImageDatabaseService
implements HasLifecycle {
    private static final Logger LOG = Logger.getLogger(ImageDatabaseService.class.getName());
    @ConfigurationParameter(isFinal=true, units="unitless", description="Image Database URL")
    private volatile String dbURL;
    @ConfigurationParameter(isFinal=true, units="unitless", description="true/false Image Database enable flag")
    private volatile boolean enabled = true;
    @LookupField(strategy=LookupField.Strategy.TREE)
    private InstrumentConfig instrumentConfig;
    private ImageDatabase idb;

    public static ImageDatabaseService testInstance(String dbURL) {
        ImageDatabaseService idbs = new ImageDatabaseService();
        idbs.dbURL = dbURL;
        return idbs;
    }

    public void shutdown() {
        try {
            if (this.idb != null) {
                this.idb.close();
            }
        }
        catch (SQLException ex) {
            LOG.log(Level.SEVERE, "Error closeing image database", ex);
        }
    }

    public ImageDatabase getImageDatabase() {
        if (this.idb == null && this.enabled) {
            String testStand = this.instrumentConfig == null ? "NOT" : this.instrumentConfig.getTestStand();
            this.idb = new ImageDatabase(this.dbURL, testStand);
        }
        return this.idb;
    }
}

