/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.focalplane;

import java.time.Duration;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.lsst.ccs.StateChangeListener;
import org.lsst.ccs.daq.ims.DAQException;
import org.lsst.ccs.drivers.reb.REBException;
import org.lsst.ccs.services.AgentStateService;
import org.lsst.ccs.subsystem.focalplane.FocalPlaneSubsystem;
import org.lsst.ccs.subsystem.focalplane.IdleClearSupport;
import org.lsst.ccs.subsystem.focalplane.SequencerConfig;
import org.lsst.ccs.subsystem.focalplane.states.FocalPlaneState;
import org.lsst.ccs.subsystem.rafts.AutoCloseableReentrantLock;
import org.lsst.ccs.subsystem.rafts.SequencerProc;
import org.lsst.ccs.subsystem.rafts.data.RaftException;
import org.lsst.ccs.utilities.scheduler.PeriodicTask;
import org.lsst.ccs.utilities.scheduler.Scheduler;
import org.lsst.ccs.utilities.taitime.CCSTimeStamp;

class IdleClear {
    private static final Logger LOG = Logger.getLogger(IdleClear.class.getName());
    private final SequencerConfig sequencerConfig;
    private final IdleClearSupport sequencers;
    private ScheduledFuture<Void> scheduledIdleClear;
    private volatile ScheduledFuture<?> scheduledIdleClearPause;
    private PeriodicTask idleClearPeriodicTask;
    private final Scheduler idleClearScheduler;
    private final AtomicBoolean idleClearLock = new AtomicBoolean(false);
    private final AgentStateService agentStateService;

    public IdleClear(SequencerConfig sequencerConfig, final FocalPlaneSubsystem subsys, IdleClearSupport sequencers) {
        this.sequencerConfig = sequencerConfig;
        this.sequencers = sequencers;
        this.idleClearScheduler = subsys == null ? new Scheduler("IdleClearScheduler", 1) : subsys.getScheduler();
        AgentStateService agentStateService = this.agentStateService = subsys != null ? (AgentStateService)subsys.getAgentService(AgentStateService.class) : null;
        if (this.agentStateService != null) {
            this.agentStateService.addStateChangeListener(new StateChangeListener(){

                public void stateChanged(CCSTimeStamp transitionTime, Object changedObj, Enum<?> newState, Enum<?> oldState) {
                    if (newState == FocalPlaneState.QUIESCENT) {
                        IdleClear.this.focalPlaneEnteredQuiescent(IdleClear.this.agentStateService);
                    } else {
                        subsys.getSequencers().getIdleClear().focalPlaneLeftQuiescent();
                    }
                }
            }, new Class[]{FocalPlaneState.class});
        }
    }

    private void focalPlaneEnteredQuiescent(AgentStateService agentStateService) {
        long idleClearTimeout = this.sequencerConfig.getIdleClearTimeout();
        if (idleClearTimeout >= 0L && this.scheduledIdleClearPause == null) {
            this.scheduledIdleClear = this.idleClearScheduler.schedule(() -> {
                Object object = agentStateService.getStateLock();
                synchronized (object) {
                    if (agentStateService.isInState((Enum)FocalPlaneState.QUIESCENT)) {
                        this.startIdleClear();
                    }
                }
                return null;
            }, idleClearTimeout, TimeUnit.MILLISECONDS);
        }
    }

    private void focalPlaneLeftQuiescent() {
        this.cancelScheduledIdleClear();
    }

    private synchronized void pause(Duration pauseDuration) throws REBException, DAQException, RaftException {
        this.scheduledIdleClearPause = this.idleClearScheduler.schedule(() -> this.restartIdleClearAfterPause(), pauseDuration.toMillis(), TimeUnit.MILLISECONDS);
        this.cancelScheduledIdleClear();
        this.stopIdleClearIfRunning();
    }

    private synchronized void cancelPauseAndRestart() throws REBException, RaftException, DAQException {
        if (this.scheduledIdleClearPause != null) {
            this.scheduledIdleClearPause.cancel(false);
            this.scheduledIdleClearPause = null;
            this.startIdleClear();
        }
    }

    private synchronized void restartIdleClearAfterPause() {
        if (this.scheduledIdleClearPause != null) {
            this.scheduledIdleClearPause = null;
            try {
                this.startIdleClear();
            }
            catch (DAQException | REBException | RaftException x) {
                LOG.log(Level.SEVERE, "Unable to restart idle clear after pause", x);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void stopIdleClearIfRunning() throws REBException, DAQException, RaftException {
        AtomicBoolean atomicBoolean = this.idleClearLock;
        synchronized (atomicBoolean) {
            boolean wasSet = this.idleClearLock.getAndSet(false);
            if (wasSet) {
                this.sequencers.terminateIdleClear(FocalPlaneState.QUIESCENT);
            }
        }
    }

    private synchronized void cancelScheduledIdleClear() {
        if (this.scheduledIdleClear != null) {
            this.scheduledIdleClear.cancel(false);
            this.scheduledIdleClear = null;
        }
    }

    private void startIdleClear() throws REBException, RaftException, DAQException {
        this.startPeriodicTask();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    synchronized void startPeriodicTask() throws REBException, RaftException, DAQException {
        AtomicBoolean atomicBoolean = this.idleClearLock;
        synchronized (atomicBoolean) {
            boolean wasSet = this.idleClearLock.getAndSet(true);
            if (wasSet) {
                throw new IllegalStateException("idleClearLock was already set");
            }
        }
        this.sequencers.prepareForIdleClear();
        this.idleClearPeriodicTask = this.idleClearScheduler.scheduleAtFixedRate(() -> this.idleClear(), 0L, this.sequencerConfig.getIdleClearPeriod().toMillis(), TimeUnit.MILLISECONDS);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void idleClear() {
        AtomicBoolean atomicBoolean = this.idleClearLock;
        synchronized (atomicBoolean) {
            boolean wasSet = this.idleClearLock.get();
            if (!wasSet) {
                return;
            }
        }
        try (AutoCloseableReentrantLock lock = SequencerProc.lockSequencer((long)30L, (TimeUnit)TimeUnit.SECONDS);){
            LOG.log(Level.INFO, "Periodic idleClear");
            try {
                this.sequencers.doIdleClear();
            }
            catch (DAQException | REBException | RaftException x) {
                LOG.log(Level.SEVERE, "Error during idle clear", x);
            }
        }
        catch (AutoCloseableReentrantLock.AutoCloseableReentrantLockException e) {
            LOG.log(Level.WARNING, "Periodic idleClear skipped", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    synchronized void endIdleClear(FocalPlaneState stateOnFinish) throws REBException, RaftException, DAQException {
        AtomicBoolean atomicBoolean = this.idleClearLock;
        synchronized (atomicBoolean) {
            boolean wasSet = this.idleClearLock.getAndSet(false);
            if (!wasSet) {
                throw new IllegalStateException("idleClearLock was already clear");
            }
            if (this.idleClearPeriodicTask != null) {
                this.idleClearPeriodicTask.cancel(false);
                this.idleClearPeriodicTask = null;
            }
            this.sequencers.terminateIdleClear(stateOnFinish);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void commandedEndIdleClear() throws REBException, RaftException, DAQException {
        AtomicBoolean atomicBoolean = this.idleClearLock;
        synchronized (atomicBoolean) {
            if (this.idleClearLock.get()) {
                this.endIdleClear(null);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void commandedStartIdleClear() throws REBException, RaftException, DAQException {
        AtomicBoolean atomicBoolean = this.idleClearLock;
        synchronized (atomicBoolean) {
            if (!this.idleClearLock.get()) {
                this.cancelPauseAndRestart();
            }
        }
    }

    void commandedPauseIdleClear(Duration pause) throws REBException, DAQException, RaftException {
        this.pause(pause);
    }
}

