/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.power;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.TreeMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.lsst.ccs.subsystem.power.PowerSupplyConfiguration;
import org.lsst.ccs.utilities.conv.InputConversionEngine;

public class RebPowerSupplyWiring {
    private static final Logger LOG = Logger.getLogger(RebPowerSupplyWiring.class.getName());
    private final Map<String, PowerSupplyConfiguration> powerSuppliesMap = new TreeMap<String, PowerSupplyConfiguration>();
    private final Map<String, PowerSupplyConfiguration> rebsToPowerSupplyMap = new TreeMap<String, PowerSupplyConfiguration>();
    private final Map<String, String> rebsToPowerSupplyChannelMap = new TreeMap<String, String>();
    private final Map<String, String> rebHeaterToPowerSupplyChannelMap = new TreeMap<String, String>();
    public static final String PROPERTIES_PREFIX = "org.lsst.ccs.power.";

    public RebPowerSupplyWiring(Properties buildProperties) {
        List powerSuppliesList = (List)InputConversionEngine.convertArgToType((String)buildProperties.getProperty("org.lsst.ccs.power.supplies"), List.class);
        if (powerSuppliesList.isEmpty()) {
            LOG.log(Level.WARNING, "No power supplies have been provided in build configuration org.lsst.ccs.power.supplies");
        }
        for (String powerSupply : powerSuppliesList) {
            PowerSupplyConfiguration powerSupplyConfiguration = new PowerSupplyConfiguration(powerSupply, buildProperties);
            this.powerSuppliesMap.put(powerSupply, powerSupplyConfiguration);
            int count = 0;
            for (String reb : powerSupplyConfiguration.getRebs()) {
                if (!reb.isEmpty()) {
                    if (reb.endsWith("Heater")) {
                        String rebName = reb.replace("Heater", "");
                        this.rebHeaterToPowerSupplyChannelMap.put(rebName, String.valueOf(count));
                    } else {
                        if (this.rebsToPowerSupplyMap.containsKey(reb)) {
                            throw new RuntimeException("REB " + reb + " cannot be added to power supply " + powerSupply + " as it has already been assigned to power supply " + this.rebsToPowerSupplyMap.get(reb));
                        }
                        this.rebsToPowerSupplyMap.put(reb, powerSupplyConfiguration);
                        this.rebsToPowerSupplyChannelMap.put(reb, String.valueOf(count));
                    }
                }
                ++count;
            }
        }
    }

    public Collection<PowerSupplyConfiguration> getRebPowerSuppyConfigurations() {
        return this.powerSuppliesMap.values();
    }

    public Set<String> getRebsList() {
        return this.rebsToPowerSupplyMap.keySet();
    }

    public PowerSupplyConfiguration getPowerSupplyConfigurationForReb(String reb) {
        return this.rebsToPowerSupplyMap.get(reb);
    }

    public int getPowerSupplyChannelForReb(String reb) {
        return Integer.valueOf(this.rebsToPowerSupplyChannelMap.get(reb));
    }

    public int getPowerSupplyChannelForRebHeater(String reb) {
        if (!this.rebHeaterToPowerSupplyChannelMap.containsKey(reb)) {
            return -1;
        }
        return Integer.valueOf(this.rebHeaterToPowerSupplyChannelMap.get(reb));
    }
}

