/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.ocsbridge.sim;

import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import org.lsst.ccs.imagenaming.ImageName;
import org.lsst.ccs.subsystem.imagehandling.data.JsonFile;
import org.lsst.ccs.subsystem.ocsbridge.events.ShutterMotionProfileFitResult;
import org.lsst.ccs.subsystem.ocsbridge.sim.ShutterMotionProfileFitter;
import org.lsst.ccs.subsystem.shutter.common.EncoderSample;
import org.lsst.ccs.subsystem.shutter.common.HallTransition;
import org.lsst.ccs.subsystem.shutter.status.MotionDone;
import org.lsst.ccs.utilities.image.DateUtils;
import org.lsst.ccs.utilities.taitime.CCSTimeStamp;

public class ShutterMotionProfileSender {
    private final JsonFile jsonFile;
    private final ShutterMotionProfileFitter fitter;
    private final CCSTimeStamp startTime;

    public ShutterMotionProfileSender(ImageName obsId, MotionDone md, boolean isOpen, ShutterMotionProfileFitter fitter) {
        this.fitter = fitter;
        LinkedHashMap<String, Object> jsonData = new LinkedHashMap<String, Object>();
        jsonData.put("startTime", this.handleTimeStamp(md.startTime()));
        this.startTime = md.startTime();
        jsonData.put("startPosition", md.startPosition());
        jsonData.put("targetPosition", md.targetPosition());
        jsonData.put("endPosition", md.endPosition());
        jsonData.put("targetDuration", this.handleDuration(md.targetDuration()));
        jsonData.put("actionDuration", this.handleDuration(md.actualDuration()));
        jsonData.put("side", md.side().toString());
        jsonData.put("isOpen", isOpen);
        ArrayList encoderSamples = new ArrayList();
        for (EncoderSample es : md.encoderSamples()) {
            LinkedHashMap<String, Object> sample = new LinkedHashMap<String, Object>();
            sample.put("time", this.handleTimeStamp(es.getTime()));
            sample.put("position", es.getPosition());
            encoderSamples.add(sample);
        }
        jsonData.put("encodeSamples", encoderSamples);
        ArrayList hallTransitions = new ArrayList();
        for (HallTransition ht : md.hallTransitions()) {
            LinkedHashMap<String, Object> transition = new LinkedHashMap<String, Object>();
            transition.put("time", this.handleTimeStamp(ht.getTime()));
            transition.put("position", ht.getPosition());
            transition.put("sensorId", ht.getSensorId());
            transition.put("isOn", ht.isOn());
            hallTransitions.add(transition);
        }
        jsonData.put("hallTransitions", hallTransitions);
        jsonData.put("fitResults", fitter.getJsonResult());
        this.jsonFile = new JsonFile(obsId + "_shutterMotionProfile" + (isOpen ? "Open" : "Close") + ".json", "shutterMotionProfile", obsId, "motionProfile", jsonData);
    }

    public ShutterMotionProfileFitResult getEncoderFitResult() {
        return this.fitter.getMotorEncoderFit();
    }

    public ShutterMotionProfileFitResult getHallSensorFitResult() {
        return this.fitter.getHallSensorFit();
    }

    public JsonFile getJsonFile() {
        return this.jsonFile;
    }

    public CCSTimeStamp getStartTime() {
        return this.startTime;
    }

    public double getMidPointTimeFromHallSensor() {
        return this.fitter.getMidPointFromNewtonMethodHall();
    }

    public double getMidPointTimeFromMotorEncoder() {
        return this.fitter.getMidPointFromZeroVelocityMotorEncoder();
    }

    private Object handleTimeStamp(CCSTimeStamp time) {
        LinkedHashMap<String, Object> result = new LinkedHashMap<String, Object>();
        Instant taiInstant = time.getTAIInstant();
        result.put("tai", DateUtils.convertTemporalToString((Object)taiInstant));
        result.put("mjd", DateUtils.convertTemporalToMJD((Object)taiInstant));
        return result;
    }

    private Object handleDuration(Duration duration) {
        return duration.toMillis();
    }
}

