/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.daq.guider;

import com.fasterxml.jackson.core.JacksonException;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.fasterxml.jackson.databind.ser.std.StdSerializer;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.lsst.ccs.daq.guider.ROICommon;
import org.lsst.ccs.daq.guider.ROILocation;
import org.lsst.ccs.daq.ims.DAQException;
import org.lsst.ccs.utilities.location.LocationSet;
import org.lsst.ccs.utilities.location.SensorLocation;
import org.lsst.ccs.utilities.location.SensorLocationSet;

@JsonSerialize(using=ROISpecSerializer.class)
@JsonDeserialize(using=ROISpecDeserializer.class)
public class ROISpec {
    private final ROICommon common;
    private final List<ROILocation> locations;

    ROISpec(ROICommon common, List<ROILocation> locations) {
        this.common = common;
        this.locations = locations;
    }

    public ROICommon getCommon() {
        return this.common;
    }

    public List<ROILocation> getLocations() {
        return this.locations;
    }

    public SensorLocationSet getSensorLocations() {
        return this.locations.stream().map(ROILocation::getLocation).collect(Collectors.toCollection(SensorLocationSet::new));
    }

    public static ROISpec parse(String roiSpec) throws IllegalArgumentException {
        try {
            ObjectMapper om = new ObjectMapper();
            return (ROISpec)om.readValue(roiSpec, ROISpec.class);
        }
        catch (JsonProcessingException x) {
            throw new IllegalArgumentException("Invalid ROISpec " + roiSpec, x);
        }
    }

    public void sanityCheck(LocationSet configuredLocations) throws DAQException {
        for (ROILocation l : this.locations) {
            if (configuredLocations.contains((Object)l.getLocation().getRebLocation())) continue;
            throw new IllegalArgumentException("Location " + l + " not configured as a guider");
        }
    }

    public void sanityCheckWithSensorLocations(SensorLocationSet configuredLocations) throws DAQException {
        for (ROILocation l : this.locations) {
            if (configuredLocations.contains((Object)l.getLocation())) continue;
            throw new IllegalArgumentException("SensorLocation " + l + " not configured as a guider");
        }
    }

    public String toString() {
        try {
            ObjectMapper om = new ObjectMapper();
            return om.writeValueAsString((Object)this);
        }
        catch (JsonProcessingException ex) {
            throw new RuntimeException("Can't happen!!!", ex);
        }
    }

    static class ROISpecDeserializer
    extends StdDeserializer<ROISpec> {
        public ROISpecDeserializer() {
            super(ROISpec.class);
        }

        public ROISpec deserialize(JsonParser jp, DeserializationContext dc) throws IOException, JacksonException {
            ObjectMapper om = new ObjectMapper();
            JsonNode node = (JsonNode)jp.getCodec().readTree(jp);
            JsonNode commonNode = node.get("common");
            ROICommon common = (ROICommon)om.treeToValue((TreeNode)commonNode, ROICommon.class);
            ArrayList<ROILocation> locations = new ArrayList<ROILocation>();
            Iterator fields = node.fields();
            while (fields.hasNext()) {
                Map.Entry next = (Map.Entry)fields.next();
                if (((String)next.getKey()).equals("common")) continue;
                SensorLocation sensorLocation = SensorLocation.of((String)((String)next.getKey()));
                Map map = (Map)om.treeToValue((TreeNode)next.getValue(), Map.class);
                int segment = (Integer)map.get("segment");
                int startRow = (Integer)map.get("startRow");
                int startCol = (Integer)map.get("startCol");
                locations.add(new ROILocation(sensorLocation, segment, startRow, startCol));
            }
            return new ROISpec(common, locations);
        }
    }

    static class ROISpecSerializer
    extends StdSerializer<ROISpec> {
        public ROISpecSerializer() {
            super(ROISpec.class, false);
        }

        public void serialize(ROISpec t, JsonGenerator jg, SerializerProvider sp) throws IOException {
            jg.writeStartObject();
            jg.writeObjectField("common", (Object)t.getCommon());
            for (ROILocation roiLocation : t.getLocations()) {
                LinkedHashMap<String, Integer> map = new LinkedHashMap<String, Integer>();
                map.put("segment", roiLocation.getSegment());
                map.put("startRow", roiLocation.getStartRow());
                map.put("startCol", roiLocation.getStartCol());
                SensorLocation sensorLocation = roiLocation.getLocation();
                jg.writeObjectField(sensorLocation.toString(), map);
            }
            jg.writeEndObject();
        }
    }
}

