/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.logging;

import java.util.logging.Level;

public interface Log {
    public boolean isFatalEnabled();

    public boolean isErrorEnabled();

    public boolean isWarnEnabled();

    public boolean isInfoEnabled();

    public boolean isDebugEnabled();

    public boolean isTraceEnabled();

    public void fatal(String var1);

    public void fatal(String var1, Object ... var2);

    public void fatal(String var1, Throwable var2);

    public void error(String var1);

    public void error(String var1, Object ... var2);

    public void error(String var1, Throwable var2);

    public void warn(String var1);

    public void warn(String var1, Object ... var2);

    public void warn(String var1, Throwable var2);

    public void info(String var1);

    public void info(String var1, Object ... var2);

    public void debug(String var1);

    public void debug(String var1, Object ... var2);

    public void debug(String var1, Throwable var2);

    public void trace(Object var1);

    public void trace(String var1);

    public void trace(String var1, Object ... var2);

    public void trace(String var1, Throwable var2);

    default public boolean isEnabled(Level level) {
        if (level == null) {
            return false;
        }
        return switch (level.getName()) {
            case "OFF" -> this.isFatalEnabled();
            case "SEVERE" -> this.isErrorEnabled();
            case "WARNING" -> this.isWarnEnabled();
            case "INFO" -> this.isInfoEnabled();
            case "CONFIG", "FINE" -> this.isDebugEnabled();
            case "FINER", "FINEST" -> this.isTraceEnabled();
            case "ALL" -> false;
            default -> throw new IllegalArgumentException("Unknown level " + level);
        };
    }

    default public void out(Level level, String msg) {
        if (level == null) {
            return;
        }
        switch (level.getName()) {
            case "OFF": {
                this.fatal(msg);
                break;
            }
            case "SEVERE": {
                this.error(msg);
                break;
            }
            case "WARNING": {
                this.warn(msg);
                break;
            }
            case "INFO": {
                this.info(msg);
                break;
            }
            case "CONFIG": 
            case "FINE": {
                this.debug(msg);
                break;
            }
            case "FINER": 
            case "FINEST": {
                this.trace(msg);
                break;
            }
            case "ALL": {
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown level " + level);
            }
        }
    }

    default public void out(Level level, String format, Object ... args) {
        if (level == null) {
            return;
        }
        switch (level.getName()) {
            case "OFF": {
                this.fatal(format, args);
                break;
            }
            case "SEVERE": {
                this.error(format, args);
                break;
            }
            case "WARNING": {
                this.warn(format, args);
                break;
            }
            case "INFO": {
                this.info(format, args);
                break;
            }
            case "CONFIG": 
            case "FINE": {
                this.debug(format, args);
                break;
            }
            case "FINER": 
            case "FINEST": {
                this.trace(format, args);
                break;
            }
            case "ALL": {
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown level " + level);
            }
        }
    }

    default public void out(Level level, String msg, Throwable throwable) {
        if (level == null) {
            return;
        }
        switch (level.getName()) {
            case "OFF": {
                this.fatal(msg, throwable);
                break;
            }
            case "SEVERE": {
                this.error(msg, throwable);
                break;
            }
            case "WARNING": {
                this.warn(msg, throwable);
                break;
            }
            case "INFO": {
                this.info(msg + ". " + throwable);
                break;
            }
            case "CONFIG": 
            case "FINE": {
                this.debug(msg, throwable);
                break;
            }
            case "FINER": 
            case "FINEST": {
                this.trace(msg, throwable);
                break;
            }
            case "ALL": {
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown level " + level);
            }
        }
    }

    public void setLevel(String var1);

    public String getLevel();
}

