/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.bonnshutter;

import java.util.logging.Level;
import java.util.logging.Logger;
import org.lsst.ccs.bus.states.AlertState;
import org.lsst.ccs.drivers.commons.DriverException;
import org.lsst.ccs.drivers.gpio.GPIODriver;
import org.lsst.ccs.drivers.gpio.GPIODriverUno1483;
import org.lsst.ccs.services.AgentStateService;
import org.lsst.ccs.services.alert.AlertService;
import org.lsst.ccs.subsystem.bonnshutter.alerts.BonnShutterAlerts;
import org.lsst.ccs.subsystem.bonnshutter.states.ShutterState;

class ShutterGPIOMonitor {
    private final AlertService alertService;
    private static final Logger LOG = Logger.getLogger(ShutterGPIOMonitor.class.getName());
    private final AgentStateService agentStateService;
    private final int openCloseGPIO = 4;
    private final int shutterAGPIO = 0;
    private final int shutterBGPIO = 1;
    private final int shutterErrorGPIO = 2;
    private final GPIODriver driver;
    private final GPIODriver.GPIOChannel shutterAChannel;
    private final GPIODriver.GPIOChannel shutterBChannel;
    private final GPIODriver.GPIOChannel errorChannel;
    private final GPIODriver.GPIOChannel openCloseChannel;
    private BladeState shutterAState;
    private BladeState shutterBState;
    private boolean errorState;
    private Thread monitorThread;

    ShutterGPIOMonitor(AgentStateService agentStateService, AlertService alertService) throws DriverException {
        this.agentStateService = agentStateService;
        this.alertService = alertService;
        this.driver = new GPIODriverUno1483();
        this.shutterAChannel = this.driver.getChannel(0);
        this.shutterBChannel = this.driver.getChannel(1);
        this.errorChannel = this.driver.getChannel(2);
        this.openCloseChannel = this.driver.getChannel(4);
        alertService.registerAlert(BonnShutterAlerts.SHUTTER_ERROR.newAlert());
        alertService.registerAlert(BonnShutterAlerts.GPIO_DRIVER.newAlert());
    }

    void start() {
        this.monitorThread = new Thread("shutterMonitor"){

            @Override
            public void run() {
                try {
                    ShutterGPIOMonitor.this.runMonitor();
                }
                catch (DriverException ex) {
                    LOG.log(Level.SEVERE, "Monitor thread exited", ex);
                }
            }
        };
        this.monitorThread.setDaemon(true);
        this.monitorThread.start();
    }

    void stop() {
        if (this.monitorThread != null && this.monitorThread.isAlive()) {
            this.monitorThread.interrupt();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void runMonitor() throws DriverException {
        try {
            this.shutterAChannel.lock();
            this.shutterBChannel.lock();
            this.errorChannel.lock();
            while (!Thread.interrupted()) {
                boolean shutterClosed;
                boolean e;
                BladeState a = this.shutterAChannel.read() ? BladeState.OPEN : BladeState.CLOSED;
                BladeState b = this.shutterBChannel.read() ? BladeState.OPEN : BladeState.CLOSED;
                boolean bl = e = !this.errorChannel.read();
                if (a != this.shutterAState) {
                    LOG.log(Level.INFO, "Shutter A State now: {0}", (Object)a);
                    this.shutterAState = a;
                }
                if (b != this.shutterBState) {
                    LOG.log(Level.INFO, "Shutter B State now: {0}", (Object)b);
                    this.shutterBState = b;
                }
                boolean bl2 = shutterClosed = a == BladeState.CLOSED || b == BladeState.CLOSED;
                if (this.agentStateService.isInState((Enum)ShutterState.CLOSED) && !shutterClosed) {
                    this.agentStateService.updateAgentState(new Enum[]{ShutterState.OPEN});
                } else if (this.agentStateService.isInState((Enum)ShutterState.OPEN) && shutterClosed) {
                    this.agentStateService.updateAgentState(new Enum[]{ShutterState.CLOSED});
                }
                if (e == this.errorState) continue;
                LOG.log(Level.INFO, "Error State now: {0}", e);
                this.errorState = e;
                String msg = String.format("BonnShutter GPIOCHANNEL.errorChannel changed to %b", e);
                this.alertService.raiseAlert(BonnShutterAlerts.SHUTTER_ERROR.newAlert(), e ? AlertState.ALARM : AlertState.NOMINAL, msg);
            }
        }
        catch (DriverException ex) {
            LOG.log(Level.SEVERE, "BonnShutter GPIO DriverException", ex);
            this.alertService.raiseAlert(BonnShutterAlerts.GPIO_DRIVER.newAlert(), AlertState.ALARM, "GPIO DriverException");
        }
        finally {
            this.shutterAChannel.unlock();
            this.shutterBChannel.unlock();
            this.errorChannel.unlock();
        }
    }

    void open() throws DriverException {
        this.openCloseChannel.set();
    }

    void close() throws DriverException {
        this.openCloseChannel.clear();
    }

    void expose(double duration) {
        throw new UnsupportedOperationException("expose via GPIO not implemented");
    }

    private static enum BladeState {
        CLOSED,
        OPEN;

    }
}

