/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.lockmanager;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import org.lsst.ccs.Agent;
import org.lsst.ccs.ConfigurationService;
import org.lsst.ccs.PersistencyService;
import org.lsst.ccs.Subsystem;
import org.lsst.ccs.bus.data.AgentInfo;
import org.lsst.ccs.bus.data.AgentLockInfo;
import org.lsst.ccs.bus.messages.StatusLock;
import org.lsst.ccs.bus.messages.StatusLockAggregate;
import org.lsst.ccs.bus.messages.StatusMessage;
import org.lsst.ccs.command.annotations.Argument;
import org.lsst.ccs.command.annotations.Command;
import org.lsst.ccs.commons.annotations.ConfigurationParameter;
import org.lsst.ccs.commons.annotations.LookupField;
import org.lsst.ccs.commons.annotations.Persist;
import org.lsst.ccs.framework.HasLifecycle;
import org.lsst.ccs.messaging.AgentMessagingLayer;
import org.lsst.ccs.messaging.AgentPresenceListener;
import org.lsst.ccs.messaging.BusMessageFilterFactory;
import org.lsst.ccs.messaging.StatusMessageListener;
import org.lsst.ccs.services.AgentLockService;
import org.lsst.ccs.services.AgentStateService;
import org.lsst.ccs.subsystem.lockmanager.LockMap;
import org.lsst.ccs.utilities.logging.Logger;

public class LockManager
extends Subsystem
implements HasLifecycle {
    private static final Logger log = Logger.getLogger((String)"org.lsst.ccs.subsystem.lockmanager");
    @LookupField(strategy=LookupField.Strategy.CHILDREN)
    AgentLockService agentLockService;
    @LookupField(strategy=LookupField.Strategy.TREE)
    AgentStateService agentStateService;
    @LookupField(strategy=LookupField.Strategy.TOP)
    private Agent agent;
    private AgentMessagingLayer aml;
    @LookupField(strategy=LookupField.Strategy.TREE)
    private PersistencyService localPersistenceService;
    @Persist
    volatile ConcurrentHashMap<String, AgentLockInfo.AgentLockInfoString> locksByAgentName = new LockMap(log, Level.FINE);
    @ConfigurationParameter(description="Map of max levels", maxLength=150, units="unitless")
    private volatile Map<String, Map<String, String>> maxLevelMap = new TreeMap<String, Map<String, String>>();
    ConcurrentHashMap<String, AgentLockInfo.AgentLockInfoString> locksByToken = new ConcurrentHashMap();
    ConcurrentHashMap<String, CountDownLatch> latches = new ConcurrentHashMap();
    Set<String> lockUnawareWorkers = new HashSet<String>();
    private final ThreadLocal<Boolean> executingLockOrAttach = new ThreadLocal();
    StatusMessageListener sml = new StatusMessageListener(){

        public void onStatusMessage(StatusMessage msg) {
            Serializable o = msg.getObject();
            if (!(o instanceof AgentLockInfo)) {
                return;
            }
            AgentLockInfo lock = (AgentLockInfo)o;
            String source = msg.getOriginAgentInfo().getName();
            if ("lockmanager".equals(source)) {
                return;
            }
            log.info((Object)("LM got message from " + source + " : " + lock));
            CountDownLatch latch = LockManager.this.latches.get(lock.getAgentName());
            if (latch == null) {
                return;
            }
            if (lock.getStatus() != AgentLockInfo.Status.ACKNOWLEDGED && lock.getStatus() != AgentLockInfo.Status.REJECTED) {
                return;
            }
            if (lock.getStatus() == AgentLockInfo.Status.REJECTED) {
                log.warning((Object)("Rejected lock " + lock));
                LockManager.this.latches.remove(lock.getAgentName());
                LockManager.this.removeLock(lock);
                latch.countDown();
                return;
            }
            if (!LockManager.this.locksByAgentName.containsKey(lock.getAgentName()) && LockManager.this.locksByAgentName.get(lock.getAgentName()).getLockInfo().getStatus() != AgentLockInfo.Status.REQUESTED) {
                log.error((Object)("Inconsistent state, received " + lock + " with latch " + latch + " and request " + LockManager.this.locksByAgentName.get(lock.getAgentName())));
                LockManager.this.latches.remove(lock.getAgentName());
                LockManager.this.removeLock(lock);
                latch.countDown();
                return;
            }
            log.info((Object)("received acknowledged lock " + lock));
            LockManager.this.addLock(lock);
            LockManager.this.localPersistenceService.persistNow();
            latch.countDown();
        }
    };
    AgentPresenceListener apl = new AgentPresenceListener(){

        public void connected(AgentInfo ... agents) {
            HashSet<String> sent = new HashSet<String>();
            boolean lockerHasConnected = false;
            for (AgentInfo ai : agents) {
                String lockableInfo;
                AgentLockInfo.AgentLockInfoString lis;
                AgentLockInfo lockInfo;
                AgentInfo.AgentType tp = ai.getType();
                if (!(lockerHasConnected || tp != AgentInfo.AgentType.CONSOLE && tp != AgentInfo.AgentType.MCM && tp != AgentInfo.AgentType.OCS_BRIDGE)) {
                    lockerHasConnected = true;
                }
                AgentLockInfo agentLockInfo = lockInfo = (lis = LockManager.this.locksByAgentName.get(ai.getName())) == null ? null : lis.getLockInfo();
                if (lockInfo != null) {
                    log.info((Object)("refreshing lock, agent just connected " + lockInfo.getAgentName() + " by " + lockInfo.getOwner()));
                    AgentLockInfo refresh = AgentLockInfo.createReminder((AgentLockInfo)lockInfo);
                    StatusLock msg = new StatusLock(refresh);
                    LockManager.this.sendStatusMessage((StatusMessage)msg);
                    sent.add(lockInfo.getToken());
                }
                if ("true".equals(lockableInfo = ai.getAgentProperty("lockable"))) continue;
                LockManager.this.lockUnawareWorkers.add(ai.getName());
            }
            if (lockerHasConnected) {
                ArrayList<AgentLockInfo> ll = new ArrayList<AgentLockInfo>();
                for (AgentLockInfo.AgentLockInfoString lis : LockManager.this.locksByAgentName.values()) {
                    AgentLockInfo lock = lis.getLockInfo();
                    if (sent.contains(lock.getToken())) continue;
                    AgentLockInfo refresh = AgentLockInfo.createInfo((AgentLockInfo)lock);
                    ll.add(refresh);
                }
                AgentLockInfo[] larr = ll.toArray(new AgentLockInfo[0]);
                StatusLockAggregate msg = new StatusLockAggregate(larr);
                LockManager.this.sendStatusMessage((StatusMessage)msg);
            }
        }

        public void disconnected(AgentInfo ... agents) {
            for (AgentInfo ai : agents) {
                AgentLockInfo lockInfo;
                LockManager.this.lockUnawareWorkers.remove(ai.getName());
                if (ai.getType() != AgentInfo.AgentType.CONSOLE || (lockInfo = LockManager.this.getLockInfo(ai.getName())) == null) continue;
                LockManager.this.locksByAgentName.remove(lockInfo.getAgentName());
                lockInfo = AgentLockInfo.createRelease((String)lockInfo.getAgentName(), (String)lockInfo.getOwner());
                StatusLock msg = new StatusLock(lockInfo);
                msg.setState(LockManager.this.agentStateService.getState());
                LockManager.this.aml.sendStatusMessage((StatusMessage)msg);
            }
        }
    };

    public LockManager(String name) {
        super(name, AgentInfo.AgentType.LOCK_MANAGER);
    }

    public LockManager() {
        super("lockmanager", AgentInfo.AgentType.LOCK_MANAGER);
    }

    protected void addLock(AgentLockInfo lock) {
        AgentLockInfo.AgentLockInfoString lis = new AgentLockInfo.AgentLockInfoString(lock);
        this.locksByAgentName.put(lock.getAgentName(), lis);
        this.locksByToken.put(lock.getToken(), lis);
    }

    protected void removeLock(AgentLockInfo lock) {
        if (lock != null && lock.getToken() == null) {
            lock = this.locksByAgentName.get(lock.getAgentName()).getLockInfo();
        }
        if (lock != null) {
            this.locksByAgentName.remove(lock.getAgentName());
            this.locksByToken.remove(lock.getToken());
        }
    }

    public void init() {
        boolean loadAtStartup = true;
        boolean persistAtShutdown = true;
        this.localPersistenceService.setAutomatic(loadAtStartup, persistAtShutdown);
    }

    public void postInit() {
        this.maxLevelMap = LockManager.normalizeLevelsConfig(this.maxLevelMap);
    }

    public void postStart() {
        this.aml = this.agent.getMessagingAccess();
        this.aml.addStatusMessageListener(this.sml, BusMessageFilterFactory.embeddedObjectClass(AgentLockInfo.class));
        this.aml.getAgentPresenceManager().addAgentPresenceListener(this.apl);
        for (AgentLockInfo.AgentLockInfoString lis : this.locksByAgentName.values()) {
            String token;
            boolean deadConsole;
            AgentLockInfo lock = lis.getLockInfo();
            String agentName = lock.getAgentName();
            boolean bl = deadConsole = agentName.startsWith("ccs-shell_") || agentName.startsWith("CCS-Graphical-Console_");
            if (deadConsole) {
                boolean bl2 = deadConsole = !this.aml.getAgentPresenceManager().agentExists(agentName);
            }
            if ((token = lock.getToken()) == null || deadConsole) {
                this.locksByAgentName.remove(agentName);
                continue;
            }
            this.locksByToken.put(token, lis);
        }
    }

    @Command(type=Command.CommandType.QUERY, category=Command.CommandCategory.SYSTEM, description="destroys a lock", level=0, autoAck=false)
    public void destroyLock(@Argument(name="agentName", description="agent name") String agentName, String userId) {
        log.debug((Object)("got destroy command for " + agentName + " from " + userId));
        AgentLockInfo lockInfo = this.getLockInfo(agentName);
        if (lockInfo == null) {
            this.sendNack((Serializable)((Object)"The subsystem is not locked."));
            return;
        }
        if (this.agentLockService.getMaxLevel(userId, lockInfo.getAgentName()) < 1) {
            this.sendNack((Serializable)((Object)("User " + userId + " is not authorized to destroy locks.")));
            return;
        }
        this.sendAck(null);
        this.locksByAgentName.remove(lockInfo.getAgentName());
        lockInfo = AgentLockInfo.createRelease((String)lockInfo.getAgentName(), (String)lockInfo.getOwner());
        StatusLock msg = new StatusLock(lockInfo);
        msg.setState(this.agentStateService.getState());
        this.aml.sendStatusMessage((StatusMessage)msg);
    }

    @Command(type=Command.CommandType.QUERY, category=Command.CommandCategory.SYSTEM, description="lock a subsystem", level=0, autoAck=false)
    public AgentLockInfo lockAgent(@Argument(name="lock", description="Lock request") AgentLockInfo lock) {
        log.debug((Object)("got lock command for " + lock.getAgentName() + " from " + lock.getOwner()));
        if (lock.getOwner() == null) {
            this.sendNack((Serializable)((Object)"Cannot lock with null user."));
            return null;
        }
        if (lock.getStatus() != AgentLockInfo.Status.REQUESTED) {
            this.sendNack((Serializable)((Object)("Lock request with bad status " + lock.getStatus())));
            return null;
        }
        AgentLockInfo lockInfo = this.getLockInfo(lock.getAgentName());
        if (lockInfo != null) {
            if (!lock.getOwner().equals(lockInfo.getOwner())) {
                this.sendNack((Serializable)((Object)("Lock is owned by another user: " + lockInfo.getOwner())));
                return null;
            }
            if (this.executingLockOrAttach.get() == null) {
                this.sendNack((Serializable)((Object)("You already own the lock, please use \"attachLock " + lockInfo.getAgentName() + "\"")));
                return null;
            }
            throw new IllegalStateException();
        }
        this.sendAck(null);
        AgentLockInfo.AgentLockInfoString old = this.locksByAgentName.putIfAbsent(lock.getAgentName(), new AgentLockInfo.AgentLockInfoString(lock));
        if (old != null) {
            return null;
        }
        AgentLockInfo updatedLock = null;
        if (this.lockUnawareWorkers.contains(lock.getAgentName())) {
            updatedLock = AgentLockInfo.createAcknowledgeLegacy((AgentLockInfo)lock, (int)this.agentLockService.getMaxLevel(lock.getOwner(), lock.getAgentName()));
            StatusLock msg = new StatusLock(updatedLock);
            this.sendStatusMessage((StatusMessage)msg);
            this.addLock(updatedLock);
        } else {
            CountDownLatch latch = new CountDownLatch(1);
            AgentLockInfo lockRequest = AgentLockInfo.createLockRequest((AgentLockInfo)lock, (int)this.agentLockService.getMaxLevel(lock.getOwner(), lock.getAgentName()));
            this.latches.put(lockRequest.getAgentName(), latch);
            StatusLock msg = new StatusLock(lockRequest);
            this.sendStatusMessage((StatusMessage)msg);
            log.info((Object)("sent message, waiting. Level: " + lockRequest.getMaxLevel()));
            try {
                latch.await(500L, TimeUnit.MILLISECONDS);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            updatedLock = this.getLockInfo(lock.getAgentName());
            if (updatedLock != null && updatedLock.getStatus() != AgentLockInfo.Status.ACKNOWLEDGED) {
                log.info((Object)("did not receive ack for" + updatedLock + " status " + updatedLock.getStatus()));
                this.locksByAgentName.remove(updatedLock.getAgentName());
                updatedLock = null;
            }
            if (updatedLock != null) {
                log.info((Object)("got lock ack " + updatedLock + " token " + updatedLock.getToken()));
            }
            assert (updatedLock == null || updatedLock.getStatus() == AgentLockInfo.Status.ACKNOWLEDGED);
            this.latches.remove(lock.getAgentName());
        }
        return updatedLock;
    }

    @Command(type=Command.CommandType.QUERY, category=Command.CommandCategory.SYSTEM, description="unlock a subsystem", level=0, autoAck=false)
    public void unlockAgent(@Argument(name="lock", description="Unlock request") AgentLockInfo lock) {
        log.info((Object)("got unlock command for " + lock.getAgentName() + " from " + lock.getOwner()));
        if (lock.getStatus() != AgentLockInfo.Status.RELEASED) {
            this.sendNack((Serializable)((Object)("Lock request with bad status " + lock.getStatus())));
            return;
        }
        AgentLockInfo lockInfo = this.getLockInfo(lock.getAgentName());
        if (lockInfo == null) {
            this.sendNack((Serializable)((Object)"The subsystem is not locked."));
            return;
        }
        if (!lockInfo.getOwner().equals(lock.getOwner())) {
            this.sendNack((Serializable)((Object)("Lock is owned by another user: " + lockInfo.getOwner())));
            return;
        }
        this.sendAck(null);
        this.removeLock(lock);
        StatusLock msg = new StatusLock(lock);
        msg.setState(this.agentStateService.getState());
        this.aml.sendStatusMessage((StatusMessage)msg);
    }

    @Command(type=Command.CommandType.QUERY, category=Command.CommandCategory.SYSTEM, description="attach a locked subsystem", level=0, autoAck=false)
    public AgentLockInfo attachLock(@Argument(name="lock", description="Attach request") AgentLockInfo lock) {
        log.info((Object)("got attach command for " + lock.getAgentName() + " from " + lock.getOwner()));
        if (lock.getStatus() != AgentLockInfo.Status.ATTACH) {
            this.sendNack((Serializable)((Object)("Lock request with bad status " + lock.getStatus())));
            return null;
        }
        AgentLockInfo knownLock = null;
        if (lock.getToken() != null) {
            knownLock = this.locksByToken.get(lock.getToken()).getLockInfo();
            if (knownLock == null) {
                this.sendNack((Serializable)((Object)("invalid lock token " + lock.getToken())));
                return null;
            }
            if (lock.getAgentName() != null && !lock.getAgentName().equals(knownLock.getAgentName())) {
                this.sendNack((Serializable)((Object)("inconsistent agent name for lock: " + lock.getToken() + " " + lock.getAgentName() + " " + knownLock.getAgentName())));
                return null;
            }
        } else if (lock.getAgentName() != null) {
            AgentLockInfo.AgentLockInfoString ls = this.locksByAgentName.get(lock.getAgentName());
            if (ls != null) {
                knownLock = ls.getLockInfo();
            }
        } else {
            this.sendNack((Serializable)((Object)"Invalid lock info, no token, no agentName"));
            return null;
        }
        if (knownLock == null) {
            this.sendNack((Serializable)((Object)"The subsystem is not locked."));
            return null;
        }
        if (!knownLock.getOwner().equals(lock.getOwner())) {
            this.sendNack((Serializable)((Object)("Lock is owned by another user: " + knownLock.getOwner())));
            return null;
        }
        StatusLock msg = new StatusLock(lock);
        this.sendStatusMessage((StatusMessage)msg);
        this.sendAck(null);
        return knownLock;
    }

    @Command(type=Command.CommandType.QUERY, category=Command.CommandCategory.SYSTEM, description="detach a locked subsystem", level=0)
    public void detachLock(@Argument(name="lock", description="Detach request") AgentLockInfo lock) {
        log.info((Object)("got detach command for " + lock.getAgentName() + " from " + lock.getOwner()));
        StatusLock msg = new StatusLock(lock);
        this.sendStatusMessage((StatusMessage)msg);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Command(type=Command.CommandType.QUERY, category=Command.CommandCategory.SYSTEM, description="lock a subsystem, or attach a lock if it already exists", level=0, autoAck=false)
    public AgentLockInfo lockOrAttach(@Argument(name="lock", description="Lock request") AgentLockInfo lock) {
        log.info((Object)("got lockOrAttach command for " + lock.getAgentName() + " from " + lock.getOwner()));
        this.executingLockOrAttach.set(true);
        try {
            AgentLockInfo agentLockInfo = this.lockAgent(lock);
            return agentLockInfo;
        }
        catch (IllegalStateException x) {
            AgentLockInfo request = AgentLockInfo.createAttachRequest((AgentLockInfo)lock, (AgentLockInfo)lock);
            AgentLockInfo agentLockInfo = this.attachLock(request);
            return agentLockInfo;
        }
        finally {
            this.executingLockOrAttach.set(null);
        }
    }

    private AgentLockInfo getLockInfo(String agentName) {
        AgentLockInfo.AgentLockInfoString lockInfoString = this.locksByAgentName.get(agentName);
        return lockInfoString == null ? null : lockInfoString.getLockInfo();
    }

    @Command(type=Command.CommandType.QUERY, category=Command.CommandCategory.SYSTEM, description="for the given user, returns a map of name or name wildcard to maximum allowed level", level=0, autoAck=false)
    public Map<String, Integer> getMaxLevelUser(@Argument(name="user", description="User ID") String user) {
        Map out = AgentLockService.getMaxLevelsUser((String)user, this.maxLevelMap);
        log.fine((Object)("Responding to getMaxLevelUser with " + out));
        return out;
    }

    @Command(type=Command.CommandType.QUERY, category=Command.CommandCategory.SYSTEM, description="for the given agent, returns a map of users to maximum allowed levels", level=0, autoAck=false)
    public Map<String, Integer> getMaxLevelSubsystem(@Argument(name="subsystem", description="Subsystem name") String subsystem) {
        Map out = AgentLockService.getMaxLevelsSubsystem((String)subsystem, this.maxLevelMap);
        log.fine((Object)("Responding to getMaxLevelSubsystem with " + out));
        return out;
    }

    @Command(type=Command.CommandType.QUERY, category=Command.CommandCategory.USER, description="Prints maximum authorized lock levels for the specified user", level=0, autoAck=false)
    public String printMaxLevels(@Argument(name="user", description="User ID or group name. Leave empty to print max levels for all users.", defaultValue="") String user, @Argument(name="expand", description="If true, any groups the user belongs to are expanded, and actual max levels for subsystems are printed.", defaultValue="false") boolean expand) {
        if (this.maxLevelMap.isEmpty()) {
            return "";
        }
        String string = user = user == null ? "" : user.strip();
        if (expand) {
            if (user.isEmpty()) {
                LinkedList<String> users = new LinkedList<String>();
                for (String u : this.maxLevelMap.keySet()) {
                    if (this.maxLevelMap.containsKey("@" + u)) continue;
                    Map<String, Integer> userMap = this.getMaxLevelUser(u);
                    StringBuilder sb = new StringBuilder();
                    sb.append(u).append(" : [");
                    sb.append(String.join((CharSequence)", ", userMap.entrySet().stream().map(e -> (String)e.getKey() + " : " + e.getValue()).toList()));
                    sb.append("]");
                    users.add(sb.toString());
                }
                return String.join((CharSequence)System.lineSeparator(), users);
            }
            Map<String, Integer> userMap = this.getMaxLevelUser(user);
            return String.join((CharSequence)System.lineSeparator(), userMap.entrySet().stream().map(e -> (String)e.getKey() + " : " + e.getValue()).toList());
        }
        if (user.isEmpty()) {
            TreeMap<String, Map> groups = new TreeMap<String, Map>();
            TreeMap<String, Map> users = new TreeMap<String, Map>();
            this.maxLevelMap.forEach((k, v) -> {
                if (k.startsWith("@")) {
                    groups.put(k.substring(1), (Map)v);
                } else {
                    users.put((String)k, (Map)v);
                }
            });
            StringBuilder sb = new StringBuilder();
            sb.append("Groups:").append(System.lineSeparator());
            groups.forEach((k, v) -> sb.append("  ").append((String)k).append(" : ").append(AgentLockService.User.levelsToString((Map)v, (boolean)true)).append(System.lineSeparator()));
            sb.append("Users:").append(System.lineSeparator());
            groups.keySet().forEach(key -> users.remove(key));
            users.forEach((k, v) -> sb.append("  ").append((String)k).append(" : ").append(AgentLockService.User.levelsToString((Map)v, (boolean)true)).append(System.lineSeparator()));
            return sb.toString();
        }
        Map<String, String> v2 = this.maxLevelMap.get(user);
        if (v2 == null) {
            throw new IllegalArgumentException("No such user or group: " + user);
        }
        return AgentLockService.User.levelsToString(v2, (boolean)false);
    }

    @Command(type=Command.CommandType.QUERY, category=Command.CommandCategory.USER, description="Adds, removes, or modifies an authorized user.", level=2, autoAck=false)
    public String setUser(@Argument(name="user", description="User ID") String user, @Argument(name="maxLevels", description="Group name, or a map of subsystem names to maximum allowed levels.") String maxLevels) {
        user = user.strip();
        TreeMap<String, Map<String, String>> config = new TreeMap<String, Map<String, String>>(this.maxLevelMap);
        Object out = "";
        if (maxLevels == null || maxLevels.isBlank()) {
            Map<String, String> v = config.remove(user);
            if (v == null) {
                throw new IllegalArgumentException("No such user: " + user);
            }
            out = "Removed user " + user + ".";
        } else {
            LinkedHashMap v = AgentLockService.User.levelsFromString((String)maxLevels);
            StringBuilder sb = new StringBuilder(config.put(user, v) == null ? "Added" : "Modified");
            out = sb.append(" user ").append(user).append(" : ").append(AgentLockService.User.levelsToString((Map)v, (boolean)true)).toString();
        }
        ((ConfigurationService)this.getAgentService(ConfigurationService.class)).change("/", "maxLevelMap", config);
        return out;
    }

    @Command(type=Command.CommandType.QUERY, category=Command.CommandCategory.USER, description="Adds, removes, or modifies a group of authorized users.", level=2, autoAck=false)
    public String setGroup(@Argument(name="group", description="Group name") String group, @Argument(name="maxLevels", description="String representation of a map of subsystem names to maximum allowed levels. Leave empty to delete the group.") String maxLevels) {
        group = group.strip();
        TreeMap<String, Map<String, String>> config = new TreeMap<String, Map<String, String>>(this.maxLevelMap);
        Object out = "";
        if (maxLevels == null || maxLevels.isBlank()) {
            Map<String, String> v = config.remove("@" + group);
            v = config.remove(group);
            if (v == null) {
                throw new IllegalArgumentException("No such group: " + group);
            }
            out = "Removed group " + group + ".";
        } else {
            LinkedHashMap v = AgentLockService.User.levelsFromString((String)maxLevels);
            config.put(group, v);
            StringBuilder sb = new StringBuilder(config.put("@" + group, v) == null ? "Added" : "Modified");
            out = sb.append(" group ").append(group).append(" : ").append(AgentLockService.User.levelsToString((Map)v, (boolean)true)).toString();
        }
        ((ConfigurationService)this.getAgentService(ConfigurationService.class)).change("/", "maxLevelMap", config);
        return out;
    }

    @Command(type=Command.CommandType.QUERY, category=Command.CommandCategory.USER, description="Modifies maximum level settings of an authorized user or group by setting explicit level for the specified subsystem.", level=2, autoAck=false)
    public String setMaxLevel(@Argument(name="user", description="Existing user ID or group name") String user, @Argument(name="subsystem", description="Subsystem name or a wildcard") String subsystem, @Argument(name="maxLevel", description="Maximum allowed level.") String maxLevel) {
        user = user.strip();
        subsystem = subsystem.strip();
        maxLevel = maxLevel.strip();
        TreeMap<String, Map<String, String>> config = new TreeMap<String, Map<String, String>>(this.maxLevelMap);
        Object k = user;
        LinkedHashMap v = config.get(k);
        if (v == null) {
            k = "@" + (String)k;
            v = config.get(k);
        }
        if (v == null) {
            throw new IllegalArgumentException("No such user or group: " + user);
        }
        v = new LinkedHashMap<String, String>(v);
        v.remove(subsystem);
        String s = AgentLockService.User.levelsToString(v, (boolean)false);
        v = AgentLockService.User.levelsFromString((String)(s + "," + subsystem + ":" + maxLevel));
        config.put((String)k, v);
        if (config.containsKey("@" + (String)k)) {
            config.put("@" + (String)k, v);
        }
        ((ConfigurationService)this.getAgentService(ConfigurationService.class)).change("/", "maxLevelMap", config);
        return (((String)k).startsWith("@") ? "Group" : "User") + " : " + AgentLockService.User.levelsToString((Map)v, (boolean)true);
    }

    @Command(type=Command.CommandType.QUERY, category=Command.CommandCategory.USER, description="Adds new or existing user to the specified group.", level=2, autoAck=false)
    public String addUserToGroup(String user, String group) {
        user = user.strip();
        if (!this.maxLevelMap.containsKey("@" + (group = group.strip()))) {
            return "No such group.";
        }
        if (this.maxLevelMap.containsKey("@" + user)) {
            return "A user cannot have the same name as a group.";
        }
        TreeMap<String, Map<String, String>> config = new TreeMap<String, Map<String, String>>(this.maxLevelMap);
        LinkedHashMap v = config.get(user);
        if (v == null) {
            v = new LinkedHashMap<String, String>();
            v.put((String)group, (String)"");
        } else {
            String s = AgentLockService.User.levelsToString(v, (boolean)false);
            v = AgentLockService.User.levelsFromString((String)(s + "," + group + ":"));
        }
        config.put(user, v);
        ((ConfigurationService)this.getAgentService(ConfigurationService.class)).change("/", "maxLevelMap", config);
        return user + " : " + AgentLockService.User.levelsToString((Map)v, (boolean)true);
    }

    @Command(type=Command.CommandType.QUERY, category=Command.CommandCategory.USER, description="Removes a user from the specified group.", level=2, autoAck=false)
    public String removeUserFromGroup(String user, String group) {
        user = user.strip();
        if (!this.maxLevelMap.containsKey("@" + (group = group.strip()))) {
            return "No such group.";
        }
        Map<String, String> v = this.maxLevelMap.get(user);
        if (v == null) {
            return "No such user.";
        }
        if ((v = new LinkedHashMap<String, String>(v)).remove(group, "")) {
            String out;
            TreeMap<String, Map<String, String>> config = new TreeMap<String, Map<String, String>>(this.maxLevelMap);
            if (v.isEmpty()) {
                config.remove(user);
                out = "Removed user " + user + ".";
            } else {
                config.put(user, v);
                out = user + " : " + AgentLockService.User.levelsToString(v, (boolean)true);
            }
            ((ConfigurationService)this.getAgentService(ConfigurationService.class)).change("/", "maxLevelMap", config);
            return out;
        }
        return "User " + user + " is not in group " + group;
    }

    @Command(type=Command.CommandType.QUERY, category=Command.CommandCategory.USER, description="Lists groups of authorized users.", level=0, autoAck=false)
    public String groups() {
        StringBuilder sb = new StringBuilder();
        for (Map.Entry<String, Map<String, String>> e : this.maxLevelMap.entrySet()) {
            String group = e.getKey();
            if (!group.startsWith("@")) continue;
            sb.append(group.substring(1)).append(" : ").append(AgentLockService.User.levelsToString(e.getValue(), (boolean)true)).append(System.lineSeparator());
        }
        return sb.toString();
    }

    @Command(type=Command.CommandType.QUERY, category=Command.CommandCategory.USER, description="Lists users in the specified group.", level=0, autoAck=false)
    public String group(@Argument(name="group", description="Group name") String group) {
        Object key;
        Object object = key = (group = group.strip()).startsWith("@") ? group : "@" + group;
        if (this.maxLevelMap.get(key) == null) {
            throw new IllegalArgumentException("No such group: " + group);
        }
        TreeSet<String> users = new TreeSet<String>();
        block0: for (Map.Entry<String, Map<String, String>> e : this.maxLevelMap.entrySet()) {
            String user = e.getKey();
            if (user.startsWith("@") || this.maxLevelMap.containsKey("@" + user)) continue;
            LinkedList<Map.Entry<String, String>> entries = new LinkedList<Map.Entry<String, String>>();
            entries.addAll(e.getValue().entrySet());
            HashSet<String> groups = new HashSet<String>();
            ListIterator it = entries.listIterator(entries.size());
            while (it.hasPrevious()) {
                Map.Entry ee = (Map.Entry)it.previous();
                String g = (String)ee.getKey();
                if (!((String)ee.getValue()).isBlank() || groups.contains(g)) continue;
                if (g.equals(group)) {
                    users.add(user);
                    continue block0;
                }
                Map<String, String> settingsForGroup = this.maxLevelMap.get("@" + g);
                if (settingsForGroup == null) continue;
                settingsForGroup.entrySet().forEach(eee -> it.add(eee));
                groups.add(g);
            }
        }
        return String.join((CharSequence)", ", users) + ".";
    }

    @Command(type=Command.CommandType.QUERY, category=Command.CommandCategory.USER, description="Prints maximum level of an authorized user or group for the specified subsystem.", level=0, autoAck=false)
    public String maxLevel(@Argument(name="user", description="User ID or group name") String user, @Argument(name="subsystem", description="Subsystem name. If empty, print the entire map.") String subsystem) {
        if (user == null || user.isBlank()) {
            throw new IllegalArgumentException("User not specified");
        }
        if (subsystem == null || subsystem.isBlank()) {
            throw new IllegalArgumentException("Subsystem not specified");
        }
        return Integer.toString(this.agentLockService.getMaxLevel(user, subsystem));
    }

    static TreeMap<String, Map<String, String>> normalizeLevelsConfig(Map<String, Map<String, String>> config) {
        TreeMap<String, Map<String, String>> out = new TreeMap<String, Map<String, String>>();
        config.forEach((user, v) -> {
            user = user.strip();
            try {
                v = AgentLockService.User.levelsFromString((String)AgentLockService.User.levelsToString((Map)v, (boolean)false));
                out.put((String)user, (Map<String, String>)v);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        });
        return LockManager.duplicateGroups(out);
    }

    @Deprecated
    private static TreeMap<String, Map<String, String>> duplicateGroups(Map<String, Map<String, String>> config) {
        TreeMap<String, Map<String, String>> out = new TreeMap<String, Map<String, String>>();
        config.forEach((key, value) -> {
            out.put((String)key, (Map<String, String>)value);
            if (key.startsWith("@")) {
                out.put(key.substring(1), (Map<String, String>)value);
            }
        });
        return out;
    }
}

