/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.daq.ims.channel;

import java.io.IOException;
import org.lsst.ccs.daq.ims.channel.FilterWritableIntChannel;
import org.lsst.ccs.daq.ims.channel.WritableIntChannel;

public class Decompress18BitChannel
extends FilterWritableIntChannel {
    private int bitsRemaining = 0;
    private long dataRemaining = 0L;

    public Decompress18BitChannel(WritableIntChannel input) {
        super(input);
    }

    @Override
    public void write(int data) throws IOException {
        this.dataRemaining |= ((long)data & 0xFFFFFFFFL) << this.bitsRemaining;
        this.bitsRemaining += 32;
        while (this.bitsRemaining >= 18) {
            this.input.write((int)(this.dataRemaining & 0x3FFFFL));
            this.dataRemaining >>>= 18;
            this.bitsRemaining -= 18;
        }
    }

    @Override
    public void close() throws IOException {
        super.close();
        if (this.bitsRemaining != 0) {
            throw new IOException("Unused data remaining on close");
        }
    }
}

