/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.drivers.usb;

import org.lsst.ccs.drivers.commons.DriverException;
import org.lsst.ccs.drivers.usb.UsbDeviceDescriptor;
import org.lsst.ccs.drivers.usb.UsbLib;

public class ShowDevices {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws DriverException {
        long context = UsbLib.init();
        long[] devices = UsbLib.getDeviceList(context);
        System.out.println(devices.length + " devices found");
        for (long device : devices) {
            if (device == 0L) continue;
            UsbDeviceDescriptor desc = UsbLib.newDeviceDescriptor(device);
            long handle = 0L;
            String mfact = null;
            String product = null;
            String serial = null;
            try {
                handle = UsbLib.open(device);
                try {
                    mfact = UsbLib.getStringDescriptorAscii(handle, desc.iManufacturer());
                }
                catch (DriverException driverException) {
                    // empty catch block
                }
                try {
                    product = UsbLib.getStringDescriptorAscii(handle, desc.iProduct());
                }
                catch (DriverException driverException) {
                    // empty catch block
                }
                try {
                    serial = UsbLib.getStringDescriptorAscii(handle, desc.iSerialNumber());
                }
                catch (DriverException driverException) {
                    // empty catch block
                }
            }
            catch (DriverException driverException) {
            }
            finally {
                UsbLib.close(handle);
            }
            System.out.format("B=%03d, D=%03d, C=%02x, S=%02x, V=%04x (%s), P=%04x (%s), SN=%s\n", UsbLib.getBusNumber(device), UsbLib.getDeviceAddress(device), desc.bDeviceClass(), desc.bDeviceSubClass(), desc.idVendor(), mfact, desc.idProduct(), product, serial);
            UsbLib.unrefDevice(device);
        }
    }
}

