/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.ocsbridge.sim;

import java.time.Duration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutionException;

public interface FilterChangerInterface {
    public static final Map<String, FilterType> allFilterTypes = new HashMap<String, FilterType>(){
        {
            this.put("ef_43", FilterType.EF);
            this.put("ph_5", FilterType.PH);
            this.put("u_24", FilterType.U);
            this.put("g_6", FilterType.G);
            this.put("r_57", FilterType.R);
            this.put("i_39", FilterType.I);
            this.put("z_20", FilterType.Z);
            this.put("y_10", FilterType.Y);
            this.put("NONE", FilterType.NONE);
            this.put("u_05", FilterType.U);
            this.put("g_07", FilterType.G);
            this.put("g_01", FilterType.G);
            this.put("r_03", FilterType.R);
            this.put("i_06", FilterType.I);
            this.put("z_03", FilterType.Z);
            this.put("z_02", FilterType.Z);
            this.put("y_04", FilterType.Y);
            this.put("pinhole", FilterType.PH);
        }
    };

    default public String getFilterType(String filterName) {
        return allFilterTypes.get(filterName).getName();
    }

    public List<String> getAvailableFilters() throws ExecutionException;

    public List<String> getInstalledFilters() throws ExecutionException;

    public void start(String var1) throws ExecutionException;

    public String getCurrentFilter() throws ExecutionException;

    public void setFilter(String var1) throws ExecutionException;

    default public double getMaxAngleForFilterChange() throws ExecutionException {
        return 90.0;
    }

    default public double getMaxAngleForFastFilterChange() throws ExecutionException {
        return 90.0;
    }

    default public Duration getDurationForSlowFilterChange(String filterName) throws ExecutionException {
        return Duration.ofSeconds(240L);
    }

    default public Duration getDurationForFastFilterChange(String filterName) throws ExecutionException {
        return Duration.ofSeconds(240L);
    }

    public static enum FilterType {
        U,
        G,
        R,
        I,
        Z,
        Y,
        NONE,
        OTHER,
        PH("other:pinhole"),
        EF("other:emptyframe");

        private final String name;

        private FilterType(String name) {
            this.name = name;
        }

        private FilterType() {
            this.name = this.name().toLowerCase();
        }

        public String getName() {
            return this.name;
        }
    }
}

