/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.services;

import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.stream.Collectors;
import org.lsst.ccs.Agent;
import org.lsst.ccs.ServiceLifecycle;
import org.lsst.ccs.bootstrap.BootstrapResourceUtils;
import org.lsst.ccs.bus.data.AgentInfo;
import org.lsst.ccs.bus.data.AgentLock;
import org.lsst.ccs.bus.messages.CommandRequest;
import org.lsst.ccs.command.DictionaryCommand;
import org.lsst.ccs.command.annotations.Command;
import org.lsst.ccs.commons.annotations.LookupField;
import org.lsst.ccs.messaging.LockLevelService;
import org.lsst.ccs.services.AgentLockServiceDelegate;
import org.lsst.ccs.services.AgentLoginService;
import org.lsst.ccs.services.AgentService;
import org.lsst.ccs.services.AgentStateService;
import org.lsst.ccs.services.LocalAgentLockService;
import org.lsst.ccs.services.RemoteAgentLockService;
import org.lsst.ccs.services.UnauthorizedLevelException;
import org.lsst.ccs.services.UnauthorizedLockException;

public class AgentLockService
implements LockLevelService,
ServiceLifecycle,
AgentService {
    public static final String LOCK_MANAGER_SUBSYSTEM_NAME = "lockmanager";
    AgentLockServiceDelegate delegate;
    @LookupField(strategy=LookupField.Strategy.TOP)
    private Agent agent;
    @LookupField(strategy=LookupField.Strategy.TREE)
    private AgentStateService agentStateService;
    @LookupField(strategy=LookupField.Strategy.TREE)
    private AgentLoginService agentLoginService;

    Agent getAgent() {
        return this.agent;
    }

    public AgentStateService getAgentStateService() {
        return this.agentStateService;
    }

    public AgentLoginService getAgentLoginService() {
        return this.agentLoginService;
    }

    @Override
    public String getAgentServiceName() {
        return "lockService";
    }

    @Override
    public void preInit() {
        String p;
        String def = this.agent.getAgentInfo().getType() == AgentInfo.AgentType.LOCK_MANAGER ? "remote" : "local";
        this.delegate = switch (p = BootstrapResourceUtils.getBootstrapSystemProperties().getProperty("org.lsst.ccs.lockservice", def)) {
            case "remote" -> new RemoteAgentLockService(this);
            case "local" -> new LocalAgentLockService(this);
            default -> throw new RuntimeException("Invalid org.lsst.ccs.lockservice value " + p);
        };
        this.delegate.preInit();
    }

    @Override
    public void preStart() {
        this.delegate.preStart();
    }

    public void setLevelForAgent(String agentName, int level) throws UnauthorizedLevelException, UnauthorizedLockException {
        this.delegate.setLevelForAgent(agentName, level);
    }

    public int getLevelForAgent(String agentName) {
        return this.delegate.getLevelForAgent(agentName);
    }

    public AgentLock getLockForAgent(String agentName) {
        return this.delegate.getLockForAgent(agentName);
    }

    public AgentLock getExistingLockForAgent(String agentName) {
        return this.delegate.getExistingLockForAgent(agentName);
    }

    public void lockAgent(String agentName) throws UnauthorizedLockException {
        this.delegate.lockAgent(agentName);
    }

    public void unlockAgent(String agentName) throws UnauthorizedLockException {
        this.delegate.unlockAgent(agentName);
    }

    public void attachLock(String agentName) throws UnauthorizedLockException {
        this.delegate.attachLock(agentName);
    }

    public void detachLock(String agentName) throws UnauthorizedLockException {
        this.delegate.detachLock(agentName);
    }

    public Map<String, AgentLock> getLocks() {
        return this.delegate.getLocks();
    }

    public Map<String, AgentLock> getHeldLocks() {
        return this.delegate.getHeldLocks();
    }

    public String validateLock(DictionaryCommand command, CommandRequest request) {
        return this.delegate.validateLock(command, request);
    }

    public String getUserId() {
        return this.agentLoginService.getUserId();
    }

    public void addAgentLockUpdateListener(AgentLockUpdateListener slul) {
        this.delegate.addAgentLockUpdateListener(slul);
    }

    public void removeAgentLockUpdateListener(AgentLockUpdateListener l) {
        this.delegate.removeAgentLockUpdateListener(l);
    }

    public List<String> getLockableAgents() {
        return this.delegate.getLockableAgents();
    }

    public List<String> getAttachableAgents() {
        return this.delegate.getAttachableAgents();
    }

    public List<String> getDetachableAgents() {
        return this.delegate.getDetachableAgents();
    }

    public List<String> getLockedAgents() {
        return this.delegate.getLockedAgents();
    }

    public List<String> getAllLockedAgents() {
        return this.delegate.getAllLockedAgents();
    }

    public List<String> getLocallyLockedAgents() {
        return this.delegate.getLocallyLockedAgents();
    }

    public List<String> getAllWorkerAgents() {
        return this.delegate.getAllWorkerAgents();
    }

    public void destroyLock(String agentName, String userId) {
        this.delegate.destroyLock(agentName, userId);
    }

    public int getMaxLevel(String user, String agentName) {
        return this.delegate.getMaxLevel(user, agentName);
    }

    public static Map<String, Integer> getMaxLevelsUser(String user, Map<String, Map<String, String>> config) {
        return AgentLockService.getMaxLevelsUser(user, config, new HashSet<String>(8));
    }

    private static Map<String, Integer> getMaxLevelsUser(String user, Map<String, Map<String, String>> config, HashSet<String> groups) {
        Map<String, String> v;
        if (user.startsWith("@")) {
            groups.add(user);
        }
        if ((v = config.get(user)) == null) {
            return Collections.emptyMap();
        }
        TreeMap<String, Integer> out = new TreeMap<String, Integer>();
        TreeMap<String, Integer> fromGroups = new TreeMap<String, Integer>();
        v.forEach((key, value) -> {
            if (value.isEmpty()) {
                if (!groups.contains(key = "@" + (String)key)) {
                    AgentLockService.getMaxLevelsUser((String)key, config, groups).forEach((k, level) -> fromGroups.merge((String)k, (Integer)level, (level1, level2) -> Math.max(level1, level2)));
                }
            } else {
                try {
                    int level3 = Command.Level.parse((String)value, (int)-1);
                    if (level3 >= 0 && level3 <= 99) {
                        out.merge((String)key, level3, (level1, level2) -> Math.max(level1, level2));
                    }
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
        });
        TreeMap acceptFromGroups = new TreeMap();
        fromGroups.forEach((key, value) -> {
            if (!out.containsKey(key)) {
                if (key.contains("*")) {
                    acceptFromGroups.merge(key, value, (level1, level2) -> Math.max(level1, level2));
                } else {
                    boolean hasMatchingTemplate = false;
                    for (Map.Entry e : out.entrySet()) {
                        String template = (String)e.getKey();
                        if (!template.contains("*") || !key.matches(template.replace("*", ".*"))) continue;
                        hasMatchingTemplate = true;
                        break;
                    }
                    if (!hasMatchingTemplate) {
                        acceptFromGroups.merge(key, value, (level1, level2) -> Math.max(level1, level2));
                    }
                }
            }
        });
        out.putAll(acceptFromGroups);
        return out;
    }

    public static Map<String, Integer> getMaxLevelsSubsystem(String agentName, Map<String, Map<String, String>> config) {
        HashMap<String, Integer> out = new HashMap<String, Integer>();
        for (String user : config.keySet()) {
            Map<String, Integer> v = AgentLockService.getMaxLevelsUser(user, config, new HashSet<String>(8));
            int level = AgentLockService.getMaxLevel(agentName, v);
            if (level <= 0) continue;
            out.put(user, level);
        }
        return out;
    }

    static int getMaxLevel(String agentName, Map<String, Integer> maxLevelsUser) {
        Integer out = maxLevelsUser.get(agentName);
        if (out == null) {
            for (Map.Entry<String, Integer> e : maxLevelsUser.entrySet()) {
                if (!e.getKey().contains("*") || !agentName.matches(e.getKey().replace("*", ".*")) || out != null && out.compareTo(e.getValue()) >= 0) continue;
                out = e.getValue();
            }
        }
        return out == null ? 0 : out;
    }

    public static interface AgentLockUpdateListener {
        default public void onAgentHeldLockUpdate(String agentName, AgentLock lock) {
        }

        default public void onAgentLockUpdate(String agentName, String owner, AgentLock lock) {
        }

        default public void onGlobalLockUpdate(String agentName, String owner, AgentLock lock) {
        }

        default public void onAgentLevelChange(String agentName, int level) {
        }
    }

    private static class MaxLevelOrder
    implements Comparator<Map.Entry<String, String>> {
        private MaxLevelOrder() {
        }

        @Override
        public int compare(Map.Entry<String, String> e1, Map.Entry<String, String> e2) {
            if (e1.getValue().isBlank()) {
                if (e2.getValue().isBlank()) {
                    return e1.getKey().strip().compareTo(e2.getKey().strip());
                }
                return -1;
            }
            if (e2.getValue().isBlank()) {
                return 1;
            }
            return e1.getKey().strip().compareTo(e2.getKey().strip());
        }

        static List<Map.Entry<String, String>> sortedList(Map<String, String> m) {
            if (m == null || m.isEmpty()) {
                return Collections.emptyList();
            }
            TreeSet<Map.Entry<String, String>> ee = new TreeSet<Map.Entry<String, String>>(new MaxLevelOrder());
            for (Map.Entry<String, String> e : m.entrySet()) {
                if (e.getKey().isBlank()) continue;
                ee.add(e);
            }
            return new ArrayList<Map.Entry<String, String>>(ee);
        }
    }

    public static interface User {
        public static LinkedHashMap<String, String> levelsFromString(String settings) {
            settings = settings.replaceAll("[\\[\\]]", "");
            String[] ss = settings.split(",");
            TreeSet<Map.Entry<String, String>> ee = new TreeSet<Map.Entry<String, String>>(new MaxLevelOrder());
            Command.Level levelParser = new Command.Level().with((Enum)Command.Level.OnTooHigh.ON_TOO_HIGH_MAX).withDefault(-1);
            block5: for (String s : ss) {
                String[] tt = s.strip().split(":");
                switch (tt.length) {
                    case 0: {
                        continue block5;
                    }
                    case 1: {
                        AbstractMap.SimpleImmutableEntry<String, String> e2 = new AbstractMap.SimpleImmutableEntry<String, String>(tt[0].strip(), "");
                        ee.add(e2);
                        continue block5;
                    }
                    case 2: {
                        String sLevel = tt[1].strip();
                        if (levelParser.getValue(sLevel) == -1) {
                            throw new IllegalArgumentException("Illegal level value: " + sLevel);
                        }
                        ee.add(new AbstractMap.SimpleImmutableEntry<String, String>(tt[0].strip(), sLevel));
                        continue block5;
                    }
                    default: {
                        throw new IllegalArgumentException("Illegal entry: " + s);
                    }
                }
            }
            LinkedHashMap<String, String> out = new LinkedHashMap<String, String>(ee.size() * 2);
            ee.forEach(e -> {
                String key = (String)e.getKey();
                if (!key.isBlank()) {
                    out.put(key, (String)e.getValue());
                }
            });
            return out;
        }

        public static String levelsToString(Map<String, String> m, boolean includeBraces) {
            Object out = String.join((CharSequence)", ", MaxLevelOrder.sortedList(m).stream().map(e -> (String)e.getKey() + ":" + (String)e.getValue()).collect(Collectors.toList()));
            if (includeBraces) {
                out = "[" + (String)out + "]";
            }
            return out;
        }
    }
}

