/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.daq.guider;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import org.lsst.ccs.daq.guider.ROICommon;

public class ROICommonExtended
extends ROICommon {
    private final ROICommonExtendedParameters extended;

    public ROICommonExtended(ROICommon common) {
        super(common);
        this.extended = ROICommonExtendedParameters.defaultValue();
    }

    public ROICommonExtended(ROICommon common, String extended) {
        super(common);
        this.extended = ROICommonExtendedParameters.parse(extended);
    }

    public ROICommonExtended(ROICommon common, ROICommonExtendedParameters extended) {
        super(common);
        this.extended = extended;
    }

    public ROICommonExtended(ROICommon common, int underCols, int overCols, int overRows, int flushCount) {
        super(common);
        this.extended = new ROICommonExtendedParameters(underCols, overCols, overRows, flushCount);
    }

    public ROICommonExtended(int rows, int cols, int integrationTimeMillis, int underCols, int overCols, int overRows, int flushCount) {
        super(rows, cols, integrationTimeMillis);
        this.extended = new ROICommonExtendedParameters(underCols, overCols, overRows, flushCount);
    }

    public int getUnderCols() {
        return this.extended.getUnderCols();
    }

    public int getOverCols() {
        return this.extended.getOverCols();
    }

    public int getOverRows() {
        return this.extended.getOverRows();
    }

    public int getFlushCount() {
        return this.extended.getFlushCount();
    }

    @Override
    public String toString() {
        return "ROICommonExtended [rows=" + this.getRows() + ", cols=" + this.getCols() + ", integrationTimeMillis=" + this.getIntegrationTimeMillis() + ", underCols=" + this.extended.getUnderCols() + ", overCols=" + this.extended.getOverCols() + ", overRows=" + this.extended.getOverRows() + ", flushCount=" + this.extended.getFlushCount() + "]";
    }

    public static class ROICommonExtendedParameters {
        private final int underCols;
        private final int overCols;
        private final int overRows;
        private final int flushCount;
        public static final String DEFAULT_ROI_COMMON_EXTENDED_STRING = "{\"underCols\":0,\"overCols\":0,\"overRows\":0,\"flushCount\":2}";
        private static final ROICommonExtendedParameters DEFAULT_ROI_COMMON_EXTENDED_PARAMETERS = ROICommonExtendedParameters.parse("{\"underCols\":0,\"overCols\":0,\"overRows\":0,\"flushCount\":2}");

        @JsonCreator(mode=JsonCreator.Mode.PROPERTIES)
        public ROICommonExtendedParameters(@JsonProperty(value="underCols") int underCols, @JsonProperty(value="overCols") int overCols, @JsonProperty(value="overRows") int overRows, @JsonProperty(value="flushCount") int flushCount) {
            this.underCols = underCols;
            this.overCols = overCols;
            this.overRows = overRows;
            this.flushCount = flushCount;
        }

        public static ROICommonExtendedParameters defaultValue() {
            return DEFAULT_ROI_COMMON_EXTENDED_PARAMETERS;
        }

        public int getUnderCols() {
            return this.underCols;
        }

        public int getOverCols() {
            return this.overCols;
        }

        public int getOverRows() {
            return this.overRows;
        }

        public int getFlushCount() {
            return this.flushCount;
        }

        public static ROICommonExtendedParameters parse(String roiExtendedParameters) throws IllegalArgumentException {
            try {
                ObjectMapper om = new ObjectMapper();
                return (ROICommonExtendedParameters)om.readValue(roiExtendedParameters, ROICommonExtendedParameters.class);
            }
            catch (JsonProcessingException x) {
                throw new IllegalArgumentException("Invalid ROICommonExtendedParameters " + roiExtendedParameters, x);
            }
        }

        public String toString() {
            try {
                ObjectMapper om = new ObjectMapper();
                return om.writeValueAsString((Object)this);
            }
            catch (JsonProcessingException ex) {
                throw new RuntimeException("Can't happen!!!", ex);
            }
        }
    }
}

