/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.daq.guider;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;

public class ClearParameters {
    private final int delay;
    private final int preRows;
    private final int flushCount;
    private final int readRows;
    private final int postRows;
    private final int overRows;
    public static final String DEFAULT_CLEAR_PARAMETERS_STRING = "{\"delay\":50,\"preRows\":100,\"flushCount\":2,\"readRows\":0,\"postRows\":0,\"overRows\":0}";
    private static final ClearParameters DEFAULT_CLEAR_PARAMETERS = ClearParameters.parse("{\"delay\":50,\"preRows\":100,\"flushCount\":2,\"readRows\":0,\"postRows\":0,\"overRows\":0}");

    @JsonCreator(mode=JsonCreator.Mode.PROPERTIES)
    public ClearParameters(@JsonProperty(value="delay") int delay, @JsonProperty(value="preRows") int preRows, @JsonProperty(value="flushCount") int flushCount, @JsonProperty(value="readRows") int readRows, @JsonProperty(value="postRows") int postRows, @JsonProperty(value="overRows") int overRows) {
        this.delay = delay;
        this.preRows = preRows;
        this.flushCount = flushCount;
        this.readRows = readRows;
        this.postRows = postRows;
        this.overRows = overRows;
    }

    public int getDelay() {
        return this.delay;
    }

    public int getPreRows() {
        return this.preRows;
    }

    public int getFlushCount() {
        return this.flushCount;
    }

    public int getReadRows() {
        return this.readRows;
    }

    public int getPostRows() {
        return this.postRows;
    }

    public int getOverRows() {
        return this.overRows;
    }

    public static ClearParameters parse(String clearSpec) throws IllegalArgumentException {
        try {
            ObjectMapper om = new ObjectMapper();
            return (ClearParameters)om.readValue(clearSpec, ClearParameters.class);
        }
        catch (JsonProcessingException x) {
            throw new IllegalArgumentException("Invalid ClearParameters " + clearSpec, x);
        }
    }

    public String toString() {
        try {
            ObjectMapper om = new ObjectMapper();
            return om.writeValueAsString((Object)this);
        }
        catch (JsonProcessingException ex) {
            throw new RuntimeException("Can't happen!!!", ex);
        }
    }

    public static ClearParameters defaultValue() {
        return DEFAULT_CLEAR_PARAMETERS;
    }
}

