/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.drivers.twistorr;

import java.time.Instant;
import java.util.Date;
import java.util.logging.Logger;
import org.lsst.ccs.command.Options;
import org.lsst.ccs.command.SupportedOption;
import org.lsst.ccs.command.annotations.Argument;
import org.lsst.ccs.command.annotations.Command;
import org.lsst.ccs.command.annotations.Option;
import org.lsst.ccs.drivers.ascii.TestAscii;
import org.lsst.ccs.drivers.commons.DriverException;
import org.lsst.ccs.drivers.twistorr.TwisTorr;

public class TestTT
extends TestAscii {
    private final TwisTorr ttdev;
    private double pulseTime = 0.0;
    private Thread openMoment;
    private Boolean ventValveOpen = false;
    private static final Logger LOG = Logger.getLogger(TestTT.class.getName());
    protected volatile TwisTorr.CntlrModels model;
    private final SupportedOption isoOption = SupportedOption.getSupportedOption((String)"iso");
    private final SupportedOption forceOption = SupportedOption.getSupportedOption((String)"force");

    public TestTT() {
        super(new TwisTorr());
        this.ttdev = (TwisTorr)this.dev;
    }

    @Command(name="timestamp", description="Prints current time, optionally in iso-8601")
    @Option(name="iso", description="format the date as iso-8601=s")
    public String timestamp(Options options) {
        boolean hasIso = options.hasOption(this.isoOption);
        Date now = new Date();
        if (hasIso) {
            return Instant.now().toString();
        }
        return new Date().toString();
    }

    @Command(name="setModel", description="Set Controller Model")
    public String setModel(@Argument(name="FS74OB|FS84OB|FS304OB|FS305OB", description="which model") String model_value) throws DriverException {
        if (model_value.matches("FS74OB")) {
            this.setModel(TwisTorr.CntlrModels.FS74OB);
        } else if (model_value.matches("FS84OB")) {
            this.setModel(TwisTorr.CntlrModels.FS84OB);
        } else if (model_value.matches("FS304OB")) {
            this.setModel(TwisTorr.CntlrModels.FS304OB);
        } else if (model_value.matches("FS305OB")) {
            this.setModel(TwisTorr.CntlrModels.FS305OB);
        } else {
            return "Unknown Model";
        }
        return this.model.toString();
    }

    @Command(name="open", description="Open connection to device")
    public void open(@Argument(name="ident", description="Identification") String ident) throws DriverException {
        this.ttdev.open(ident);
    }

    @Command(name="readAll", description="Read all supported controller settings and data")
    @Option(name="force", description="Read all known registers, regardless of controller model")
    public String readAll(Options options) throws InterruptedException {
        long startTime = System.currentTimeMillis();
        boolean forceRead = options.hasOption(this.forceOption);
        String table = "Read all turbo-pump settings and data\n" + Instant.now().toString() + "\n";
        table = table + String.format("Controller Model Set to: %s", this.model.toString());
        TwisTorr.CmndBool[] cmndB = TwisTorr.CmndBool.values();
        int nB = cmndB.length;
        for (int i = 0; i < nB; ++i) {
            if (!forceRead && (this.model.getModelMask() & cmndB[i].getModels()) == 0) continue;
            table = table + String.format("\n%3s    %-22s", new Object[]{cmndB[i].getWindow(), cmndB[i]});
            try {
                boolean respB = this.ttdev.readBool(cmndB[i]);
                table = table + Boolean.toString(respB);
                continue;
            }
            catch (DriverException ex) {
                table = table + ex.getMessage();
            }
        }
        table = table + "\n";
        TwisTorr.CmndNumeric[] cmndN = TwisTorr.CmndNumeric.values();
        int nN = cmndN.length;
        for (int i = 0; i < nN; ++i) {
            if (!forceRead && (this.model.getModelMask() & cmndN[i].getModels()) == 0) continue;
            table = table + String.format("\n%3s    %-22s", new Object[]{cmndN[i].getWindow(), cmndN[i]});
            try {
                int respN = this.ttdev.readNumeric(cmndN[i]);
                table = table + Integer.toString(respN);
                continue;
            }
            catch (DriverException ex) {
                table = table + ex.getMessage();
            }
        }
        table = table + "\n";
        TwisTorr.CmndAlpha[] cmndA = TwisTorr.CmndAlpha.values();
        int nA = cmndA.length;
        for (int i = 0; i < nA; ++i) {
            if (!forceRead && (this.model.getModelMask() & cmndA[i].getModels()) == 0) continue;
            table = table + String.format("\n%3s    %-22s", new Object[]{cmndA[i].getWindow(), cmndA[i]});
            try {
                String respA = this.ttdev.readAlpha(cmndA[i]);
                table = table + respA;
                continue;
            }
            catch (DriverException ex) {
                table = table + ex.getMessage();
            }
        }
        long dt = System.currentTimeMillis() - startTime;
        table = table + String.format("\nreadAll() time: %d\n", dt);
        return table;
    }

    @Command(name="readBool", description="Read specified boolean quantity")
    public String readBool(@Argument(name="enum quantity", description="name of boolean quantity") TwisTorr.CmndBool quantity) throws DriverException {
        boolean value = this.ttdev.readBool(quantity);
        return Boolean.toString(value);
    }

    @Command(name="readNumeric", description="Read specified numeric quantity")
    public String readNumeric(@Argument(name="enum quantity", description="name of numeric quantity") TwisTorr.CmndNumeric quantity) throws DriverException {
        int value = this.ttdev.readNumeric(quantity);
        return Integer.toString(value);
    }

    @Command(name="readTemp", description="Read pump temperature in degrees C")
    public String readTemp() throws DriverException {
        int temp = this.ttdev.readNumeric(TwisTorr.CmndNumeric.PUMP_TEMP);
        return Integer.toString(temp);
    }

    @Command(name="readTempRepeat", description="Read pump T multiple times")
    public String readTempRepeat(@Argument(name="repeats", description="number of times") int nRepeat) throws DriverException {
        Object output = "";
        for (int i = 0; i < nRepeat; ++i) {
            output = (String)output + " " + this.readTemp();
        }
        return output;
    }

    @Command(name="readActiveStop", description="Read active-stop setting")
    public String readActiveStop() throws DriverException {
        boolean as = this.ttdev.readBool(TwisTorr.CmndBool.ACTIVE_STOP_MODE);
        return Boolean.toString(as);
    }

    @Command(name="readStatus", description="Get pump status, including operating modes and failure")
    public TwisTorr.PumpStatus readStatus() throws DriverException {
        int status = this.ttdev.readNumeric(TwisTorr.CmndNumeric.STATUS);
        return TwisTorr.PumpStatus.decodeStatus(status);
    }

    @Command(name="readErrorCode", description="Read pump error code")
    public String readErrorCode() throws DriverException {
        int errcode = this.ttdev.readNumeric(TwisTorr.CmndNumeric.ERRCODE);
        return Integer.toString(errcode, 16) + TwisTorr.decodeError(errcode);
    }

    @Command(name="testErrorCode", description="Test decoding of error code")
    public String testErrorCode(@Argument(name="testcode", description="code to test, 0 to 0xff") int testcode) {
        return Integer.toString(testcode, 16) + TwisTorr.decodeError(testcode);
    }

    @Command(name="startPump", description="Start the pump")
    public void startPump() throws DriverException {
        this.ttdev.writeBool(TwisTorr.CmndBool.START_STOP, true);
    }

    @Command(name="stopPump", description="Stop the pump")
    public void stopPump() throws DriverException {
        this.ttdev.writeBool(TwisTorr.CmndBool.START_STOP, false);
    }

    @Command(name="setLowSpeedMode", description="Low-speed mode on/off")
    public void setLowSpeedMode(@Argument(name="<true|false>", description="Low-speed mode true or false") boolean value) throws DriverException {
        this.ttdev.writeBool(TwisTorr.CmndBool.LOW_SPEED_MODE, value);
    }

    @Command(name="setSoftStart", description="Soft-start mode on/off")
    public void setSoftStart(@Argument(name="<true|false>", description="Soft-start mode true or false") boolean value) throws DriverException {
        this.ttdev.writeBool(TwisTorr.CmndBool.SOFT_START_MODE, value);
    }

    @Command(name="setActiveStop", description="Active-stop mode on/off")
    public void setActiveStop(@Argument(name="<true|false>", description="Active-stop mode true or false") boolean value) throws DriverException {
        this.ttdev.writeBool(TwisTorr.CmndBool.ACTIVE_STOP_MODE, value);
    }

    @Command(name="setRemote", description="Select remote vs. serial mode")
    public void setRemote(@Argument(name="<true|false>", description="Remote I/O mode (true) vs. Serial mode (false)") boolean value) throws DriverException {
        this.ttdev.writeBool(TwisTorr.CmndBool.REMOTE, value);
    }

    @Command(name="setWaterCooling", description="Water cooling on/off")
    public void setWaterCooling(@Argument(name="<true|false>", description="Water cooling true or false") boolean value) throws DriverException {
        this.ttdev.writeBool(TwisTorr.CmndBool.WATER_COOLING, value);
    }

    @Command(name="setInterlockType", description="Interlock signal continuos vs. impulse")
    public void setInterlockType(@Argument(name="<true|false>", description="Continuous (true, default) or impulse (false)") boolean value) throws DriverException {
        this.ttdev.writeBool(TwisTorr.CmndBool.INTERLOCK_TYPE, value);
    }

    @Command(name="enableSpeedRead", description="Enable/disable pump-speed read after Stop")
    public void enableSpeedRead(@Argument(name="<true|false>", description="Enable (true) or disable(false, default)") boolean value) throws DriverException {
        this.ttdev.writeBool(TwisTorr.CmndBool.SPEED_READ_ACTIVATE, value);
    }

    @Command(name="setGasType", description="Select gas load type")
    public void setGasType(@Argument(name="<int>", description="false for N2, true for Ar") boolean value) throws DriverException {
        this.ttdev.writeBool(TwisTorr.CmndBool.GAS_TYPE_ARGON, value);
    }

    @Command(name="setGas", description="Select gas")
    public void setGas(@Argument(name="<int>", description="0 for Ar, 1 for N2, 2 for He") int value) throws DriverException {
        this.ttdev.writeNumeric(TwisTorr.CmndNumeric.GAS_TYPE, value);
    }

    @Command(name="setBaudRate", description="Select baud rate")
    public void setBaudRate(@Argument(name="<int>", description="0 to 4 for 600, 1200, 2400, 4800, 9600 (default)") int value) throws DriverException {
        this.ttdev.writeNumeric(TwisTorr.CmndNumeric.BAUD_RATE, value);
    }

    @Command(name="setRotFreq", description="Set rotational frequency")
    public void setRotFreq(@Argument(name="<int>", description="1100 to 1350 (default) Hz") int value) throws DriverException {
        this.ttdev.writeNumeric(TwisTorr.CmndNumeric.ROTFREQ_SET, value);
    }

    @Command(name="setLowFreq", description="Set low-speed rotational freq.")
    public void setLowFreq(@Argument(name="<int>", description="1100 Hz (default) to normal freq.") int value) throws DriverException {
        this.ttdev.writeNumeric(TwisTorr.CmndNumeric.ROTFREQ_LOW, value);
    }

    @Command(name="setVentOperation", description="Vent valve operation")
    public void setVentOperation(@Argument(name="<true|false>", description="On-command (true) vs. Automatic (false, default)") boolean value) throws DriverException {
        this.ttdev.writeBool(TwisTorr.CmndBool.VENTVALVE_BY_CMND, value);
    }

    @Command(name="setVentValveType", description="Vent valve NO vs NC")
    public void setVentValveType(@Argument(name="<true|false>", description="Normally-open (true) vs. Normally-closed (false)") boolean value) throws DriverException {
        this.ttdev.writeBool(TwisTorr.CmndBool.VENTVALVE_TYPE, value);
    }

    @Command(name="setVentValveTrue", description="Set vent valve true")
    public void setVentValveTrue() throws DriverException {
        this.ttdev.writeBool(TwisTorr.CmndBool.VENTVALVE_OPEN, true);
    }

    @Command(name="setVentValveFalse", description="Set vent valve false")
    public void setVentValveFalse() throws DriverException {
        this.ttdev.writeBool(TwisTorr.CmndBool.VENTVALVE_OPEN, false);
    }

    @Command(name="setVentDelay", description="Vent valve-open delay")
    public void setVentDelay(@Argument(name="<int>", description="Opening delay after stop in auto mode, unit 0.2 s") int value) throws DriverException {
        this.ttdev.writeNumeric(TwisTorr.CmndNumeric.VENT_DELAY, value);
    }

    @Command(name="setVentPulseTime", description="set open time for vent pulse")
    public void setVentPulseTime(@Argument(name="<double>", description="Open-time in pulse mode, units are seconds (double)") double value) throws DriverException {
        this.pulseTime = value;
    }

    @Command(name="setVentOpenTime", description="Vent valve-open time")
    public void setVentOpenTime(@Argument(name="<int>", description="Open-time in automatic mode, unit 0.2 s, 0 for infinity") int value) throws DriverException {
        this.ttdev.writeNumeric(TwisTorr.CmndNumeric.VENT_OPENTIME, value);
    }

    @Command(name="setExtFanConfig", description="Fan by-command or always on")
    public void setExtFanConfig(@Argument(name="<1/0>", description="By command (1) vs. Always on (0)") int value) throws DriverException {
        this.ttdev.writeNumeric(TwisTorr.CmndNumeric.EXT_FAN_CONFIG, value);
    }

    @Command(name="setExtFanOnOff", description="Fan by-command or always on")
    public void setExtFanOnOff(@Argument(name="<true|false>", description="If by-command. On (true) vs. Off (false)") boolean value) throws DriverException {
        this.ttdev.writeBool(TwisTorr.CmndBool.EXT_FAN_SETTING, value);
    }

    @Command(name="setpointThresh", description="programmable setpoint threshold")
    public void setpointThresh(@Argument(name="<int>", description="setpoint threshold in Hz, W or s") int value) throws DriverException {
        this.ttdev.writeNumeric(TwisTorr.CmndNumeric.SETPOINT_THRESH, value);
    }

    @Command(name="setpointActive", description="setpoint active level")
    public void setpointActive(@Argument(name="<true|false>", description="Active on low-level (true, default) vs. high-level (false)") boolean value) throws DriverException {
        this.ttdev.writeBool(TwisTorr.CmndBool.SETPOINT_ACTIVE, value);
    }

    @Command(name="setpointDelay", description="setpoint-check delay")
    public void setpointDelay(@Argument(name="<int>", description="Seconds after pump start (default 0)") int value) throws DriverException {
        this.ttdev.writeNumeric(TwisTorr.CmndNumeric.SETPOINT_DELAY, value);
    }

    @Command(name="setpointHyst", description="setpoint hysteresis")
    public void setpointHyst(@Argument(name="<int>", description="Hysteresis in % of value (default = 2)") int value) throws DriverException {
        this.ttdev.writeNumeric(TwisTorr.CmndNumeric.SETPOINT_HYST, value);
    }

    @Command(name="selectAnalog", description="select analog output")
    public void selectAnalog(@Argument(name="<int>", description="Select analog output (0 to 3, default = 0, frequency)") int value) throws DriverException {
        this.ttdev.writeNumeric(TwisTorr.CmndNumeric.ANALOG_OUTPUT, value);
    }

    @Command(name="resetPumpHoursCyclesIRREVERSIBLE", description="resets pump total hours and count of cycles")
    public void resetPumpHoursCyclesIRREVERSIBLE(@Argument(name="<true|false>", description="true to confirm command") boolean confirm) throws DriverException {
        if (confirm) {
            this.ttdev.writeBool(TwisTorr.CmndBool.RESET_CYCLE_TIME, Boolean.TRUE);
        }
    }

    private String getOnOff(boolean on) {
        return on ? "on" : "off";
    }

    @Command(type=Command.CommandType.ACTION, name="timedOpenVentValve", description="open vent valve (certain models only)")
    public void timedOpenVentValve() throws DriverException {
        this.openMoment = new Thread("openMoment"){

            @Override
            public void run() {
                try {
                    TestTT.this.openVentValve();
                }
                catch (DriverException ex) {
                    try {
                        TestTT.this.closeVentValve();
                    }
                    catch (DriverException driverException) {
                        // empty catch block
                    }
                    throw new RuntimeException("Driver exception occurred when trying to open the turbo vent valve", ex);
                }
                try {
                    Thread.sleep((long)(TestTT.this.pulseTime * 1000.0));
                }
                catch (InterruptedException ex) {
                    try {
                        TestTT.this.closeVentValve();
                    }
                    catch (DriverException driverException) {
                        // empty catch block
                    }
                    throw new RuntimeException("Unexpected interrupt while waiting for turbo vent valve openning period to end", ex);
                }
                try {
                    TestTT.this.closeVentValve();
                }
                catch (DriverException ex) {
                    throw new RuntimeException("Driver exception occurred when trying to close the turbo vent valve", ex);
                }
            }
        };
        this.openMoment.setDaemon(true);
        this.openMoment.start();
    }

    public void setModel(TwisTorr.CntlrModels model) throws DriverException {
        this.model = model;
    }

    @Command(type=Command.CommandType.ACTION, name="openVentValve", description="open vent valve (certain models only)")
    public void openVentValve() throws DriverException {
        if ((this.model.getModelMask() & TwisTorr.CmndBool.VENTVALVE_OPEN.getModels()) != 0) {
            boolean type = this.ttdev.readBool(TwisTorr.CmndBool.VENTVALVE_TYPE);
            this.ttdev.writeBool(TwisTorr.CmndBool.VENTVALVE_OPEN, type);
            this.ventValveOpen = true;
        }
    }

    @Command(type=Command.CommandType.ACTION, name="closeVentValve", description="close vent valve (certain models only)")
    public void closeVentValve() throws DriverException {
        if ((this.model.getModelMask() & TwisTorr.CmndBool.VENTVALVE_OPEN.getModels()) != 0) {
            boolean type = this.ttdev.readBool(TwisTorr.CmndBool.VENTVALVE_TYPE);
            this.ttdev.writeBool(TwisTorr.CmndBool.VENTVALVE_OPEN, !type);
            this.ventValveOpen = false;
        }
    }
}

