/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.visualization.server;

import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.SocketChannel;
import java.time.Duration;
import java.util.List;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.lsst.ccs.visualization.client.DataMessage;
import org.lsst.ccs.visualization.client.EndMessage;
import org.lsst.ccs.visualization.client.Message;
import org.lsst.ccs.visualization.client.StartMessage;
import org.lsst.ccs.visualization.server.BlockingMap;
import org.lsst.ccs.visualization.server.FitsFileHandler;
import org.lsst.ccs.visualization.server.FitsFileHandlerImpl;
import org.lsst.ccs.visualization.server.ImageListener;

class FitsFileManager
extends TimerTask {
    private final File dir;
    private final BlockingMap<String, ManagedFile> handlers = new BlockingMap();
    private static final Logger logger = Logger.getLogger(FitsFileManager.class.getName());
    private static final Timer timer = new Timer("Idle Timeout", true);
    private final List<ImageListener> imageListeners = new CopyOnWriteArrayList<ImageListener>();
    private Duration startTimeout = Duration.ofSeconds(60L);
    private Duration activeTimeout = Duration.ofSeconds(10L);
    private Duration startWait = Duration.ofSeconds(1L);

    FitsFileManager(File dir) {
        this.dir = dir;
        timer.scheduleAtFixedRate((TimerTask)this, 1000L, 1000L);
    }

    void handleMessage(Message msg, SocketChannel socket) throws IOException {
        ManagedFile handler = this.getHandlerForMessage(msg);
        if (handler == null) {
            this.discard(msg, socket);
        } else {
            int nClients;
            handler.fitsFileHandler.handle(msg, socket);
            handler.lastActive.set(System.currentTimeMillis());
            if (msg instanceof EndMessage && (nClients = handler.nClients.decrementAndGet()) == 0) {
                this.handlers.remove(msg.getImageName());
                handler.fitsFileHandler.close();
                this.notifyFileAvailable(msg.getImageName(), handler.getFile(), handler.getMillis());
            }
        }
    }

    private ManagedFile getHandlerForMessage(Message msg) throws IOException {
        String imageName = msg.getImageName();
        if (msg instanceof StartMessage) {
            StartMessage start = (StartMessage)msg;
            FitsFileHandler handler = this.createHandler(this.dir, start);
            ManagedFile file = new ManagedFile(handler, start.getnClients(), start.getImageName());
            this.handlers.put(imageName, file);
            return file;
        }
        try {
            return this.handlers.get(imageName, this.startWait.toMillis(), TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException ex) {
            return null;
        }
    }

    private void checkIdleFiles() {
        long now = System.currentTimeMillis();
        for (Map.Entry<String, ManagedFile> entry : this.handlers.entrySet()) {
            ManagedFile value = entry.getValue();
            if (!value.isIdle(now)) continue;
            logger.log(Level.WARNING, "Closing idle file {0}", value.imageName);
            this.handlers.remove(entry.getKey());
            try {
                entry.getValue().fitsFileHandler.close();
            }
            catch (IOException ex) {
                logger.log(Level.WARNING, "Error while closing idle file", ex);
            }
        }
    }

    FitsFileHandler createHandler(File dir, StartMessage msg) throws IOException {
        return new FitsFileHandlerImpl(dir, msg);
    }

    private void discard(Message msg, SocketChannel socket) throws IOException {
        logger.log(Level.WARNING, "Discarding message because no handler found {0}", msg);
        if (msg instanceof DataMessage) {
            FitsFileManager.discardData((DataMessage)msg, socket);
        }
    }

    static void discardData(DataMessage msg, SocketChannel socket) throws IOException {
        ByteBuffer dataBuffer = ByteBuffer.allocateDirect(65536);
        for (int size = msg.getDataLength(); size > 0; size -= socket.read(dataBuffer)) {
            dataBuffer.clear();
            if (size >= dataBuffer.capacity()) continue;
            dataBuffer.limit(size);
        }
    }

    @Override
    public void run() {
        this.checkIdleFiles();
    }

    @Override
    public boolean cancel() {
        for (Map.Entry<String, ManagedFile> entry : this.handlers.entrySet()) {
            try {
                entry.getValue().fitsFileHandler.close();
            }
            catch (IOException ex) {
                logger.log(Level.WARNING, "Error while closing file during cancel", ex);
            }
        }
        return super.cancel();
    }

    Duration getStartTimeout() {
        return this.startTimeout;
    }

    void setStartTimeout(Duration startTimeout) {
        this.startTimeout = startTimeout;
    }

    Duration getActiveTimeout() {
        return this.activeTimeout;
    }

    void setActiveTimeout(Duration activeTimeout) {
        this.activeTimeout = activeTimeout;
    }

    Duration getStartWait() {
        return this.startWait;
    }

    void setStartWait(Duration startWait) {
        this.startWait = startWait;
    }

    void notifyFileAvailable(String imageName, File file, long millis) {
        for (ImageListener l : this.imageListeners) {
            l.imageReceived(imageName, millis, file);
        }
    }

    void addImageListener(ImageListener l) {
        this.imageListeners.add(l);
    }

    void removeImageListener(ImageListener l) {
        this.imageListeners.add(l);
    }

    private class ManagedFile {
        private final String imageName;
        private final FitsFileHandler fitsFileHandler;
        private final AtomicInteger nClients;
        private final long startTime = System.currentTimeMillis();
        private final AtomicLong lastActive = new AtomicLong(this.startTime);

        public ManagedFile(FitsFileHandler fitsFileHandler, int nClients, String imageName) {
            this.fitsFileHandler = fitsFileHandler;
            this.nClients = new AtomicInteger(nClients);
            this.imageName = imageName;
        }

        private boolean isIdle(long now) {
            return now - this.lastActive.get() > FitsFileManager.this.activeTimeout.toMillis() && now - this.startTime > FitsFileManager.this.startTimeout.toMillis();
        }

        File getFile() {
            return this.fitsFileHandler.getFile();
        }

        long getMillis() {
            return this.startTime;
        }
    }
}

