/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.power;

import java.util.logging.Level;
import java.util.logging.Logger;
import org.lsst.ccs.drivers.commons.DriverException;
import org.lsst.ccs.subsystem.common.ErrorUtils;
import org.lsst.ccs.subsystem.common.devices.dataforth.Maq20Device;
import org.lsst.ccs.subsystem.common.devices.dataforth.Maq20DiscControl;
import org.lsst.ccs.subsystem.power.SwitchControl;

public class QbMaq20Device
extends Maq20Device
implements SwitchControl {
    private Maq20DiscControl utHcuPower;
    private Maq20DiscControl mechHcuPower;
    private Maq20DiscControl fesProt;
    private static final Logger LOG = Logger.getLogger(QbMaq20Device.class.getName());
    private final SwitchData[] switchData = new SwitchData[5];

    public void initDevice() {
        super.initDevice();
        if (this.utHcuPower == null) {
            ErrorUtils.reportConfigError((Logger)LOG, (String)this.path, (String)"utHcuPower", (String)"not defined");
        }
        this.switchData[0] = new SwitchData(this.utHcuPower, 3, true);
        this.switchData[1] = new SwitchData(this.utHcuPower, 4, true);
        if (this.mechHcuPower == null) {
            ErrorUtils.reportConfigError((Logger)LOG, (String)this.path, (String)"mechHcuPower", (String)"not defined");
        }
        this.switchData[2] = new SwitchData(this.mechHcuPower, 3, true);
        this.switchData[3] = new SwitchData(this.mechHcuPower, 4, true);
        if (this.fesProt == null) {
            ErrorUtils.reportConfigError((Logger)LOG, (String)this.path, (String)"fesProt", (String)"not defined");
        }
        this.switchData[4] = new SwitchData(this.fesProt, 4, false);
    }

    @Override
    public int getSwitchDevice() {
        return 6;
    }

    @Override
    public void switchOn(int sw) {
        SwitchData swData = this.switchData[sw];
        try {
            swData.control.setLineOn(swData.channel, !swData.onIsOpen);
        }
        catch (DriverException e) {
            LOG.log(Level.SEVERE, "Error writing channel {0} on {1}: {2}", new Object[]{swData.channel, this.getPath(), e});
        }
    }

    @Override
    public void switchOff(int sw) {
        SwitchData swData = this.switchData[sw];
        try {
            swData.control.setLineOn(swData.channel, swData.onIsOpen);
        }
        catch (DriverException e) {
            LOG.log(Level.SEVERE, "Error writing channel {0} on {1}: {2}", new Object[]{swData.channel, this.getPath(), e});
        }
    }

    @Override
    public Boolean isSwitchOn(int sw) {
        if (sw < 0) {
            return null;
        }
        SwitchData swData = this.switchData[sw];
        Boolean state = swData.control.isLineOn(swData.channel);
        return state == null ? null : Boolean.valueOf(state ^ swData.onIsOpen);
    }

    static class SwitchData {
        Maq20DiscControl control;
        int channel;
        boolean onIsOpen;

        SwitchData(Maq20DiscControl control, int channel, boolean onIsOpen) {
            this.control = control;
            this.channel = channel;
            this.onIsOpen = onIsOpen;
        }
    }
}

