/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.daq.utilities;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.lsst.ccs.command.annotations.Command;
import org.lsst.ccs.commons.annotations.ConfigurationParameter;
import org.lsst.ccs.commons.annotations.ConfigurationParameterChanger;
import org.lsst.ccs.framework.HasLifecycle;
import org.lsst.ccs.utilities.image.FitsHeadersSpecificationsBuilder;
import org.lsst.ccs.utilities.image.HeaderSpecification;

public class FitsServiceConfiguration
implements HasLifecycle {
    @ConfigurationParameter(isFinal=true, maxLength=15, description="List of spec files to be read by this FITS service", units="unitless")
    private final List<String> headerFilesList = new ArrayList<String>();
    private static final Logger LOGGER = Logger.getLogger(FitsServiceConfiguration.class.getName());
    private final FitsHeadersSpecificationsBuilder headerSpecsBuilder = new FitsHeadersSpecificationsBuilder();

    @ConfigurationParameterChanger(propertyName="headerFilesList")
    public void setHeaderFilesList(List<String> list) {
        LOGGER.log(Level.FINE, "Configuring Fits Header Service with {0}", list);
        this.headerFilesList.clear();
        this.headerFilesList.addAll(list);
    }

    public void init() {
        for (String headerFile : this.headerFilesList) {
            String headerName;
            int index = headerFile.indexOf(":");
            String fileName = index >= 0 ? headerFile.substring(0, index) : headerFile;
            String string = headerName = index >= 0 ? headerFile.substring(index + 1) : null;
            if (headerName == null) {
                headerName = fileName.replace(".spec", "");
            }
            LOGGER.log(Level.FINE, "Loading spec file: {0} for extension {1}", new Object[]{fileName, headerName});
            this.headerSpecsBuilder.addSpecFile(fileName, headerName);
        }
    }

    Map<String, HeaderSpecification> getHeaderSpecificationMap() {
        LinkedHashMap<String, HeaderSpecification> resMap = new LinkedHashMap<String, HeaderSpecification>();
        for (Map.Entry<String, HeaderSpecification> e : this.headerSpecsBuilder.getHeaderSpecifications().entrySet()) {
            resMap.put(e.getKey(), new HeaderSpecification(e.getValue()));
        }
        return resMap;
    }

    @Command(type=Command.CommandType.QUERY, category=Command.CommandCategory.SYSTEM)
    public String printHeaderSpecifications() {
        StringBuilder sb = new StringBuilder("Header specifications\n");
        Map<String, HeaderSpecification> config = this.headerSpecsBuilder.getHeaderSpecifications();
        for (String header : config.keySet()) {
            sb.append("***************************\n");
            sb.append("     Header: ").append(header).append("\n");
            sb.append("***************************\n");
            HeaderSpecification spec = config.get(header);
            for (HeaderSpecification.HeaderLine line : spec.getHeaders()) {
                sb.append("## ").append(line.getKeyword()).append(" ").append(line.getMetaName()).append(" ").append((Object)line.getDataType()).append(" ").append(line.getComment()).append("\n");
            }
        }
        return sb.toString();
    }
}

