/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.ocsbridge.sim;

import java.io.Serializable;
import java.time.Duration;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.lsst.ccs.Subsystem;
import org.lsst.ccs.bus.data.AgentInfo;
import org.lsst.ccs.bus.data.KeyValueData;
import org.lsst.ccs.bus.data.KeyValueDataList;
import org.lsst.ccs.bus.messages.StatusMessage;
import org.lsst.ccs.bus.messages.StatusStateChangeNotification;
import org.lsst.ccs.bus.states.StateBundle;
import org.lsst.ccs.subsystem.ocsbridge.events.CCSSetFilterEvent;
import org.lsst.ccs.subsystem.ocsbridge.sim.ComCamFilterChangerSubsystemLayer;
import org.lsst.ccs.subsystem.ocsbridge.sim.ControlledSubsystem;
import org.lsst.ccs.subsystem.ocsbridge.sim.FilterChangerInterface;
import org.lsst.ccs.subsystem.ocsbridge.sim.MCMConfig;
import org.lsst.ccs.subsystem.ocsbridge.states.FilterState;
import org.lsst.ccs.subsystem.ocsbridge.util.CCS;
import org.lsst.ccs.subsystem.ocsbridge.util.State;
import org.lsst.ccs.subsystems.fcs.FcsEnumerations;
import org.lsst.ccs.utilities.taitime.CCSTimeStamp;

public class MainCameraFilterChangerSubsystemLayer
extends ControlledSubsystem
implements FilterChangerInterface {
    private static final Logger LOG = Logger.getLogger(ComCamFilterChangerSubsystemLayer.class.getName());
    private static final Map<FcsEnumerations.McmState, FilterState> FCS_TO_FILTER_STATE = new HashMap<FcsEnumerations.McmState, FilterState>();
    private volatile CCSSetFilterEvent ccsSetFilterEvent;
    private static final FilterStateConverter converter;

    private FilterState convertState(FcsEnumerations.McmState state) {
        return converter.convertState(state);
    }

    public MainCameraFilterChangerSubsystemLayer(Subsystem mcm, CCS ccs, MCMConfig config) {
        super(mcm, config.getFilterChangerSubsystemName(), ccs, config);
    }

    @Override
    public void setFilter(String filter) throws ExecutionException {
        if ("NONE".equals(filter)) {
            this.commandSender.sendCommand(Void.TYPE, this.getEstimatedDurationForFilterChange(filter), "setNoFilter", new Object[0]);
            this.waitUntilMoveComplete(FilterState.NOFILTER, this.getEstimatedDurationForFilterChange(filter));
        } else {
            if (filter.contains("_")) {
                filter = filter.split("_")[0];
            }
            this.commandSender.sendCommand(Void.TYPE, this.getEstimatedDurationForFilterChange(filter), "setFilterByName", filter);
            this.waitUntilMoveComplete(FilterState.LOADED, this.getEstimatedDurationForFilterChange(filter));
        }
    }

    @Override
    public Map<String, String> getAvailableFilters() throws ExecutionException {
        List l = this.commandSender.sendCommand(List.class, "listAllFilters", new Object[0]);
        HashMap<String, String> m = new HashMap<String, String>();
        l.forEach(s -> m.put((String)s, (String)s));
        return m;
    }

    @Override
    public List<String> getInstalledFilters() throws ExecutionException {
        Map m = this.commandSender.sendCommand(Map.class, "listFiltersOnChanger", new Object[0]);
        ArrayList<String> result = new ArrayList<String>();
        for (Map.Entry entry : m.entrySet()) {
            result.add(String.format("%s_%d", entry.getValue(), entry.getKey()));
        }
        result.add("NONE");
        return result;
    }

    @Override
    public String getCurrentFilter() throws ExecutionException {
        return this.commandSender.sendCommand(String.class, "printFilterONLINEName", new Object[0]);
    }

    @Override
    public Duration getEstimatedDurationForFilterChange(String filterName) {
        return Duration.ofSeconds(240L);
    }

    @Override
    protected void onConnect(AgentInfo agent, StateBundle initialState) {
        LOG.info("Filter changer connected");
        FcsEnumerations.FilterState state = (FcsEnumerations.FilterState)initialState.getState(FcsEnumerations.FilterState.class);
        FcsEnumerations.McmState mcmState = (FcsEnumerations.McmState)initialState.getState(FcsEnumerations.McmState.class);
        LOG.log(Level.INFO, "Got initial McmState {0}", mcmState);
        FcsEnumerations.AutochangerInclination inclinationState = (FcsEnumerations.AutochangerInclination)initialState.getState(FcsEnumerations.AutochangerInclination.class);
        LOG.log(Level.INFO, "Got initial AutochangerInclination {0}", inclinationState);
        this.translateFcsStateToFilterState(CCSTimeStamp.currentTime(), mcmState, null);
    }

    @Override
    protected void onDisconnect(AgentInfo agent) {
        LOG.info("Filter changer disconnected");
    }

    @Override
    protected void onStateChange(StatusStateChangeNotification statusChange) {
        StateBundle newStates = statusChange.getNewState();
        StateBundle oldStates = statusChange.getOldState();
        CCSTimeStamp when = statusChange.getCCSTimeStamp();
        StateBundle changedStates = newStates.diffState(oldStates);
        String cause = statusChange.getCause();
        changedStates.getDecodedStates().entrySet().stream().map(changedState -> (Enum)changedState.getValue()).forEachOrdered(value -> {
            if (!(value instanceof FcsEnumerations.FilterState)) {
                if (value instanceof FcsEnumerations.McmState) {
                    LOG.log(Level.INFO, "Got McmState {0}", value);
                    this.translateFcsStateToFilterState(when, (FcsEnumerations.McmState)value, cause);
                } else if (value instanceof FcsEnumerations.AutochangerInclination) {
                    LOG.log(Level.INFO, "Got AutochangerInclination {0}", value);
                }
            }
        });
    }

    private void waitUntilMoveComplete(FilterState finalState, Duration estimatedDurationForFilterChange) throws ExecutionException {
        CompletableFuture<Void> waitForStatus = this.ccs.waitForStatus(finalState);
        try {
            waitForStatus.get(estimatedDurationForFilterChange.toMillis(), TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException | TimeoutException ex) {
            throw new ExecutionException("Timeout waiting for filter change to complete", ex);
        }
    }

    private void translateFcsStateToFilterState(CCSTimeStamp when, FcsEnumerations.McmState value, String cause) {
        FilterState converted;
        LOG.log(Level.INFO, "Got filter changer state {0} ", value);
        if (value == null) {
            value = FcsEnumerations.McmState.LOADED;
        }
        if ((converted = this.convertState(value)) != null) {
            this.ccs.getAggregateStatus().add(when, new State<FilterState>(converted, cause));
        }
    }

    @Override
    protected void onEvent(StatusMessage msg) {
        Serializable data = msg.getObject();
        if (data instanceof KeyValueDataList) {
            KeyValueDataList kvdl = (KeyValueDataList)data;
            String dataKey = ((KeyValueDataList)data).getKey();
            LOG.log(Level.FINE, "Got kvdl {0} {1}", new Object[]{dataKey, kvdl.getListOfKeyValueData()});
        } else if (data instanceof KeyValueData) {
            KeyValueData sentData = (KeyValueData)data;
            String dataKey = sentData.getKey();
            LOG.log(Level.FINE, "Got kvd {0} {1}", new Object[]{dataKey, sentData.getValue()});
            if ("fcs/mcm".equals(dataKey) && sentData.getValue() instanceof KeyValueDataList) {
                String type;
                KeyValueDataList kvdl = (KeyValueDataList)sentData.getValue();
                int id = 0;
                int slot = 0;
                int position = 0;
                String name = null;
                double proximity = 0.0;
                for (KeyValueData d : kvdl) {
                    String key = d.getKey();
                    Serializable value = d.getValue();
                    if ("filter_on_autochanger_id".equals(key)) {
                        id = ((Number)value).intValue();
                        continue;
                    }
                    if ("filter_on_autochanger_name".equals(key)) {
                        name = value.toString();
                        continue;
                    }
                    if ("autochanger_trucks_position".equals(key)) {
                        position = ((Number)value).intValue();
                        continue;
                    }
                    if ("proximity".equals(key)) {
                        proximity = ((Number)value).doubleValue();
                        continue;
                    }
                    if (!"filter_previous_socketID".equals(key)) continue;
                    slot = ((Number)value).intValue();
                }
                String fullName = String.format("%s_%d", name, id);
                String string = type = name == null || name.length() == 1 ? name : String.format("other:%s", name);
                if ("NO FILTER".equals(name)) {
                    fullName = "NONE";
                    type = "other:NONE";
                }
                this.ccsSetFilterEvent = new CCSSetFilterEvent(fullName, type, slot, proximity == 0.0 ? (double)position : proximity);
                this.ccs.fireEvent(this.ccsSetFilterEvent);
                LOG.log(Level.INFO, "Sent: {0}", this.ccsSetFilterEvent);
            }
        }
    }

    @Override
    protected void onRepublishServiceData() {
        if (this.ccsSetFilterEvent != null) {
            this.ccs.fireEvent(this.ccsSetFilterEvent);
            LOG.log(Level.INFO, "Resent: {0}", this.ccsSetFilterEvent);
        }
    }

    static {
        FCS_TO_FILTER_STATE.put(FcsEnumerations.McmState.LOADING, FilterState.LOADING);
        FCS_TO_FILTER_STATE.put(FcsEnumerations.McmState.UNLOADING, FilterState.UNLOADING);
        FCS_TO_FILTER_STATE.put(FcsEnumerations.McmState.LOADING, FilterState.LOADING);
        FCS_TO_FILTER_STATE.put(FcsEnumerations.McmState.NO_FILTER, FilterState.NOFILTER);
        FCS_TO_FILTER_STATE.put(FcsEnumerations.McmState.ROTATING, FilterState.ROTATING);
        converter = new FilterStateConverter();
    }

    private static class FilterStateConverter {
        private FilterStateConverter() {
        }

        private FilterState convertStateInstantaneous(FcsEnumerations.McmState state) {
            FilterState s = (FilterState)((Object)FCS_TO_FILTER_STATE.get(state));
            if (s == null) {
                s = FilterState.LOADED;
            }
            return s;
        }

        FilterState convertState(FcsEnumerations.McmState state) {
            FilterState s = this.convertStateInstantaneous(state);
            return s;
        }
    }
}

