/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.imagehandling;

import java.io.Serializable;
import java.nio.file.Path;
import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedDeque;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.Semaphore;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.lsst.ccs.Agent;
import org.lsst.ccs.bus.data.KeyValueData;
import org.lsst.ccs.daq.ims.DAQException;
import org.lsst.ccs.daq.ims.Folder;
import org.lsst.ccs.daq.ims.Image;
import org.lsst.ccs.daq.ims.ImageListener;
import org.lsst.ccs.daq.ims.ImageMetaData;
import org.lsst.ccs.daq.ims.Store;
import org.lsst.ccs.daq.utilities.FitsService;
import org.lsst.ccs.daq.utilities.FitsServiceInterface;
import org.lsst.ccs.services.AgentStatusAggregatorService;
import org.lsst.ccs.subsystem.imagehandling.ImageEventSender;
import org.lsst.ccs.subsystem.imagehandling.ImageHandler;
import org.lsst.ccs.subsystem.imagehandling.ImageHandlingConfig;
import org.lsst.ccs.subsystem.imagehandling.PostImageFileHandling;
import org.lsst.ccs.subsystem.imagehandling.ReadThread;
import org.lsst.ccs.subsystem.imagehandling.RebNode;
import org.lsst.ccs.subsystem.imagehandling.data.FileList;
import org.lsst.ccs.subsystem.imagehandling.data.ImageReceivedEvent;
import org.lsst.ccs.utilities.ccd.FocalPlane;
import org.lsst.ccs.utilities.ccd.Reb;
import org.lsst.ccs.utilities.location.Location;
import org.lsst.ccs.utilities.location.LocationSet;
import org.lsst.ccs.utilities.taitime.CCSTimeStamp;

public class ScienceHandling {
    private static final Logger LOG = Logger.getLogger(ScienceHandling.class.getName());
    private final ImageHandlingConfig imageHandlingConfig;
    private final FitsService fitsService;
    private final PostImageFileHandling postImageFileHandling;
    private final FocalPlane geometry;
    private final Agent agent;
    private final AgentStatusAggregatorService statusAggregator;
    private final Map<String, Map<String, Serializable>> metaDataSetsForImage = new ConcurrentHashMap<String, Map<String, Serializable>>();
    private ThreadPoolExecutor daqExecutor;
    private Store scienceStore;
    private volatile ImageHandler imageHandlerPendingDarktime = null;
    private volatile boolean darkTimeArrived;
    private volatile String runNumber;
    private String previousRunNumber;
    private List<RebNode> rebNodes;

    ScienceHandling(ImageHandlingConfig imageHandlingConfig, FocalPlane geometry, FitsService fitsService, PostImageFileHandling postImageFileHandling, Agent agent, AgentStatusAggregatorService statusAggregator) {
        this.imageHandlingConfig = imageHandlingConfig;
        this.geometry = geometry;
        this.fitsService = fitsService;
        this.postImageFileHandling = postImageFileHandling;
        this.agent = agent;
        this.statusAggregator = statusAggregator;
    }

    void start() throws DAQException {
        Semaphore semaphore = new Semaphore(this.imageHandlingConfig.getDaqThreads());
        int nLocations = this.imageHandlingConfig.getLocationsToProcess().size();
        int nThreads = Math.max(Integer.getInteger("org.lsst.ccs.subsystem.imagehandling.MinDAQThreads", 40), 2 * (nLocations + 2));
        ConcurrentLinkedDeque<Store> stores = new ConcurrentLinkedDeque<Store>();
        for (int i = 0; i < nThreads; ++i) {
            stores.add(new Store(this.imageHandlingConfig.getDaqPartition()));
        }
        ThreadFactory readThreadFactory = r -> new ReadThread(r, stores, semaphore);
        this.daqExecutor = new ThreadPoolExecutor(nThreads, nThreads, 60L, TimeUnit.SECONDS, new SynchronousQueue<Runnable>(), readThreadFactory);
        this.rebNodes = new ArrayList<RebNode>();
        for (Location location : this.imageHandlingConfig.getLocationsToProcess()) {
            Reb reb = this.geometry.getRebAtLocation(location);
            this.fitsService.addReb(reb, "science");
            FitsServiceInterface fitsServiceForReb = this.fitsService.getFitsServiceForReb(reb);
            RebNode rebNode = new RebNode(reb, fitsServiceForReb);
            this.rebNodes.add(rebNode);
        }
        this.scienceStore = new Store(this.imageHandlingConfig.getDaqPartition());
        this.scienceStore.addImageListener(new ImageListener(){

            public void imageCreated(Image image) {
                if (ScienceHandling.this.imageHandlingConfig.isUseStreaming()) {
                    if (!this.checkFolder(image)) {
                        return;
                    }
                    this.handleImage(image, true);
                }
            }

            public void imageComplete(Image image) {
                KeyValueData kvd = new KeyValueData("imageReceivedEvent", (Serializable)new ImageReceivedEvent(image.getMetaData()));
                ScienceHandling.this.agent.publishSubsystemDataOnStatusBus(kvd);
                if (!ScienceHandling.this.imageHandlingConfig.isUseStreaming()) {
                    if (!this.checkFolder(image)) {
                        return;
                    }
                    this.handleImage(image, false);
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private void handleImage(Image image, boolean isStreaming) {
                ImageHandler imageHandler;
                LocationSet locationsWritten = new LocationSet(image.getMetaData().getLocations());
                locationsWritten.retainAll((Collection)ScienceHandling.this.imageHandlingConfig.getLocationsToProcess());
                ScienceHandling scienceHandling = ScienceHandling.this;
                synchronized (scienceHandling) {
                    if (!Objects.equals(ScienceHandling.this.runNumber, ScienceHandling.this.previousRunNumber)) {
                        LOG.log(Level.INFO, () -> String.format("Run number changed from %s to %s, clearing status aggregators", ScienceHandling.this.previousRunNumber, ScienceHandling.this.runNumber));
                        ScienceHandling.this.previousRunNumber = ScienceHandling.this.runNumber;
                        Instant cutoff = Instant.now().minus(Duration.ofMinutes(1L));
                        for (String subsystemToClear : ScienceHandling.this.imageHandlingConfig.getSubsystemsToClear()) {
                            long start = System.nanoTime();
                            ScienceHandling.this.statusAggregator.clearAgentDataOlderThan(subsystemToClear, cutoff);
                            LOG.log(Level.INFO, () -> String.format("Clearing status aggregator for %s took %,dns", subsystemToClear, System.nanoTime() - start));
                        }
                        ScienceHandling.this.runNumber = null;
                    }
                    imageHandler = new ImageHandler(ScienceHandling.this.getMetaDataSet(image.getMetaData().getName()), image, ScienceHandling.this.daqExecutor, ScienceHandling.this.imageHandlingConfig, ScienceHandling.this.rebNodes, isStreaming, ScienceHandling.this.postImageFileHandling);
                    ScienceHandling scienceHandling2 = ScienceHandling.this;
                    synchronized (scienceHandling2) {
                        if (ScienceHandling.this.darkTimeArrived) {
                            imageHandler.darkTimeArrived();
                            ScienceHandling.this.darkTimeArrived = false;
                        } else {
                            ScienceHandling.this.imageHandlerPendingDarktime = imageHandler;
                        }
                    }
                }
                Future<FileList> future = ScienceHandling.this.daqExecutor.submit(imageHandler);
                ScienceHandling.this.daqExecutor.submit(() -> {
                    try {
                        FileList filelist = (FileList)future.get(Integer.getInteger("org.lsst.ccs.subsystem.imagehandling.FitsTimeoutSeconds", 30).intValue(), TimeUnit.SECONDS);
                        ImageEventSender sender = new ImageEventSender(filelist, null, ScienceHandling.this.agent, locationsWritten, image.getMetaData().getName());
                        sender.run();
                    }
                    catch (InterruptedException | ExecutionException | TimeoutException x) {
                        ImageEventSender sender = new ImageEventSender(null, x, ScienceHandling.this.agent, locationsWritten, image.getMetaData().getName());
                        sender.run();
                    }
                });
            }

            private boolean checkFolder(Image image) {
                String daqFolder = ScienceHandling.this.imageHandlingConfig.getDaqFolder();
                return daqFolder == null || "".equals(daqFolder) || ScienceHandling.this.imageHandlingConfig.getDaqFolder().equals(image.getMetaData().getCreationFolderName());
            }
        });
    }

    void stop() throws DAQException {
        if (this.daqExecutor != null) {
            this.daqExecutor.shutdown();
            try {
                LOG.log(Level.INFO, "Shutting down science handling executor with {0} active tasks", this.daqExecutor.getActiveCount());
                boolean success = this.daqExecutor.awaitTermination(30L, TimeUnit.SECONDS);
                if (!success) {
                    LOG.log(Level.WARNING, "Timed out waiting for science handling executor to shutdown");
                }
            }
            catch (InterruptedException x) {
                LOG.log(Level.WARNING, "Unexpected interrupt exception while waiting for restart", x);
            }
            this.daqExecutor = null;
        }
        if (this.scienceStore != null) {
            this.scienceStore.close();
            this.scienceStore = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void darkTimeArrived(String imageName) {
        ScienceHandling scienceHandling = this;
        synchronized (scienceHandling) {
            Map<String, Serializable> existingMap = this.getMetaDataSet(imageName);
            if (!existingMap.containsKey("ExposureTime")) {
                Serializable start = existingMap.get("startIntegrationTime");
                Serializable end = existingMap.get("endIntegrationTime");
                if (start instanceof CCSTimeStamp && end instanceof CCSTimeStamp) {
                    CCSTimeStamp tsStart = (CCSTimeStamp)start;
                    CCSTimeStamp tsEnd = (CCSTimeStamp)end;
                    double exposureTime = (double)Duration.between(tsStart.getTAIInstant(), tsEnd.getTAIInstant()).toMillis() / 1000.0;
                    LOG.log(Level.INFO, "Setting missing ExposureTime to {0}", exposureTime);
                    existingMap.put("ExposureTime", Double.valueOf(exposureTime));
                }
            }
            if (this.imageHandlerPendingDarktime != null) {
                this.imageHandlerPendingDarktime.darkTimeArrived();
                this.imageHandlerPendingDarktime = null;
            } else {
                this.darkTimeArrived = true;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void runNumberArrived(String runNumber) {
        ScienceHandling scienceHandling = this;
        synchronized (scienceHandling) {
            this.runNumber = runNumber;
        }
    }

    void addMetaData(String imageName, Map<String, Serializable> headerMap) {
        LOG.log(Level.INFO, "Adding metadata keys for image {0}: {1}", new Object[]{imageName, headerMap.keySet()});
        Map<String, Serializable> existingMap = this.getMetaDataSet(imageName);
        existingMap.putAll(headerMap);
    }

    Map<String, Serializable> getMetaDataSet(String imageName) {
        return this.metaDataSetsForImage.computeIfAbsent(imageName, in -> new ConcurrentHashMap());
    }

    void simulateTrigger(Location location, ImageMetaData meta, int[] registerList, Path rawData) throws DAQException {
        this.scienceStore.simulateTrigger(location, meta, registerList, rawData);
    }

    FileList fetchImage(String imageName) throws DAQException, InterruptedException, ExecutionException {
        Store store = new Store(this.imageHandlingConfig.getDaqPartition());
        String daqFolder = this.imageHandlingConfig.getDaqFolder();
        Folder imageFolder = store.getCatalog().find(daqFolder);
        if (imageFolder == null) {
            throw new RuntimeException("Folder " + daqFolder + " not found");
        }
        Image image = imageFolder.find(imageName);
        if (image == null) {
            throw new RuntimeException("Image " + imageName + " not found");
        }
        LocationSet locationsWritten = new LocationSet(image.getMetaData().getLocations());
        locationsWritten.retainAll((Collection)this.imageHandlingConfig.getLocationsToProcess());
        Future<FileList> future = this.daqExecutor.submit(new ImageHandler(this.getMetaDataSet(imageName), image, this.daqExecutor, this.imageHandlingConfig, this.rebNodes, false, this.postImageFileHandling));
        return future.get();
    }
}

