/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.power;

import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.lsst.ccs.commons.annotations.ConfigurationParameter;
import org.lsst.ccs.drivers.commons.DriverConstants;
import org.lsst.ccs.drivers.commons.DriverException;
import org.lsst.ccs.drivers.commons.DriverTimeoutException;
import org.lsst.ccs.drivers.commons.PowerSupplyDriver;
import org.lsst.ccs.monitor.Channel;
import org.lsst.ccs.monitor.Device;
import org.lsst.ccs.subsystem.common.ErrorUtils;
import org.lsst.ccs.subsystem.power.data.PowerException;

public abstract class PowerDevice
extends Device {
    protected static final Logger LOG = Logger.getLogger(PowerDevice.class.getName());
    protected static final int NETWORK_CONN_INVALID = 1;
    protected static final int CONN_TYPE_NOT_CONFIG = 2;
    protected static final int DEVC_ID_NOT_CONFIG = 4;
    protected static final int DEVC_PARM_NOT_CONFIG = 8;
    private static final int MON_TYPE_VOLTAGE = 0;
    private static final int MON_TYPE_CURRENT = 1;
    private static final String CONN_TYPE = "connType";
    private static final String DEVC_ID = "devcId";
    private static final String DEVC_PARM = "devcParm";
    private static final Map<String, Integer> mTypeMap = new HashMap<String, Integer>();
    @ConfigurationParameter(name="devcId", category="Power", isFinal=true, units="unitless", description="The device ID: host name; serial device name")
    protected volatile String devcId;
    @ConfigurationParameter(name="devcParm", category="Power", isFinal=true, units="unitless", description="The device parameter: port number; baud rate")
    protected volatile int devcParm;
    @ConfigurationParameter(name="connType", category="Power", isFinal=true, units="unitless", description="The connection type: network; serial")
    protected volatile DriverConstants.ConnType connType;
    private final String devcName;
    protected PowerSupplyDriver psd;
    private final int options;
    private int minChan;
    private int maxChan;
    private boolean initError = false;

    public PowerDevice(String name, PowerSupplyDriver psd, int options, int minChan, int maxChan) {
        this.devcName = name;
        this.psd = psd;
        this.options = options;
        this.minChan = minChan;
        this.maxChan = maxChan;
    }

    public PowerDevice(String name, PowerSupplyDriver psd, DriverConstants.ConnType connType, String devcId, int devcParm, int options, int minChan, int maxChan) {
        this.devcName = name;
        this.psd = psd;
        if ((options & 2) != 0) {
            this.connType = connType;
        }
        if ((options & 4) != 0) {
            this.devcId = devcId;
        }
        if ((options & 8) != 0) {
            this.devcParm = devcParm;
        }
        this.options = options;
        this.minChan = minChan;
        this.maxChan = maxChan;
    }

    public void setMinChannel(int chan) {
        this.minChan = chan;
    }

    public void setMaxChannel(int chan) {
        this.maxChan = chan;
    }

    public int getMinChannel() {
        return this.minChan;
    }

    public PowerSupplyDriver getPowerDriver() {
        return this.psd;
    }

    public int getMaxChannel() {
        return this.maxChan;
    }

    public DriverConstants.ConnType getConnType() {
        return this.connType;
    }

    public String getDevcId() {
        return this.devcId;
    }

    public int getDevcParm() {
        return this.devcParm;
    }

    protected void initDevice() {
        if (this.connType == null) {
            ErrorUtils.reportConfigError((Logger)LOG, (String)this.name, (String)CONN_TYPE, (String)"is missing");
        }
        if (this.connType == DriverConstants.ConnType.NET && (this.options & 1) != 0) {
            ErrorUtils.reportConfigError((Logger)LOG, (String)this.name, (String)CONN_TYPE, (String)"is invalid");
        }
        if (this.devcId == null) {
            ErrorUtils.reportConfigError((Logger)LOG, (String)this.name, (String)DEVC_ID, (String)"is missing");
        }
        this.fullName = this.devcName + (this.devcId.isEmpty() ? "" : " (" + this.devcId + ")");
    }

    protected void initialize() {
        block2: {
            try {
                this.psd.open(this.connType, this.devcId, this.devcParm);
                this.initSensors();
                LOG.log(Level.INFO, "Connected to {0}", this.fullName);
                this.initError = false;
                this.setOnline(true);
            }
            catch (DriverException e) {
                if (this.initError) break block2;
                LOG.log(Level.SEVERE, "Error connecting to {0}: {1}", new Object[]{this.fullName, e});
                this.initError = true;
            }
        }
    }

    protected void close() {
        try {
            this.psd.close();
        }
        catch (DriverException e) {
            LOG.log(Level.SEVERE, "Error disconnecting from {0}:{1}", new Object[]{this.fullName, e});
        }
    }

    protected int[] checkChannel(Channel ch) throws Exception {
        int hwChan;
        String type = ch.getTypeStr();
        Integer mType = mTypeMap.get(type.toUpperCase());
        if (mType == null) {
            ErrorUtils.reportChannelError((Logger)LOG, (String)ch.getPath(), (String)"type", (Object)type);
        }
        if ((hwChan = ch.getHwChan()) < this.minChan || hwChan > this.maxChan) {
            ErrorUtils.reportChannelError((Logger)LOG, (String)ch.getPath(), (String)"hw channel number", (Object)hwChan);
        }
        return new int[]{mType, 0};
    }

    protected double readChannel(Channel ch) {
        double value = super.readChannel(ch);
        if (this.isOnline()) {
            int type = ch.getType();
            int hwChan = ch.getHwChan();
            try {
                value = type == 0 ? this.psd.readVoltage(hwChan) : this.psd.readCurrent(hwChan);
            }
            catch (DriverException e) {
                LOG.log(Level.SEVERE, "Error reading from {0}: {1}", new Object[]{this.fullName, e});
                this.setOnline(false);
            }
        }
        return value;
    }

    protected void writeVoltage(double voltage, int hwChan) throws PowerException {
        try {
            this.psd.setVoltage(voltage, hwChan);
        }
        catch (DriverException e) {
            this.handleException(e);
        }
    }

    protected double readVoltage(int hwChan) throws PowerException {
        try {
            return this.psd.readVoltage(hwChan);
        }
        catch (DriverException e) {
            this.handleException(e);
            return 0.0;
        }
    }

    protected void writeCurrent(double current, int hwChan) throws PowerException {
        try {
            this.psd.setCurrent(current, hwChan);
        }
        catch (DriverException e) {
            this.handleException(e);
        }
    }

    protected double readCurrent(int hwChan) throws PowerException {
        try {
            return this.psd.readCurrent(hwChan);
        }
        catch (DriverException e) {
            this.handleException(e);
            return 0.0;
        }
    }

    protected void writeOnDelay(double onDelay, int hwChan) throws PowerException {
        try {
            this.psd.setOnDelay(onDelay, hwChan);
        }
        catch (DriverException e) {
            this.handleException(e);
        }
    }

    protected void writeOffDelay(double offDelay, int hwChan) throws PowerException {
        try {
            this.psd.setOffDelay(offDelay, hwChan);
        }
        catch (DriverException e) {
            this.handleException(e);
        }
    }

    protected void writeOutput(boolean value, int hwChan) throws PowerException {
        try {
            this.psd.setOutput(value, hwChan);
        }
        catch (DriverException e) {
            this.handleException(e);
        }
    }

    protected Boolean readOutput(int hwChan) {
        if (!this.isOnline()) {
            return null;
        }
        try {
            return this.psd.getOutput(hwChan);
        }
        catch (DriverException e) {
            try {
                this.handleException(e);
            }
            catch (PowerException powerException) {
                // empty catch block
            }
            return null;
        }
    }

    protected void writeVoltageGroup() throws DriverException {
    }

    protected void readVoltageGroup() {
    }

    protected void writeCurrentGroup() throws DriverException {
    }

    protected void readCurrentGroup() {
    }

    protected void writeOnDelayGroup() throws DriverException {
    }

    protected void writeOffDelayGroup() throws DriverException {
    }

    protected void writeOutputGroup() throws DriverException {
    }

    protected void readOutputGroup() {
    }

    protected void handleException(DriverException e) throws PowerException {
        if (e instanceof DriverTimeoutException) {
            LOG.log(Level.SEVERE, "Timeout while accessing power supply: {0}", this.fullName);
            this.setOnline(false);
        }
        throw new PowerException(e.toString());
    }

    static {
        mTypeMap.put("VOLTAGE", 0);
        mTypeMap.put("CURRENT", 1);
    }
}

