/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.utilities.ccd;

import org.lsst.ccs.utilities.ccd.SegmentGeometryConstants;

public final class CCDGeometryConstants {
    private final double parallelEdge;
    private final double serialEdge;
    private final SegmentGeometryConstants segmentGeometryConstants;
    public static final int SEGMENTS_ALONG_SERIAL = 8;
    public static final int SEGMENTS_ALONG_PARALLEL = 2;
    public final int parallelSegments;
    public final int serialSegments;

    public CCDGeometryConstants(SegmentGeometryConstants segmentGeometryConstants, double parallelEdge, double serialEdge) {
        this(segmentGeometryConstants, parallelEdge, serialEdge, 2, 8);
    }

    public CCDGeometryConstants(SegmentGeometryConstants segmentGeometryConstants, double parallelEdge, double serialEdge, int parallelSegments, int serialSegments) {
        this.segmentGeometryConstants = segmentGeometryConstants;
        this.parallelEdge = parallelEdge;
        this.serialEdge = serialEdge;
        this.parallelSegments = parallelSegments;
        this.serialSegments = serialSegments;
    }

    SegmentGeometryConstants getSegmentGeometryConstraint() {
        return this.segmentGeometryConstants;
    }

    public int getSegmentParallelActiveSize() {
        return this.segmentGeometryConstants.getSegmentParallelActiveSize();
    }

    public int getSegmentSerialActiveSize() {
        return this.segmentGeometryConstants.getSegmentSerialActiveSize();
    }

    public int getSegmentSerialPrescanSize() {
        return this.segmentGeometryConstants.getSegmentSerialPrescanSize();
    }

    public int getActiveAreaParallelSize() {
        return this.getSegmentParallelActiveSize() * this.parallelSegments;
    }

    public int getActiveAreaSerialSize() {
        return this.getSegmentSerialActiveSize() * this.serialSegments;
    }

    public int getPhysicalAreaParallelSize() {
        return this.getActiveAreaParallelSize() + (int)(2.0 * this.parallelEdge);
    }

    public int getPhysicalAreaSerialSize() {
        return this.getActiveAreaSerialSize() + (int)(2.0 * this.serialEdge);
    }

    double getParallelEdge() {
        return this.parallelEdge;
    }

    double getSerialEdge() {
        return this.serialEdge;
    }
}

