/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.imagehandling;

import java.io.Serializable;
import java.nio.file.Path;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ForkJoinPool;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.lsst.ccs.Agent;
import org.lsst.ccs.ConfigurationListener;
import org.lsst.ccs.ConfigurationService;
import org.lsst.ccs.bus.data.Alert;
import org.lsst.ccs.bus.data.ConfigurationInfo;
import org.lsst.ccs.bus.data.ConfigurationParameterInfo;
import org.lsst.ccs.bus.states.AlertState;
import org.lsst.ccs.commons.annotations.LookupField;
import org.lsst.ccs.commons.annotations.LookupPath;
import org.lsst.ccs.daq.ims.DAQException;
import org.lsst.ccs.daq.ims.ImageMetaData;
import org.lsst.ccs.daq.utilities.FitsService;
import org.lsst.ccs.framework.ClearAlertHandler;
import org.lsst.ccs.framework.HasLifecycle;
import org.lsst.ccs.services.AgentStatusAggregatorService;
import org.lsst.ccs.services.alert.AlertService;
import org.lsst.ccs.subsystem.imagehandling.CommandExecutor;
import org.lsst.ccs.subsystem.imagehandling.GuiderHandling;
import org.lsst.ccs.subsystem.imagehandling.ImageHandlingConfig;
import org.lsst.ccs.subsystem.imagehandling.PostImageFileHandling;
import org.lsst.ccs.subsystem.imagehandling.ScienceHandling;
import org.lsst.ccs.subsystem.imagehandling.data.AdditionalFile;
import org.lsst.ccs.subsystem.imagehandling.data.FileList;
import org.lsst.ccs.subsystem.imagehandling.data.ImageHeaderData;
import org.lsst.ccs.utilities.ccd.FocalPlane;
import org.lsst.ccs.utilities.location.Location;

public class ImageHandlingClient
implements HasLifecycle {
    private static final Logger LOG = Logger.getLogger(ImageHandlingClient.class.getName());
    @LookupPath
    private String path;
    @LookupField(strategy=LookupField.Strategy.DESCENDANTS)
    private ImageHandlingConfig imageHandlingConfig;
    @LookupField(strategy=LookupField.Strategy.TOP)
    private Agent agent;
    @LookupField(strategy=LookupField.Strategy.TREE)
    private AgentStatusAggregatorService statusAggregator;
    @LookupField(strategy=LookupField.Strategy.TREE)
    private AlertService alertService;
    @LookupField(strategy=LookupField.Strategy.TREE)
    private ConfigurationService configurationService;
    @LookupField(strategy=LookupField.Strategy.TREE)
    private FitsService fitsService;
    private PostImageFileHandling postImageFileHandling;
    private final FocalPlane geometry;
    private GuiderHandling guiderHandling;
    private ScienceHandling scienceHandling;
    public static final String MISSING_HEADERSERVICEDATA_ALERTID = "missingHeaders";
    public static final Alert missingHeaderServiceDataAlert = new Alert("missingHeaders", "Alert raised when header service data fails to arrive when expected.");

    public ImageHandlingClient(FocalPlane geometry) {
        this.geometry = geometry;
    }

    public void init() {
        this.registerAlerts(this.alertService);
    }

    public void start() {
        LOG.log(Level.FINE, "Starting ImageHandling client {0})", this.path);
        CommandExecutor commandExecutor = new CommandExecutor(this.imageHandlingConfig, this.agent);
        this.postImageFileHandling = new PostImageFileHandling(this.imageHandlingConfig, commandExecutor, this.alertService);
    }

    public void postStart() {
        try {
            this.scienceHandling = new ScienceHandling(this.imageHandlingConfig, this.geometry, this.fitsService, this.postImageFileHandling, this.agent, this.statusAggregator);
            this.startScience(this.scienceHandling);
            this.guiderHandling = new GuiderHandling(this.imageHandlingConfig, ForkJoinPool.commonPool(), this.geometry, this.fitsService, this.postImageFileHandling);
            this.startGuiding(this.guiderHandling);
            this.configurationService.addConfigurationListener(new ConfigurationListener(){

                public void configurationChanged(ConfigurationInfo newConfigurationInfo, ConfigurationInfo oldConfigurationInfo, ConfigurationListener.ConfigurationOperation configurationOperation) {
                    List latestChanges = newConfigurationInfo.diff(oldConfigurationInfo);
                    if (!latestChanges.isEmpty()) {
                        boolean guiderRestartNeeded = false;
                        boolean scienceRestartNeeded = false;
                        for (ConfigurationParameterInfo change : latestChanges) {
                            switch (change.getParameterName()) {
                                case "guiderPartition": {
                                    guiderRestartNeeded = true;
                                    break;
                                }
                                case "guiderLocations": {
                                    guiderRestartNeeded = true;
                                    break;
                                }
                                case "daqPartition": {
                                    scienceRestartNeeded = true;
                                    break;
                                }
                                case "locations": {
                                    scienceRestartNeeded = true;
                                }
                            }
                        }
                        if (scienceRestartNeeded) {
                            LOG.info("Reloading image handling for science rafts due to configuration changes...");
                            try {
                                ImageHandlingClient.this.startScience(ImageHandlingClient.this.scienceHandling);
                            }
                            catch (DAQException x) {
                                LOG.log(Level.SEVERE, "Failed to restart image handling for science rafts after config change");
                            }
                        }
                        if (guiderRestartNeeded) {
                            LOG.info("Reloading guider due to configuration changes...");
                            try {
                                ImageHandlingClient.this.startGuiding(ImageHandlingClient.this.guiderHandling);
                            }
                            catch (DAQException x) {
                                LOG.log(Level.SEVERE, "Failed to restart guiding after config change");
                            }
                        }
                    }
                }
            });
        }
        catch (DAQException x) {
            throw new RuntimeException("Failed to connect to DAQ", x);
        }
    }

    private void startScience(ScienceHandling sh) throws DAQException {
        sh.stop();
        if (this.imageHandlingConfig.getDaqPartition() != null && !this.imageHandlingConfig.getDaqPartition().trim().isEmpty()) {
            sh.start();
        }
    }

    private void startGuiding(GuiderHandling gh) throws DAQException {
        gh.stop();
        String guiderPartition = this.imageHandlingConfig.getGuiderPartition();
        if (guiderPartition != null && !guiderPartition.trim().isEmpty()) {
            gh.start();
        }
    }

    FileList fetchImage(String imageName) throws DAQException, InterruptedException, ExecutionException {
        return this.scienceHandling.fetchImage(imageName);
    }

    void darkTimeArrived(String imageName) {
        this.scienceHandling.darkTimeArrived(imageName);
    }

    void runNumberArrived(String runNumber) {
        this.scienceHandling.runNumberArrived(runNumber);
    }

    void headerDataArrived(String imageName, List<ImageHeaderData.Header> headers) {
        this.postImageFileHandling.headerDataArrived(imageName, headers);
    }

    void setHeaderServiceEnabled(boolean enabled) {
        this.postImageFileHandling.setHeaderServiceEnabled(enabled);
    }

    void addMetaData(String imageName, Map<String, Serializable> headerMap) {
        this.scienceHandling.addMetaData(imageName, headerMap);
    }

    void simulateTrigger(Location location, ImageMetaData meta, int[] registerList, Path rawData) throws DAQException {
        this.scienceHandling.simulateTrigger(location, meta, registerList, rawData);
    }

    boolean canHandleAdditionalFiles() {
        return this.imageHandlingConfig.canHandleAdditionalFiles();
    }

    void handleAdditionFile(AdditionalFile additionalFile) {
        if (this.imageHandlingConfig.canHandleAdditionalFiles() && this.imageHandlingConfig.acceptAdditionalFileObsID(additionalFile.getObsId())) {
            LOG.log(Level.INFO, "Received AdditionalFile: {0} for {1}", new Object[]{additionalFile.getFileName(), additionalFile.getObsId()});
            this.postImageFileHandling.handleAdditionalFile(additionalFile);
        }
    }

    void registerAlerts(AlertService alertService) {
        alertService.registerAlert(missingHeaderServiceDataAlert, new ClearAlertHandler(){

            public ClearAlertHandler.ClearAlertCode canClearAlert(Alert alert, AlertState alertState) {
                return ClearAlertHandler.ClearAlertCode.CLEAR_ALERT;
            }
        });
    }
}

