/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.visualization.client;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.SocketChannel;
import java.nio.charset.StandardCharsets;
import org.lsst.ccs.visualization.client.DataMessage;
import org.lsst.ccs.visualization.client.EndMessage;
import org.lsst.ccs.visualization.client.HeaderMessage;
import org.lsst.ccs.visualization.client.StartMessage;

public class Message {
    private final int headerLength;
    private final MessageType type;
    private final String imageName;

    Message(MessageType type, int length, String imageName) {
        this.type = type;
        this.imageName = imageName;
        this.headerLength = length + 2 + imageName.length();
    }

    public String getImageName() {
        return this.imageName;
    }

    public MessageType getType() {
        return this.type;
    }

    void encode(SocketChannel socket) throws IOException {
        ByteBuffer bb = ByteBuffer.allocate(this.headerLength + 4);
        bb.putInt(this.headerLength);
        bb.put((byte)this.type.ordinal());
        bb.put((byte)this.imageName.length());
        bb.put(this.imageName.getBytes(StandardCharsets.US_ASCII));
        this.encodeAdditional(bb);
        bb.flip();
        socket.write(bb);
    }

    void encodeAdditional(ByteBuffer bb) {
    }

    public static Message decode(ByteBuffer bb) throws IOException {
        int len = bb.getInt();
        MessageType type = MessageType.values()[bb.get()];
        byte nameLength = bb.get();
        byte[] bytes = new byte[nameLength];
        bb.get(bytes);
        String name = new String(bytes, StandardCharsets.US_ASCII);
        switch (type) {
            case START: {
                return StartMessage.decode(bb, name);
            }
            case END: {
                return EndMessage.decode(bb, name);
            }
            case DATA: {
                return DataMessage.decode(bb, name);
            }
            case HEADER: {
                return HeaderMessage.decode(bb, name);
            }
        }
        throw new IOException("Unknown message type" + (Object)((Object)type));
    }

    public static enum MessageType {
        START,
        END,
        DATA,
        HEADER;

    }
}

