/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.sal;

import java.time.Duration;
import org.lsst.sal.SALCommand;
import org.lsst.sal.SALCommandResponse;
import org.lsst.sal.SALEvent;
import org.lsst.sal.SALException;
import org.lsst.sal.SALImplementation;
import org.lsst.sal.SALReceivedCommand;
import org.lsst.sal.SALStandaloneImplementation;
import org.lsst.sal.SALTelemetry;

public interface SAL<C extends SALCommand, E extends SALEvent, T extends SALTelemetry>
extends AutoCloseable {
    public SALReceivedCommand<C> getNextCommand(Duration var1) throws SALException;

    public SALCommandResponse issueCommand(C var1) throws SALException;

    public void logEvent(E var1) throws SALException;

    public E getNextEvent(Duration var1) throws SALException;

    public void sendTelemetry(T var1) throws SALException;

    public T getTelemetry(Duration var1) throws SALException;

    @Override
    public void close() throws SALException;

    public String getSALVersion();

    public String getXMLVersion();

    public String getOSPLVersion();

    public static <C extends SALCommand, E extends SALEvent, T extends SALTelemetry> SAL<C, E, T> create(Class c, String resource) {
        if (System.getenv("LSST_DDS_QOS") == null) {
            return new SALStandaloneImplementation();
        }
        return new SALImplementation(c, resource);
    }
}

