/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.ocsbridge.xml;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.lsst.ccs.bus.data.DataProviderDictionary;
import org.lsst.ccs.subsystem.ocsbridge.config.Camera;
import org.lsst.ccs.subsystem.ocsbridge.util.SerializationUtils;
import org.lsst.ccs.subsystem.ocsbridge.xml.Mapping;
import org.lsst.ccs.subsystem.ocsbridge.xml.XMLMaker2;

public class MakeXMLConfiguration {
    private final Camera camera;
    private final XMLMaker2.SALType salType;
    private final Mapping mapping;
    private final List<DictionaryConfiguration> dictionaries;

    public static MakeXMLConfiguration getInstance(Camera camera, XMLMaker2.SALType salType) {
        return new MakeXMLConfiguration(camera, salType);
    }

    public static MakeXMLConfiguration getInstance(Camera camera, XMLMaker2.SALType salType, String agentName, DataProviderDictionary dictionary) {
        return new MakeXMLConfiguration(camera, salType, agentName, dictionary);
    }

    private MakeXMLConfiguration(Camera camera, XMLMaker2.SALType salType) {
        this.salType = salType;
        this.camera = camera;
        this.mapping = Mapping.defaultMapping();
        this.dictionaries = this.initDictionaries(Arrays.stream(AgentConversionInfo.values()).filter(info -> info.getCamera() == camera).filter(info -> info.getSALType() == salType).collect(Collectors.toList()));
    }

    private MakeXMLConfiguration(Camera camera, XMLMaker2.SALType salType, String agentName, DataProviderDictionary dictionary) {
        this.salType = salType;
        this.camera = camera;
        this.mapping = Mapping.defaultMapping();
        List<Object> dicts = Collections.emptyList();
        for (AgentConversionInfo info : AgentConversionInfo.values()) {
            if (info.getSALType() != salType || !info.getAgentName().equals(agentName)) continue;
            dicts = Collections.singletonList(new DictionaryConfiguration(info, dictionary));
            break;
        }
        this.dictionaries = dicts;
    }

    private List<DictionaryConfiguration> initDictionaries(List<AgentConversionInfo> infos) {
        ArrayList<DictionaryConfiguration> dicts = new ArrayList<DictionaryConfiguration>();
        for (AgentConversionInfo info : infos) {
            dicts.add(new DictionaryConfiguration(info));
        }
        return dicts;
    }

    public String getXMLFileName() {
        return this.camera.getCscName() + this.salType.getXMLFileSuffix();
    }

    public String getXMLFileNameForAgent(String agentName) {
        return this.camera.getCscName() + "_" + agentName + this.salType.getXMLFileSuffix();
    }

    public String getCSCName() {
        return this.camera.getCscName();
    }

    public List<DictionaryConfiguration> getOrderedListOfDictionaryConfigurations() {
        return this.dictionaries;
    }

    public XMLMaker2.SALType getSALType() {
        return this.salType;
    }

    public Mapping getMapping() {
        return this.mapping;
    }

    public DictionaryConfiguration getDictionaryConfigurationForAgent(String agentName) {
        for (DictionaryConfiguration dc : this.dictionaries) {
            if (!dc.getAgentName().equals(agentName)) continue;
            return dc;
        }
        return null;
    }

    public static class DictionaryConfiguration {
        private DataProviderDictionary dictionary;
        private final AgentConversionInfo info;

        DictionaryConfiguration(AgentConversionInfo info, DataProviderDictionary dictionary) {
            this.info = info;
            this.dictionary = dictionary;
        }

        DictionaryConfiguration(AgentConversionInfo info) {
            this.info = info;
        }

        public DataProviderDictionary getDictionary() throws IOException, ClassNotFoundException {
            if (this.dictionary == null) {
                this.dictionary = SerializationUtils.readDictionaryFromFile(this.info.getDictionaryFile());
            }
            return this.dictionary;
        }

        public int getLevel() {
            return this.info.getLevel();
        }

        public String getComponentName() {
            return this.info.getComponentName();
        }

        public String getAgentName() {
            return this.info.getAgentName();
        }

        public String getCSCName() {
            return this.info.getCSCName();
        }

        public XMLMaker2.SALType getSALType() {
            return this.info.getSALType();
        }

        public Camera getCamera() {
            return this.info.getCamera();
        }
    }

    private static enum AgentConversionInfo {
        AUXTEL_TELEMETRY_ATS_FP(Camera.AUXTEL, XMLMaker2.SALType.TELEMETRY, "ats-fp", 1, "focal_plane", "ats-fp_dataDictionary.ser"),
        AUXTEL_TELEMETRY_ATS_DAQ_MONITOR(Camera.AUXTEL, XMLMaker2.SALType.TELEMETRY, "ats-daq-monitor", 1, "daq_monitor", "ats-daq-monitor_dataDictionary.ser"),
        AUXTEL_TELEMETRY_ATS_POWER(Camera.AUXTEL, XMLMaker2.SALType.TELEMETRY, "ats-power", 0, "power", "ats-power-status-dictionary.ser"),
        AUXTEL_TELEMETRY_ATS(Camera.AUXTEL, XMLMaker2.SALType.TELEMETRY, "ats", 0, "vacuum", "ats-status-dictionary.ser"),
        AUXTEL_TELEMETRY_ATS_BONN_SHUTTER(Camera.AUXTEL, XMLMaker2.SALType.TELEMETRY, "bonn-shutter", 1, "bonn_shutter", "bonn-shutter-status-dictionary.ser"),
        AUXTEL_TELEMETRY_ATS_IH(Camera.AUXTEL, XMLMaker2.SALType.TELEMETRY, "ats-ih", 1, "image_handling", "ats-ih_dataDictionary.ser"),
        AUXTEL_EVENT_ATS_FP(Camera.AUXTEL, XMLMaker2.SALType.SETTINGS_APPLIED, "ats-fp", 1, "focal_plane", "ats-fp_dataDictionary.ser"),
        AUXTEL_EVENT_ATS_DAQ_MONITOR(Camera.AUXTEL, XMLMaker2.SALType.SETTINGS_APPLIED, "ats-daq-monitor", 1, "daq_monitor", "ats-daq-monitor_dataDictionary.ser"),
        AUXTEL_EVENT_ATS_POWER(Camera.AUXTEL, XMLMaker2.SALType.SETTINGS_APPLIED, "ats-power", 1, "ats_power", "ats-power-status-dictionary.ser"),
        AUXTEL_EVENT_ATS(Camera.AUXTEL, XMLMaker2.SALType.SETTINGS_APPLIED, "ats", 1, "ats", "ats-status-dictionary.ser"),
        AUXTEL_EVENT_ATS_BONN_SHUTTER(Camera.AUXTEL, XMLMaker2.SALType.SETTINGS_APPLIED, "bonn-shutter", 1, "bonn_shutter", "bonn-shutter-status-dictionary.ser"),
        AUXTEL_EVENT_ATS_IH(Camera.AUXTEL, XMLMaker2.SALType.SETTINGS_APPLIED, "ats-ih", 1, "image_handling", "ats-ih_dataDictionary.ser"),
        COMCAM_TELEMETRY_COMCAM_FCS(Camera.COMCAM, XMLMaker2.SALType.TELEMETRY, "comcam-fcs", 0, "fcs", "comcam-fcs-status-dictionary.ser"),
        COMCAM_TELEMETRY_COMCAM_BONN_SHUTTER(Camera.COMCAM, XMLMaker2.SALType.TELEMETRY, "bonn-shutter", 1, "bonn_shutter", "comcam-bonn-shutter-status-dictionary.ser"),
        COMCAM_TELEMETRY_COMCAM_DAQ_MONITOR(Camera.COMCAM, XMLMaker2.SALType.TELEMETRY, "comcam-daq-monitor", 1, "daq_monitor", "comcam-daq-monitor_dataDictionary.ser"),
        COMCAM_TELEMETRY_COMCAM_REBPOWER(Camera.COMCAM, XMLMaker2.SALType.TELEMETRY, "comcam-rebpower", 1, "rebpower", "comcam-rebpower-status-dictionary.ser"),
        COMCAM_TELEMETRY_COMCAM_VACUUM(Camera.COMCAM, XMLMaker2.SALType.TELEMETRY, "comcam-vacuum", 1, "vacuum", "comcam-vacuum-status-dictionary.ser"),
        COMCAM_TELEMETRY_COMCAM_QUADBOX(Camera.COMCAM, XMLMaker2.SALType.TELEMETRY, "comcam-quadbox", 1, "quadbox", "comcam-quadbox-status-dictionary.ser"),
        COMCAM_TELEMETRY_COMCAM_FP(Camera.COMCAM, XMLMaker2.SALType.TELEMETRY, "comcam-fp", 1, "focal_plane", "comcam-fp_dataDictionary.ser"),
        COMCAM_TELEMETRY_COMCAM_IH(Camera.COMCAM, XMLMaker2.SALType.TELEMETRY, "comcam-ih", 1, "image_handling", "comcam-ih_dataDictionary.ser"),
        COMCAM_TELEMETRY_COMCAM_MPM(Camera.COMCAM, XMLMaker2.SALType.TELEMETRY, "comcam-mpm", 1, "mpm", "comcam-mpm-status-dictionary.ser"),
        COMCAM_EVENT_COMCAM_FCS(Camera.COMCAM, XMLMaker2.SALType.SETTINGS_APPLIED, "comcam-fcs", 1, "fcs", "comcam-fcs-status-dictionary.ser"),
        COMCAM_EVENT_COMCAM_BONN_SHUTTER(Camera.COMCAM, XMLMaker2.SALType.SETTINGS_APPLIED, "bonn-shutter", 1, "bonn_shutter", "comcam-bonn-shutter-status-dictionary.ser"),
        COMCAM_EVENT_COMCAM_DAQ_MONITOR(Camera.COMCAM, XMLMaker2.SALType.SETTINGS_APPLIED, "comcam-daq-monitor", 1, "daq_monitor", "comcam-daq-monitor_dataDictionary.ser"),
        COMCAM_EVENT_COMCAM_REBPOWER(Camera.COMCAM, XMLMaker2.SALType.SETTINGS_APPLIED, "comcam-rebpower", 1, "rebpower", "comcam-rebpower-status-dictionary.ser"),
        COMCAM_EVENT_COMCAM_VACUUM(Camera.COMCAM, XMLMaker2.SALType.SETTINGS_APPLIED, "comcam-vacuum", 1, "vacuum", "comcam-vacuum-status-dictionary.ser"),
        COMCAM_EVENT_COMCAM_QUADBOX(Camera.COMCAM, XMLMaker2.SALType.SETTINGS_APPLIED, "comcam-quadbox", 1, "quadbox", "comcam-quadbox-status-dictionary.ser"),
        COMCAM_EVENT_COMCAM_FP(Camera.COMCAM, XMLMaker2.SALType.SETTINGS_APPLIED, "comcam-fp", 1, "focal_plane", "comcam-fp_dataDictionary.ser"),
        COMCAM_EVENT_COMCAM_IH(Camera.COMCAM, XMLMaker2.SALType.SETTINGS_APPLIED, "comcam-ih", 1, "image_handling", "comcam-ih_dataDictionary.ser"),
        COMCAM_EVENT_COMCAM_MPM(Camera.COMCAM, XMLMaker2.SALType.SETTINGS_APPLIED, "comcam-mpm", 1, "mpm", "comcam-mpm-status-dictionary.ser"),
        CAMERA_TELEMETRY_QUADBOX(Camera.MAIN_CAMERA, XMLMaker2.SALType.TELEMETRY, "quadbox", 1, "quadbox", "quadbox-status-dictionary.ser"),
        CAMERA_TELEMETRY_REBPOWER(Camera.MAIN_CAMERA, XMLMaker2.SALType.TELEMETRY, "rebpower", 1, "rebpower", "rebpower-status-dictionary.ser"),
        CAMERA_TELEMETRY_HEX(Camera.MAIN_CAMERA, XMLMaker2.SALType.TELEMETRY, "hex", 1, "hex", "hex_dataDictionary.ser"),
        CAMERA_TELEMETRY_REFRIG(Camera.MAIN_CAMERA, XMLMaker2.SALType.TELEMETRY, "refrig", 1, "refrig", "refrig_dataDictionary.ser"),
        CAMERA_TELEMETRY_VACUUM(Camera.MAIN_CAMERA, XMLMaker2.SALType.TELEMETRY, "vacuum", 1, "vacuum", "vacuum_dataDictionary.ser"),
        CAMERA_TELEMETRY_DAQ_MONITOR(Camera.MAIN_CAMERA, XMLMaker2.SALType.TELEMETRY, "daq-monitor", 1, "daq_monitor", "daq-monitor_dataDictionary.ser"),
        CAMERA_TELEMETRY_FOCAL_PLANE(Camera.MAIN_CAMERA, XMLMaker2.SALType.TELEMETRY, "focal-plane", 1, "focal_plane", "focal-plane_dataDictionary.ser"),
        CAMERA_TELEMETRY_FCS(Camera.MAIN_CAMERA, XMLMaker2.SALType.TELEMETRY, "fcs", 0, "fcs", "fcs-status-dictionary.ser"),
        CAMERA_TELEMETRY_SHUTTER(Camera.MAIN_CAMERA, XMLMaker2.SALType.TELEMETRY, "cam-shutter", 0, "shutter", "cam-shutter-status-dictionary.ser"),
        CAMERA_TELEMETRY_CHILLER(Camera.MAIN_CAMERA, XMLMaker2.SALType.TELEMETRY, "chiller", 1, "chiller", "chiller_dataDictionary.ser"),
        CAMERA_EVENT_QUADBOX(Camera.MAIN_CAMERA, XMLMaker2.SALType.SETTINGS_APPLIED, "quadbox", 1, "quadbox", "quadbox-status-dictionary.ser"),
        CAMERA_EVENT_REBPOWER(Camera.MAIN_CAMERA, XMLMaker2.SALType.SETTINGS_APPLIED, "rebpower", 1, "rebpower", "rebpower-status-dictionary.ser"),
        CAMERA_EVENT_HEX(Camera.MAIN_CAMERA, XMLMaker2.SALType.SETTINGS_APPLIED, "hex", 1, "hex", "hex_dataDictionary.ser"),
        CAMERA_EVENT_REFRIG(Camera.MAIN_CAMERA, XMLMaker2.SALType.SETTINGS_APPLIED, "refrig", 1, "refrig", "refrig_dataDictionary.ser"),
        CAMERA_EVENT_VACUUM(Camera.MAIN_CAMERA, XMLMaker2.SALType.SETTINGS_APPLIED, "vacuum", 1, "vacuum", "vacuum_dataDictionary.ser"),
        CAMERA_EVENT_DAQ_MONITOR(Camera.MAIN_CAMERA, XMLMaker2.SALType.SETTINGS_APPLIED, "daq-monitor", 1, "daq_monitor", "daq-monitor_dataDictionary.ser"),
        CAMERA_EVENT_FOCAL_PLANE(Camera.MAIN_CAMERA, XMLMaker2.SALType.SETTINGS_APPLIED, "focal-plane", 1, "focal_plane", "focal-plane_dataDictionary.ser"),
        CAMERA_EVENT_IMAGE_HANDLING(Camera.MAIN_CAMERA, XMLMaker2.SALType.SETTINGS_APPLIED, "image-handling", 1, "image-handling", "image-handling-lsst-dc01_dataDictionary.ser"),
        CAMERA_EVENT_FCS(Camera.MAIN_CAMERA, XMLMaker2.SALType.SETTINGS_APPLIED, "fcs", 0, "fcs", "fcs-status-dictionary.ser"),
        CAMERA_EVENT_SHUTTER(Camera.MAIN_CAMERA, XMLMaker2.SALType.SETTINGS_APPLIED, "cam-shutter", 0, "shutter", "cam-shutter-status-dictionary.ser"),
        CAMERA_EVENT_CHILLER(Camera.MAIN_CAMERA, XMLMaker2.SALType.SETTINGS_APPLIED, "chiller", 0, "chiller", "chiller_dataDictionary.ser");

        private Camera camera;
        private XMLMaker2.SALType salType;
        private String agentName;
        private int level;
        private String componentName;
        private String dictionaryFile;

        private AgentConversionInfo(Camera camera, XMLMaker2.SALType salType, String agentName, int level, String componentName, String dictionaryFile) {
            this.camera = camera;
            this.salType = salType;
            this.agentName = agentName;
            this.level = level;
            this.componentName = componentName;
            this.dictionaryFile = dictionaryFile;
        }

        public int getLevel() {
            return this.level;
        }

        public String getComponentName() {
            return this.componentName;
        }

        public String getDictionaryFile() {
            return this.camera.cameraName() + "/" + this.dictionaryFile;
        }

        public XMLMaker2.SALType getSALType() {
            return this.salType;
        }

        public String getAgentName() {
            return this.agentName;
        }

        public Camera getCamera() {
            return this.camera;
        }

        public String getCSCName() {
            return this.camera.getCscName();
        }
    }
}

