/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.ocsbridge.sim;

import java.io.Serializable;
import java.time.Duration;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.lsst.ccs.Subsystem;
import org.lsst.ccs.bus.data.AgentInfo;
import org.lsst.ccs.bus.data.KeyValueData;
import org.lsst.ccs.bus.data.KeyValueDataList;
import org.lsst.ccs.bus.messages.StatusMessage;
import org.lsst.ccs.bus.messages.StatusStateChangeNotification;
import org.lsst.ccs.bus.states.StateBundle;
import org.lsst.ccs.subsystem.ocsbridge.sim.ComCamFilterChangerSubsystemLayer;
import org.lsst.ccs.subsystem.ocsbridge.sim.ControlledSubsystem;
import org.lsst.ccs.subsystem.ocsbridge.sim.FilterChanger;
import org.lsst.ccs.subsystem.ocsbridge.sim.FilterChangerInterface;
import org.lsst.ccs.subsystem.ocsbridge.sim.MCMConfig;
import org.lsst.ccs.subsystem.ocsbridge.util.CCS;
import org.lsst.ccs.subsystem.ocsbridge.util.State;
import org.lsst.ccs.subsystems.fcs.FcsEnumerations;
import org.lsst.ccs.utilities.taitime.CCSTimeStamp;

public class MainCameraFilterChangerSubsystemLayer
extends ControlledSubsystem
implements FilterChangerInterface {
    private static final Logger LOG = Logger.getLogger(ComCamFilterChangerSubsystemLayer.class.getName());
    private static final Map<FcsEnumerations.McmState, FilterChanger.FilterState> FCS_TO_FILTER_STATE = new HashMap<FcsEnumerations.McmState, FilterChanger.FilterState>();
    private static final FilterStateConverter converter;

    private FilterChanger.FilterState convertState(FcsEnumerations.McmState state) {
        return converter.convertState(state);
    }

    public MainCameraFilterChangerSubsystemLayer(Subsystem mcm, CCS ccs, MCMConfig config) {
        super(mcm, config.getFilterChangerSubsystemName(), ccs, config);
    }

    @Override
    public void setFilter(String filter) throws ExecutionException {
        if ("NONE".equals(filter)) {
            this.commandSender.sendCommand(Void.TYPE, this.getEstimatedDurationForFilterChange(filter), "setNoFilter", new Object[0]);
            this.waitUntilMoveComplete(FilterChanger.FilterState.NOFILTER, this.getEstimatedDurationForFilterChange(filter));
        } else {
            this.commandSender.sendCommand(Void.TYPE, this.getEstimatedDurationForFilterChange(filter), "setFilterByName", filter);
            this.waitUntilMoveComplete(FilterChanger.FilterState.LOADED, this.getEstimatedDurationForFilterChange(filter));
        }
    }

    @Override
    public Map<String, String> getAvailableFilters() throws ExecutionException {
        List l = this.commandSender.sendCommand(List.class, "listAllFilters", new Object[0]);
        HashMap<String, String> m = new HashMap<String, String>();
        l.forEach(s -> m.put((String)s, (String)s));
        return m;
    }

    @Override
    public List<String> getInstalledFilters() throws ExecutionException {
        Map m = this.commandSender.sendCommand(Map.class, "listFiltersOnChanger", new Object[0]);
        return new ArrayList<String>(m.values());
    }

    @Override
    public String getCurrentFilter() throws ExecutionException {
        return this.commandSender.sendCommand(String.class, "printFilterONLINEName", new Object[0]);
    }

    @Override
    public Duration getEstimatedDurationForFilterChange(String filterName) {
        return Duration.ofSeconds(240L);
    }

    @Override
    protected void onConnect(AgentInfo agent, StateBundle initialState) {
        LOG.info("Filter changer connected");
        FcsEnumerations.FilterState state = (FcsEnumerations.FilterState)initialState.getState(FcsEnumerations.FilterState.class);
        FcsEnumerations.McmState mcmState = (FcsEnumerations.McmState)initialState.getState(FcsEnumerations.McmState.class);
        LOG.log(Level.INFO, "Got initial McmState {0}", mcmState);
        FcsEnumerations.AutochangerInclination inclinationState = (FcsEnumerations.AutochangerInclination)initialState.getState(FcsEnumerations.AutochangerInclination.class);
        LOG.log(Level.INFO, "Got initial AutochangerInclination {0}", inclinationState);
        this.translateFcsStateToFilterState(CCSTimeStamp.currentTime(), mcmState);
    }

    @Override
    protected void onDisconnect(AgentInfo agent) {
        LOG.info("Filter changer disconnected");
    }

    @Override
    protected void onStateChange(StatusStateChangeNotification statusChange) {
        StateBundle newStates = statusChange.getNewState();
        StateBundle oldStates = statusChange.getOldState();
        CCSTimeStamp when = statusChange.getCCSTimeStamp();
        StateBundle changedStates = newStates.diffState(oldStates);
        changedStates.getDecodedStates().entrySet().stream().map(changedState -> (Enum)changedState.getValue()).forEachOrdered(value -> {
            if (!(value instanceof FcsEnumerations.FilterState)) {
                if (value instanceof FcsEnumerations.McmState) {
                    LOG.log(Level.INFO, "Got McmState {0}", value);
                    this.translateFcsStateToFilterState(when, (FcsEnumerations.McmState)value);
                } else if (value instanceof FcsEnumerations.AutochangerInclination) {
                    LOG.log(Level.INFO, "Got AutochangerInclination {0}", value);
                }
            }
        });
    }

    private void waitUntilMoveComplete(FilterChanger.FilterState finalState, Duration estimatedDurationForFilterChange) throws ExecutionException {
        CompletableFuture<Void> waitForStatus = this.ccs.waitForStatus(finalState);
        try {
            waitForStatus.get(estimatedDurationForFilterChange.toMillis(), TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException | TimeoutException ex) {
            throw new ExecutionException("Timeout waiting for filter change to complete", ex);
        }
    }

    private void translateFcsStateToFilterState(CCSTimeStamp when, FcsEnumerations.McmState value) {
        FilterChanger.FilterState converted;
        LOG.log(Level.INFO, "Got filter changer state {0} ", value);
        if (value == null) {
            value = FcsEnumerations.McmState.LOADED;
        }
        if ((converted = this.convertState(value)) != null) {
            this.ccs.getAggregateStatus().add(when, new State<FilterChanger.FilterState>(converted));
        }
    }

    @Override
    protected void onEvent(StatusMessage msg) {
        Serializable data = msg.getObject();
        if (data instanceof KeyValueDataList) {
            KeyValueDataList kvdl = (KeyValueDataList)data;
            String dataKey = ((KeyValueDataList)data).getKey();
            LOG.log(Level.INFO, "Got kvdl {0} {1}", new Object[]{dataKey, kvdl.getListOfKeyValueData()});
        } else if (data instanceof KeyValueData) {
            String dataKey = ((KeyValueData)data).getKey();
            LOG.log(Level.INFO, "Got kvd {0} {1}", new Object[]{dataKey, ((KeyValueData)data).getValue()});
        }
    }

    static {
        FCS_TO_FILTER_STATE.put(FcsEnumerations.McmState.LOADING, FilterChanger.FilterState.LOADING);
        FCS_TO_FILTER_STATE.put(FcsEnumerations.McmState.UNLOADING, FilterChanger.FilterState.UNLOADING);
        FCS_TO_FILTER_STATE.put(FcsEnumerations.McmState.LOADING, FilterChanger.FilterState.LOADING);
        FCS_TO_FILTER_STATE.put(FcsEnumerations.McmState.NO_FILTER, FilterChanger.FilterState.NOFILTER);
        FCS_TO_FILTER_STATE.put(FcsEnumerations.McmState.ROTATING, FilterChanger.FilterState.ROTATING);
        converter = new FilterStateConverter();
    }

    private static class FilterStateConverter {
        private FilterStateConverter() {
        }

        private FilterChanger.FilterState convertStateInstantaneous(FcsEnumerations.McmState state) {
            FilterChanger.FilterState s = (FilterChanger.FilterState)((Object)FCS_TO_FILTER_STATE.get(state));
            if (s == null) {
                s = FilterChanger.FilterState.LOADED;
            }
            return s;
        }

        FilterChanger.FilterState convertState(FcsEnumerations.McmState state) {
            FilterChanger.FilterState s = this.convertStateInstantaneous(state);
            return s;
        }
    }
}

