/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.ats;

import java.util.logging.Level;
import java.util.logging.Logger;
import org.lsst.ccs.commons.annotations.ConfigurationParameter;
import org.lsst.ccs.drivers.commons.DriverException;
import org.lsst.ccs.drivers.pfeiffer.TPG361;
import org.lsst.ccs.monitor.Channel;
import org.lsst.ccs.monitor.Device;
import org.lsst.ccs.subsystem.common.ErrorUtils;

public class Pfeiffer361Device
extends Device {
    public static final int CHAN_PRESSURE = 0;
    public static final int NUM_CHANS = 1;
    @ConfigurationParameter(category="Device")
    private volatile String devcName;
    private final int baudRate = 0;
    private static final Logger LOG = Logger.getLogger(Pfeiffer361Device.class.getName());
    private final TPG361 tpg = new TPG361();
    private boolean initError = false;

    protected void initDevice() {
        if (this.devcName == null) {
            ErrorUtils.reportConfigError((Logger)LOG, (String)this.name, (String)"devcName", (String)"is not specified");
        }
        this.fullName = "Pfeiffer TPC361 (" + this.devcName + ")";
    }

    protected void initialize() {
        block2: {
            try {
                this.tpg.openSerial(this.devcName, 0);
                this.setOnline(true);
                LOG.log(Level.INFO, "Connected to {0}", this.fullName);
                this.initError = false;
            }
            catch (DriverException e) {
                if (this.initError) break block2;
                LOG.log(Level.SEVERE, "Error connecting to {0}: {1}", new Object[]{this.fullName, e});
                this.initError = true;
            }
        }
    }

    public void close() {
        try {
            this.tpg.close();
        }
        catch (DriverException e) {
            LOG.log(Level.SEVERE, "Error disconnecting from {0}: {1}", new Object[]{this.fullName, e});
        }
    }

    protected int[] checkChannel(Channel ch) throws Exception {
        int hwChan = ch.getHwChan();
        String name = ch.getName();
        if (hwChan < 0 || hwChan >= 1) {
            ErrorUtils.reportChannelError((Logger)LOG, (String)name, (String)"hardware channel", (Object)hwChan);
        }
        return new int[]{0, 0};
    }

    protected double readChannel(Channel ch) {
        double value = Double.NaN;
        int chan = ch.getHwChan();
        try {
            switch (chan) {
                case 0: {
                    value = this.tpg.readPressure()[0];
                }
            }
        }
        catch (DriverException e) {
            LOG.log(Level.SEVERE, "Error reading channel {0}: {1}", new Object[]{chan, e});
            this.setOnline(false);
        }
        return value;
    }
}

