/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.ocsbridge.sim;

import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import org.lsst.ccs.imagenaming.ImageName;
import org.lsst.ccs.subsystem.imagehandling.data.JsonFile;
import org.lsst.ccs.subsystem.ocsbridge.sim.ShutterMotionProfileFitter;
import org.lsst.ccs.subsystem.shutter.common.HallTransition;
import org.lsst.ccs.subsystem.shutter.status.MotionDone;
import org.lsst.ccs.utilities.image.DateUtils;
import org.lsst.ccs.utilities.taitime.CCSTimeStamp;

public class ShutterMotionProfileSender {
    public JsonFile processMotionDone(ImageName obsId, MotionDone md, boolean isOpen, ShutterMotionProfileFitter fitter) {
        LinkedHashMap<String, Object> jsonData = new LinkedHashMap<String, Object>();
        jsonData.put("startTime", this.handleTimeStamp(md.startTime()));
        jsonData.put("startPosition", md.startPosition());
        jsonData.put("targetPosition", md.targetPosition());
        jsonData.put("endPosition", md.endPosition());
        jsonData.put("targetDuration", this.handleDuration(md.targetDuration()));
        jsonData.put("actionDuration", this.handleDuration(md.actualDuration()));
        jsonData.put("side", md.side().toString());
        jsonData.put("isOpen", isOpen);
        ArrayList encoderSamples = new ArrayList();
        for (Object es : md.encoderSamples()) {
            LinkedHashMap<String, Object> sample = new LinkedHashMap<String, Object>();
            sample.put("time", this.handleTimeStamp(es.getTime()));
            sample.put("position", es.getPosition());
            encoderSamples.add(sample);
        }
        jsonData.put("encodeSamples", encoderSamples);
        ArrayList hallTransitions = new ArrayList();
        for (HallTransition ht : md.hallTransitions()) {
            LinkedHashMap<String, Object> transition = new LinkedHashMap<String, Object>();
            transition.put("time", this.handleTimeStamp(ht.getTime()));
            transition.put("position", ht.getPosition());
            transition.put("sensorId", ht.getSensorId());
            transition.put("isOn", ht.isOn());
            hallTransitions.add(transition);
        }
        jsonData.put("hallTransitions", hallTransitions);
        if (fitter != null) {
            jsonData.put("fitResults", fitter.doFits(md));
        }
        JsonFile jsonFile = new JsonFile(obsId + "_shutterMotionProfile" + (isOpen ? "Open" : "Close") + ".json", "shutterMotionProfile", obsId, "motionProfile", jsonData);
        return jsonFile;
    }

    private Object handleTimeStamp(CCSTimeStamp time) {
        LinkedHashMap<String, Object> result = new LinkedHashMap<String, Object>();
        Instant taiInstant = time.getTAIInstant();
        result.put("tai", DateUtils.convertDateToString((Object)taiInstant));
        result.put("mjd", DateUtils.convertDateToMJD((Object)time.getTAIInstant()));
        return result;
    }

    private Object handleDuration(Duration duration) {
        return duration.toMillis();
    }
}

