/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs;

import java.util.Enumeration;
import java.util.HashSet;
import java.util.logging.Formatter;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogManager;
import java.util.logging.Logger;
import org.lsst.ccs.Agent;
import org.lsst.ccs.bus.data.AgentInfo;
import org.lsst.ccs.command.annotations.Command;
import org.lsst.ccs.commons.annotations.LookupField;
import org.lsst.ccs.services.AgentHeartBeatService;
import org.lsst.ccs.utilities.logging.StackTraceFormats;
import org.lsst.ccs.utilities.logging.TextFormatter;

public class Subsystem
extends Agent {
    @LookupField(strategy=LookupField.Strategy.TREE)
    private AgentHeartBeatService heartBeatService;

    Subsystem(String name) {
        this(name, AgentInfo.AgentType.WORKER);
    }

    public Subsystem(String name, AgentInfo.AgentType type) {
        super(name, type);
    }

    @Command(description="set the level of a Logger", type=Command.CommandType.QUERY, category=Command.CommandCategory.CORE, level=0)
    public void setLogLevel(String keyLogger, String levelName) {
        Logger logger = this.getLogger(keyLogger);
        Level level = null;
        if (levelName != null && !levelName.equals("null")) {
            level = Level.parse(levelName);
        }
        logger.setLevel(level);
    }

    @Command(description="get the level of a Logger", type=Command.CommandType.QUERY, category=Command.CommandCategory.CORE, level=0)
    public Level getLogLevel(String keyLogger) {
        Logger logger = this.getLogger(keyLogger);
        return this.getLoggerLevel(logger);
    }

    private Level getLoggerLevel(Logger logger) {
        if (logger == null) {
            return null;
        }
        Level level = logger.getLevel();
        if (level == null) {
            return this.getLoggerLevel(logger.getParent());
        }
        return level;
    }

    private Logger getLogger(String keyLogger) {
        Logger logger = LogManager.getLogManager().getLogger(keyLogger);
        if (logger == null) {
            throw new RuntimeException("Unknown logger " + keyLogger);
        }
        return logger;
    }

    @Command(description="check if the level of a Logger is inherited", type=Command.CommandType.QUERY, category=Command.CommandCategory.CORE, level=0)
    public boolean isLogLevelInherited(String keyLogger) {
        Logger logger = this.getLogger(keyLogger);
        return this.isLogLevelInherited(logger);
    }

    private boolean isLogLevelInherited(Logger logger) {
        return logger.getLevel() == null;
    }

    @Command(description="check if the level of a Logger is inherited", type=Command.CommandType.QUERY, category=Command.CommandCategory.CORE, level=0)
    public String printLoggersLevel() {
        StringBuilder sb = new StringBuilder();
        Enumeration<String> loggerNames = LogManager.getLogManager().getLoggerNames();
        while (loggerNames.hasMoreElements()) {
            String loggerName = loggerNames.nextElement();
            try {
                Logger logger = this.getLogger(loggerName);
                sb.append(loggerName).append(" (level: ").append(this.getLoggerLevel(logger)).append(", inherited: ").append(this.isLogLevelInherited(logger)).append(")\n");
            }
            catch (RuntimeException runtimeException) {}
        }
        return sb.toString();
    }

    @Command(description="sets the the depth of stacktraces in Logger messages", type=Command.CommandType.QUERY, category=Command.CommandCategory.CORE, level=1)
    public void setStackTraceDepth(int depth) {
        StackTraceFormats.setDepth((int)depth);
    }

    @Command(description="sets the format used by TextFormatter for LogEvent messages ", type=Command.CommandType.QUERY, category=Command.CommandCategory.CORE, level=1)
    public void setLogFormat(String format) {
        Formatter formatter = this.logBusHandler.getFormatter();
        if (!(formatter instanceof TextFormatter)) {
            throw new IllegalArgumentException(" formatter to LogBusHandler not a TextFormatter");
        }
        TextFormatter textFormatter = (TextFormatter)formatter;
        textFormatter.setFormat(format);
    }

    @Command(description="sets the handler (ConsoleHandler, FileHandler, LogBusHandler) log level", type=Command.CommandType.QUERY, category=Command.CommandCategory.CORE, level=0)
    public void setLogHandlerLevel(String handlerName, String level) {
        Level newLevel = Level.parse(level);
        Handler h = this.getLogHandler(handlerName);
        if (h == null) {
            throw new RuntimeException("Could not get LogHandler for name " + handlerName);
        }
        h.setLevel(newLevel);
    }

    @Command(description="sets the handler (ConsoleHandler, FileHandler, LogBusHandler) log level", type=Command.CommandType.QUERY, category=Command.CommandCategory.CORE, level=0)
    public Level getLogHandlerLevel(String handlerName) {
        Handler h = this.getLogHandler(handlerName);
        if (h == null) {
            throw new RuntimeException("Could not get LogHandler for name " + handlerName);
        }
        return h.getLevel();
    }

    @Command(description="print the levels for all the log handlers", type=Command.CommandType.QUERY, category=Command.CommandCategory.CORE, level=0)
    public String printLogHandlersLevel() {
        Handler[] handlers;
        StringBuilder sb = new StringBuilder();
        Logger rootLogger = Logger.getLogger("");
        for (Handler h : handlers = rootLogger.getHandlers()) {
            sb.append(h.getClass().getSimpleName().toLowerCase()).append(" (level: ").append(h.getLevel()).append(")\n");
        }
        sb.append(this.logBusHandler.getClass().getSimpleName().toLowerCase()).append(" (level: ").append(this.logBusHandler.getLevel()).append(")\n");
        return sb.toString();
    }

    public Handler getLogHandler(String handlerName) {
        Handler[] handlers;
        String lowerHandlerName = handlerName.toLowerCase();
        if (!lowerHandlerName.endsWith("handler")) {
            lowerHandlerName = lowerHandlerName + "handler";
        }
        if (lowerHandlerName.equals("logbushandler")) {
            return this.logBusHandler;
        }
        Logger rootLogger = Logger.getLogger("");
        for (Handler h : handlers = rootLogger.getHandlers()) {
            if (!h.getClass().getSimpleName().toLowerCase().equals(lowerHandlerName)) continue;
            return h;
        }
        return null;
    }

    @Command(description="gets the number of commands which are currently running (except the current one!)", type=Command.CommandType.QUERY, category=Command.CommandCategory.SYSTEM)
    public int getNumberCommandThreads() {
        return this.getCommandCount(new Command.CommandType[0]);
    }

    @Command(description="gets the name of commands which are currently running", type=Command.CommandType.QUERY, category=Command.CommandCategory.CORE)
    public String printRunningCommands() {
        Agent.RunningCommand action;
        StringBuilder sb = new StringBuilder();
        HashSet commands = new HashSet(this.currentQueries);
        if (commands.size() > 1) {
            sb.append("Queries:\n");
            commands.forEach(task -> {
                if (!task.request.getBasicCommand().getCommand().equals("printRunningCommands")) {
                    sb.append(task).append("\n");
                }
            });
        }
        if ((action = this.currentAction) != null) {
            sb.append("Actions:\n").append(action).append("\n");
        }
        if (!(commands = new HashSet(this.currentSignals)).isEmpty()) {
            sb.append("Signals:\n");
            commands.forEach(task -> sb.append(task).append("\n"));
        }
        return sb.toString();
    }

    @Command(description="broadcast on the status bus a message of presence", type=Command.CommandType.QUERY, category=Command.CommandCategory.SYSTEM)
    public void ping() {
        this.heartBeatService.broadcastStatus();
    }
}

