/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.visualization.server;

import java.util.AbstractMap;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

class BlockingMap<K, V> {
    private final ConcurrentMap<K, Latch<V>> map = new ConcurrentHashMap<K, Latch<V>>();
    private final Lock lock = new ReentrantLock();

    BlockingMap() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void put(K key, V value) {
        this.lock.lock();
        try {
            Latch latch = (Latch)this.map.get(key);
            if (latch == null) {
                this.map.put(key, new Latch<V>(value));
            } else {
                latch.put(value);
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    V get(K key, long timeout, TimeUnit unit) throws InterruptedException {
        Latch latch = (Latch)this.map.get(key);
        if (latch == null) {
            this.lock.lock();
            try {
                latch = (Latch)this.map.get(key);
                if (latch == null) {
                    latch = new Latch();
                    this.map.put(key, latch);
                }
            }
            finally {
                this.lock.unlock();
            }
        }
        return latch.get(timeout, unit);
    }

    void remove(K key) {
        this.lock.lock();
        try {
            this.map.remove(key);
        }
        finally {
            this.lock.unlock();
        }
    }

    Set<Map.Entry<K, V>> entrySet() {
        HashSet result = new HashSet();
        for (Map.Entry entry : this.map.entrySet()) {
            Object value = ((Latch)entry.getValue()).getImmediate();
            if (value == null) continue;
            result.add(new AbstractMap.SimpleImmutableEntry(entry.getKey(), value));
        }
        return Collections.unmodifiableSet(result);
    }

    private static class Latch<V> {
        private final CountDownLatch count;
        private V value;

        Latch() {
            this.value = null;
            this.count = new CountDownLatch(1);
        }

        Latch(V value) {
            this.value = value;
            this.count = new CountDownLatch(0);
        }

        void put(V value) {
            this.value = value;
            this.count.countDown();
        }

        V get(long timeout, TimeUnit unit) throws InterruptedException {
            this.count.await(timeout, unit);
            return this.value;
        }

        V getImmediate() {
            return this.value;
        }
    }
}

