/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.imagehandling;

import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.Collections;
import java.util.Set;
import java.util.function.Supplier;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.lsst.ccs.Subsystem;
import org.lsst.ccs.bus.data.AgentCategory;
import org.lsst.ccs.bus.data.AgentInfo;
import org.lsst.ccs.command.annotations.Command;
import org.lsst.ccs.commons.annotations.LookupField;
import org.lsst.ccs.daq.ims.ImageMetaData;
import org.lsst.ccs.description.ComponentLookup;
import org.lsst.ccs.description.ComponentNode;
import org.lsst.ccs.framework.HasLifecycle;
import org.lsst.ccs.subsystem.imagehandling.BusMessageHandler;
import org.lsst.ccs.subsystem.imagehandling.ImageHandlingClient;
import org.lsst.ccs.subsystem.imagehandling.data.FileList;
import org.lsst.ccs.utilities.location.Location;
import org.lsst.ccs.utilities.location.LocationSet;

public class ImageHandlingSubsystem
extends Subsystem
implements HasLifecycle {
    @LookupField(strategy=LookupField.Strategy.DESCENDANTS)
    private ImageHandlingClient imageHandlingClient;

    public ImageHandlingSubsystem() {
        super("image-handling", AgentInfo.AgentType.SERVICE);
        this.getAgentInfo().getAgentProperties().setProperty("agentCategory", AgentCategory.IMAGE_HANDLER.name());
    }

    public void build() {
        ComponentLookup lookupService = this.getComponentLookup();
        ComponentNode thisComponent = lookupService.getComponentNodeForObject((Object)this);
        ComponentNode focalPlaneConfigurationHandler = new ComponentNode("configHandler", (Object)new BusMessageHandler());
        lookupService.addComponentNodeToLookup(thisComponent, focalPlaneConfigurationHandler);
    }

    public void start() {
        Logger.getLogger("nom.tam.fits.HeaderCard").setLevel(Level.WARNING);
    }

    @Command(type=Command.CommandType.ACTION, description="Fetch a named image from the 2-day store")
    public FileList fetchImage(String imageName) {
        return (FileList)this.helper().precondition(this.imageHandlingClient != null, "No image handling client registered", new Supplier[0]).enterFaultOnException(true).action(() -> this.imageHandlingClient.fetchImage(imageName));
    }

    @Command(type=Command.CommandType.ACTION, description="Simulate an image arriving from the 2-day store")
    public void simulate(String imageName, String dataFolder) {
        this.helper().precondition(this.imageHandlingClient != null, "No image handling client registered", new Supplier[0]).enterFaultOnException(true).action(() -> {
            Location location = Location.of((String)"R00/RebW");
            ImageMetaData meta = new ImageMetaData(imageName, "raw", dataFolder, 7, (Set)new LocationSet(Collections.singleton(location)));
            Path metaPath = Path.of(dataFolder, new String[0]).resolve(imageName + "_R00_RebW.meta");
            if (!Files.exists(metaPath, new LinkOption[0])) {
                throw new IllegalArgumentException("Path " + metaPath + " does not exist");
            }
            Path rawData = Path.of(dataFolder, new String[0]).resolve(imageName + "_R00_RebW.raw");
            if (!Files.exists(rawData, new LinkOption[0])) {
                throw new IllegalArgumentException("Path " + rawData + " does not exist");
            }
            String line = Files.newBufferedReader(metaPath).readLine();
            int[] registerList = Arrays.stream(line.substring(1, line.length() - 1).split(",")).map(String::trim).mapToInt(Integer::parseInt).toArray();
            this.imageHandlingClient.simulateTrigger(location, meta, registerList, rawData);
        });
    }
}

