/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.camera.kafka.avro;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import javax.ws.rs.client.Entity;

public class RequestResult {
    private final Entity payloadEntity;
    private double size = Double.NaN;
    private final long start;
    private long delta;
    private final int numberOfRecords;

    RequestResult(Entity payloadEntity, int numberOfRecords) {
        this.payloadEntity = payloadEntity;
        this.start = System.currentTimeMillis();
        this.numberOfRecords = numberOfRecords;
    }

    public double getRequestSize() {
        if (Double.isNaN(this.size)) {
            this.size = RequestResult.sizeOf((Serializable)this.payloadEntity.getEntity());
        }
        return this.size;
    }

    public void done() {
        this.delta = System.currentTimeMillis() - this.start;
    }

    public long getTimeInMillis() {
        return this.delta;
    }

    public int getNumberOfRecords() {
        return this.numberOfRecords;
    }

    private static double sizeOf(Object object) {
        ByteArrayOutputStream byteOutputStream = new ByteArrayOutputStream();
        try (ObjectOutputStream objectOutputStream = new ObjectOutputStream(byteOutputStream);){
            objectOutputStream.writeObject(object);
            objectOutputStream.flush();
        }
        catch (IOException ieo) {
            ieo.printStackTrace();
            return 0.0;
        }
        return (double)byteOutputStream.toByteArray().length / 1000.0;
    }
}

