import org.lsst.ccs.description.groovy.CCSBuilder
import org.lsst.ccs.subsystem.ats.AtsMain
import org.lsst.ccs.subsystem.ats.AtsCryoCon24cDevice
import org.lsst.ccs.subsystem.ats.Pfeiffer361Device
import org.lsst.ccs.monitor.Channel

CCSBuilder builder = ["ats"]

builder.main (AtsMain) {

    CryoCon (AtsCryoCon24cDevice)

    Pfeiffer (Pfeiffer361Device)

    TempCCD (Channel, description: "CCD temperature", units: "\u00b0C",
             devcName: "CryoCon", hwChan: AtsCryoCon24cDevice.CHAN_TEMP_A, offset: -273.15)

    TempCryoHead (Channel, description: "Cryo head temperature", units: "\u00b0C",
                  devcName: "CryoCon",  hwChan: AtsCryoCon24cDevice.CHAN_TEMP_B, offset: -273.15)

    TempColdPlate (Channel, description: "Cold plate temperature", units: "\u00b0C",
                   devcName: "CryoCon",  hwChan: AtsCryoCon24cDevice.CHAN_TEMP_C, offset: -273.15)

    TempCCDSetPoint (Channel, description: "Setpoint temperature", units: "\u00b0C",
                     devcName: "CryoCon",  hwChan: AtsCryoCon24cDevice.CHAN_SETPOINT_1, offset: -273.15)

    Vacuum (Channel, description: "Cryo vacuum", units: "Torr", format: ".3g",
            devcName: "Pfeiffer",  hwChan: Pfeiffer361Device.CHAN_PRESSURE)

}
