/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.focalplane;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.lsst.ccs.StateChangeListener;
import org.lsst.ccs.commons.annotations.ConfigurationParameter;
import org.lsst.ccs.commons.annotations.LookupField;
import org.lsst.ccs.monitor.Channel;
import org.lsst.ccs.monitor.DerivedChannel;
import org.lsst.ccs.monitor.Monitor;
import org.lsst.ccs.monitor.MonitorUpdateTask;
import org.lsst.ccs.services.AgentStateService;
import org.lsst.ccs.subsystem.rafts.states.SequencerMainState;
import org.lsst.ccs.utilities.taitime.CCSTimeStamp;

public class TemperatureRunningAverageChannel
extends DerivedChannel
implements StateChangeListener {
    private static final Logger LOG = Logger.getLogger(TemperatureRunningAverageChannel.class.getName());
    @LookupField(strategy=LookupField.Strategy.SIBLINGS)
    private Map<String, Channel> channelMap = new HashMap<String, Channel>();
    @LookupField(strategy=LookupField.Strategy.TREE)
    private Monitor monitor;
    @LookupField(strategy=LookupField.Strategy.TREE)
    private AgentStateService agentStateService;
    @ConfigurationParameter(name="temperatureNames", category="General", description="List of sibling temperature channels to average", maxLength=5, units="unitless")
    protected volatile List<String> temperatureNames = new ArrayList<String>();
    private volatile double runningSum = 0.0;
    private volatile int numberOfSamples = 0;
    private volatile List<Channel> tempChannels = new ArrayList<Channel>();
    private volatile boolean evaluateAverage = false;
    private final Object lock = new Object();
    private MonitorUpdateTask thisChannelTask;

    public void init() {
        super.init();
        this.thisChannelTask = (MonitorUpdateTask)this.monitor.getMonitorUpdateTasksForChannels(new Channel[]{this}).get(0);
        this.agentStateService.addStateChangeListener((StateChangeListener)this, new Class[]{SequencerMainState.class});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void validateBulkChange(Map<String, Object> params) {
        super.validateBulkChange(params);
        Object object = this.lock;
        synchronized (object) {
            if (this.evaluateAverage) {
                throw new RuntimeException("Cannot change the list of temperature while the average is being evaluated.");
            }
            List channelList = (List)params.get("temperatureNames");
            StringBuilder sb = new StringBuilder();
            sb.append("Updated list of temperatures to average for channel ").append(this.getPath()).append("\n");
            ArrayList<Channel> tmpTempChannels = new ArrayList<Channel>();
            for (String channelName : channelList) {
                Channel c = this.channelMap.get(channelName);
                if (c == null) {
                    throw new IllegalArgumentException("Channel name " + channelName + " is invalid. No Channel was found.");
                }
                tmpTempChannels.add(c);
                sb.append(c.getPath()).append(" ");
            }
            this.tempChannels = tmpTempChannels;
            if (this.tempChannels.isEmpty()) {
                sb.append("No temperature channels were selected.");
            }
            LOG.log(Level.FINE, sb.toString());
        }
    }

    public void stateChanged(CCSTimeStamp stateTransitionTimestamp, Object changedObj, Enum<?> newState, Enum<?> oldState) {
        if (newState == SequencerMainState.INTEGRATE) {
            this.startAveraging();
        } else {
            this.endAveraging();
        }
    }

    private void resetAverage() {
        this.runningSum = 0.0;
        this.numberOfSamples = 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void startAveraging() {
        Object object = this.lock;
        synchronized (object) {
            this.evaluateAverage = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void endAveraging() {
        Object object = this.lock;
        synchronized (object) {
            this.evaluateAverage = false;
            this.resetAverage();
            this.thisChannelTask.resetForcedDataPublication();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public double evaluateDerivedValue() {
        Object object = this.lock;
        synchronized (object) {
            if (!this.evaluateAverage || this.tempChannels.isEmpty()) {
                return Double.NaN;
            }
            this.thisChannelTask.forceDataPublicationOnNextUpdates(2);
            for (Channel c : this.tempChannels) {
                double val = c.getValue();
                if (!Double.isFinite(val)) continue;
                this.runningSum += val;
                ++this.numberOfSamples;
            }
            return this.runningSum / (double)this.numberOfSamples;
        }
    }
}

