/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.bonnshutter;

import java.util.logging.Level;
import java.util.logging.Logger;
import org.lsst.ccs.bus.data.Alert;
import org.lsst.ccs.bus.states.AlertState;
import org.lsst.ccs.command.annotations.Command;
import org.lsst.ccs.commons.annotations.ConfigurationParameter;
import org.lsst.ccs.commons.annotations.LookupField;
import org.lsst.ccs.drivers.bonnshutter.BonnShutter;
import org.lsst.ccs.drivers.commons.DriverException;
import org.lsst.ccs.drivers.commons.DriverTimeoutException;
import org.lsst.ccs.framework.ClearAlertHandler;
import org.lsst.ccs.monitor.Channel;
import org.lsst.ccs.monitor.Device;
import org.lsst.ccs.services.AgentStateService;
import org.lsst.ccs.services.alert.AlertService;
import org.lsst.ccs.subsystem.bonnshutter.ShutterGPIOMonitor;
import org.lsst.ccs.subsystem.bonnshutter.alerts.BonnShutterAlerts;
import org.lsst.ccs.subsystem.bonnshutter.states.ShutterState;
import org.lsst.ccs.subsystem.common.ErrorUtils;

public class BonnDevice
extends Device {
    @LookupField(strategy=LookupField.Strategy.TREE)
    private AgentStateService stateService;
    @LookupField(strategy=LookupField.Strategy.TREE)
    private AlertService alertService;
    private static final String nameV5 = "Bonn_V5";
    private static final String nameV36 = "Bonn_V36";
    private final BonnShutter shutter = new BonnShutter();
    private ShutterGPIOMonitor gpio;
    private static final Logger LOG = Logger.getLogger(BonnDevice.class.getName());
    private Integer chanKey;
    @ConfigurationParameter(category="General", isFinal=true, description="port Id", units="unitless")
    private volatile String devcId = "/dev/ttyS0";

    BonnShutter getShutter() {
        return this.shutter;
    }

    protected void initDevice() {
        this.chanKey = 0;
        if (this.devcId == null) {
            ErrorUtils.reportConfigError((Logger)LOG, (String)this.name, (String)"devcId", (String)"is missing");
        }
        this.fullName = "BonnShutter " + this.name + " (" + this.devcId + ")";
        ClearAlertHandler deviceClearAlertHandler = new ClearAlertHandler(){

            public ClearAlertHandler.ClearAlertCode canClearAlert(Alert alert, AlertState alertState) {
                String alertId = alert.getAlertId();
                if (!alertId.equals(BonnShutterAlerts.WRONG_STATE.getId())) {
                    return ClearAlertHandler.ClearAlertCode.UNKNOWN_ALERT;
                }
                if (BonnDevice.this.stateService.isInState((Enum)ShutterState.CLOSED)) {
                    return ClearAlertHandler.ClearAlertCode.CLEAR_ALERT;
                }
                return ClearAlertHandler.ClearAlertCode.DONT_CLEAR_ALERT;
            }
        };
        this.alertService.registerAlert(BonnShutterAlerts.WRONG_STATE.newAlert(), deviceClearAlertHandler);
    }

    protected void initialize() {
        try {
            this.shutter.open(this.devcId);
            String shutterVersion = this.shutter.getVersion();
            LOG.log(Level.INFO, "Connected to " + this.fullName + " version {1}", new Object[]{this.devcId, shutterVersion});
            BonnShutter.OpenCloseStatus shutterStatus = this.shutter.getOpenCloseStatus();
            switch (shutterStatus) {
                case CLOSED_A: 
                case CLOSED_B: {
                    this.stateService.updateAgentState(new Enum[]{ShutterState.CLOSED});
                    break;
                }
                case OPEN: {
                    this.stateService.updateAgentState(new Enum[]{ShutterState.OPEN});
                    this.alertService.raiseAlert(BonnShutterAlerts.WRONG_STATE.newAlert(), AlertState.ALARM, "BonnShutter should not start in OPEN state");
                    break;
                }
                default: {
                    this.stateService.updateAgentState(new Enum[]{ShutterState.UNKNOWN});
                    this.alertService.raiseAlert(BonnShutterAlerts.WRONG_STATE.newAlert(), AlertState.ALARM, "BonnShutter should not start in UNKNOWN state");
                }
            }
            this.initSensors();
            if (this.gpio == null) {
                try {
                    this.gpio = new ShutterGPIOMonitor(this.stateService, this.alertService);
                    this.gpio.start();
                    LOG.log(Level.INFO, "GPIO Monitoring running");
                }
                catch (Exception ex) {
                    LOG.log(Level.SEVERE, "Failed to start GPIO monitoring of Bonn Shutter", ex);
                    throw new RuntimeException("GPIO not available", ex);
                }
            }
            this.setOnline(true);
            LOG.log(Level.INFO, "\n Connected to {0}", this.name);
        }
        catch (DriverException ex) {
            if (!this.inited) {
                LOG.log(Level.SEVERE, "Failed to connect to bonn shutter", ex);
            }
            this.close();
        }
        this.inited = true;
    }

    protected void close() {
        try {
            this.shutter.close();
        }
        catch (DriverException driverException) {
            // empty catch block
        }
    }

    protected int[] checkChannel(Channel ch) throws Exception {
        String type = ch.getTypeStr();
        String chanName = ch.getName();
        if (type.equals(nameV5) || type.equals(nameV36)) {
            Integer n = this.chanKey;
            Integer n2 = this.chanKey = Integer.valueOf(this.chanKey + 1);
        } else {
            ErrorUtils.reportChannelError((Logger)LOG, (String)chanName, (String)"type", (Object)type);
        }
        return new int[]{this.chanKey, 0};
    }

    protected double readChannel(Channel ch) {
        double value = super.readChannel(ch);
        String chanName = ch.getName();
        if (this.isOnline()) {
            try {
                if (chanName.equals(nameV5)) {
                    value = this.shutter.getVoltages().getV5();
                } else if (chanName.equals(nameV36)) {
                    value = this.shutter.getVoltages().getV36();
                }
            }
            catch (DriverTimeoutException et) {
                LOG.log(Level.SEVERE, this.name + " timeout reading " + chanName, et);
                this.setOnline(false);
            }
            catch (DriverException e) {
                LOG.log(Level.SEVERE, this.name + " exception reading data " + chanName, e);
            }
        }
        return value;
    }

    @Command(type=Command.CommandType.ACTION, level=1, name="reset", description="reset (after an error condition)")
    public void reset() throws DriverException {
        this.shutter.reset();
    }

    @Command(type=Command.CommandType.QUERY, level=0, name="readInfo", description="Read some shutter parameters and data")
    public String readInfo() {
        String table = "Shutter parameters, status and data\n";
        table = table + "\n  VelocityProfile  ";
        try {
            BonnShutter.ProfileParameters pp = this.shutter.getVelocityProfileParameters();
            table = table + pp.toString();
        }
        catch (DriverException ex) {
            table = table + ex.getMessage();
        }
        table = table + "\n  Voltages         ";
        try {
            BonnShutter.Voltages vv = this.shutter.getVoltages();
            table = table + vv.toString();
        }
        catch (DriverException ex) {
            table = table + ex.getMessage();
        }
        table = table + "\n  OpenCloseStatus  ";
        try {
            BonnShutter.OpenCloseStatus st = this.shutter.getOpenCloseStatus();
            table = table + st.toString();
        }
        catch (DriverException ex) {
            table = table + ex.getMessage();
        }
        table = table + "\n  Error Status     ";
        table = table + "not yet implemented";
        table = table + "\n\n";
        return table;
    }
}

