/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.common.devices.dataforth;

import java.util.logging.Logger;
import org.lsst.ccs.commons.annotations.LookupField;
import org.lsst.ccs.commons.annotations.LookupName;
import org.lsst.ccs.commons.annotations.LookupPath;
import org.lsst.ccs.drivers.commons.DriverException;
import org.lsst.ccs.drivers.dataforth.Maq20DiscretePulse;
import org.lsst.ccs.framework.HasLifecycle;
import org.lsst.ccs.subsystem.common.ErrorUtils;
import org.lsst.ccs.subsystem.common.devices.dataforth.Maq20Device;

public class Maq20PulseControl
implements HasLifecycle,
Maq20Device.Maq20Control {
    @LookupName
    protected String name;
    @LookupPath
    protected String path;
    @LookupField(strategy=LookupField.Strategy.ANCESTORS)
    protected Maq20Device maqDevc;
    protected Integer modIndex;
    protected Integer funcIndex;
    protected int pulsesPerRevn = 1;
    private static final Logger LOG = Logger.getLogger(Maq20PulseControl.class.getName());
    private Maq20Device.ModuleData modData;
    private Maq20DiscretePulse pulse;

    public void init() {
        if (this.modIndex == null) {
            ErrorUtils.reportConfigError(LOG, this.path, "modIndex", "not specified");
        }
        this.modData = this.maqDevc.getModuleData(this.modIndex);
        if (this.modData == null) {
            ErrorUtils.reportConfigError(LOG, this.path, "modIndex (" + this.modIndex + ")", "specifies non-existent module");
        }
        if (this.modData.modDef.opType != 2) {
            ErrorUtils.reportConfigError(LOG, this.path, "modIndex (" + this.modIndex + ")", "specifies non-discrete module");
        }
        if (this.funcIndex == null) {
            ErrorUtils.reportConfigError(LOG, this.path, "funcIndex", "not specified");
        }
        if (this.funcIndex != 0 && this.funcIndex != 1) {
            ErrorUtils.reportConfigError(LOG, this.path, "funcIndex (" + this.funcIndex + ")", "is not 0 or 1");
        }
        if (this.modData.discFunc[this.funcIndex] != 0) {
            ErrorUtils.reportConfigError(LOG, this.path, "funcIndex (" + this.funcIndex + ")", "specifies non-pulse function");
        }
    }

    @Override
    public void initialize() throws DriverException {
        this.pulse = this.modData.maqDiscPulse;
        this.pulse.enable(this.funcIndex.intValue());
        this.setPulsesPerRevn(this.pulsesPerRevn);
    }

    @Override
    public void close() {
        this.pulse = null;
    }

    public void setPulsesPerRevn(int pulses) throws DriverException {
        this.pulsesPerRevn = pulses;
        if (this.pulse != null) {
            this.pulse.setPulsesPerRevn(this.funcIndex.intValue(), this.pulsesPerRevn);
            this.pulse.armFunction(this.funcIndex.intValue());
        }
    }

    public int getPulsesPerRevn() {
        return this.pulsesPerRevn;
    }

    public String getName() {
        return this.name;
    }

    public String getPath() {
        return this.path;
    }
}

